@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.alicloud.dms.DmsFunctions.getEnterpriseDatabasesPlain
import com.pulumi.alicloud.dms.DmsFunctions.getEnterpriseInstancesPlain
import com.pulumi.alicloud.dms.DmsFunctions.getEnterpriseLogicDatabasesPlain
import com.pulumi.alicloud.dms.DmsFunctions.getEnterpriseProxiesPlain
import com.pulumi.alicloud.dms.DmsFunctions.getEnterpriseProxyAccessesPlain
import com.pulumi.alicloud.dms.DmsFunctions.getEnterpriseUsersPlain
import com.pulumi.alicloud.dms.DmsFunctions.getUserTenantsPlain
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseDatabasesPlainArgs
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseDatabasesPlainArgsBuilder
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseInstancesPlainArgs
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseInstancesPlainArgsBuilder
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseLogicDatabasesPlainArgs
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseLogicDatabasesPlainArgsBuilder
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseProxiesPlainArgs
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseProxiesPlainArgsBuilder
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseProxyAccessesPlainArgs
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseProxyAccessesPlainArgsBuilder
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseUsersPlainArgs
import com.pulumi.alicloud.dms.kotlin.inputs.GetEnterpriseUsersPlainArgsBuilder
import com.pulumi.alicloud.dms.kotlin.inputs.GetUserTenantsPlainArgs
import com.pulumi.alicloud.dms.kotlin.inputs.GetUserTenantsPlainArgsBuilder
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseDatabasesResult
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseInstancesResult
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseLogicDatabasesResult
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseProxiesResult
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseProxyAccessesResult
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseUsersResult
import com.pulumi.alicloud.dms.kotlin.outputs.GetUserTenantsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseDatabasesResult.Companion.toKotlin as getEnterpriseDatabasesResultToKotlin
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseInstancesResult.Companion.toKotlin as getEnterpriseInstancesResultToKotlin
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseLogicDatabasesResult.Companion.toKotlin as getEnterpriseLogicDatabasesResultToKotlin
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseProxiesResult.Companion.toKotlin as getEnterpriseProxiesResultToKotlin
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseProxyAccessesResult.Companion.toKotlin as getEnterpriseProxyAccessesResultToKotlin
import com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseUsersResult.Companion.toKotlin as getEnterpriseUsersResultToKotlin
import com.pulumi.alicloud.dms.kotlin.outputs.GetUserTenantsResult.Companion.toKotlin as getUserTenantsResultToKotlin

public object DmsFunctions {
    /**
     * This data source provides DMS Enterprise Database available to the user. [What is Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-listdatabases).
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.dms.getEnterpriseDatabases({
     *     nameRegex: "test2",
     *     instanceId: "2195118",
     * });
     * export const alicloudDmsEnterpriseDatabaseExampleId = _default.then(_default => _default.databases?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.dms.get_enterprise_databases(name_regex="test2",
     *     instance_id="2195118")
     * pulumi.export("alicloudDmsEnterpriseDatabaseExampleId", default.databases[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Dms.GetEnterpriseDatabases.Invoke(new()
     *     {
     *         NameRegex = "test2",
     *         InstanceId = "2195118",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudDmsEnterpriseDatabaseExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getEnterpriseDatabasesResult => getEnterpriseDatabasesResult&#46;Databases[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := dms.GetEnterpriseDatabases(ctx, &dms.GetEnterpriseDatabasesArgs{
     * 			NameRegex:  pulumi.StringRef("test2"),
     * 			InstanceId: "2195118",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudDmsEnterpriseDatabaseExampleId", _default.Databases[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dms.DmsFunctions;
     * import com.pulumi.alicloud.dms.inputs.GetEnterpriseDatabasesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = DmsFunctions.getEnterpriseDatabases(GetEnterpriseDatabasesArgs.builder()
     *             .nameRegex("test2")
     *             .instanceId("2195118")
     *             .build());
     *         ctx.export("alicloudDmsEnterpriseDatabaseExampleId", default_.databases()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:dms:getEnterpriseDatabases
     *       Arguments:
     *         nameRegex: test2
     *         instanceId: '2195118'
     * outputs:
     *   alicloudDmsEnterpriseDatabaseExampleId: ${default.databases[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEnterpriseDatabases.
     * @return A collection of values returned by getEnterpriseDatabases.
     */
    public suspend fun getEnterpriseDatabases(argument: GetEnterpriseDatabasesPlainArgs): GetEnterpriseDatabasesResult =
        getEnterpriseDatabasesResultToKotlin(getEnterpriseDatabasesPlain(argument.toJava()).await())

    /**
     * @see [getEnterpriseDatabases].
     * @param ids A list of Database IDs.
     * @param instanceId The instance ID of the target database.
     * @param nameRegex A regex string to filter the results by the database Schema Name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEnterpriseDatabases.
     */
    public suspend fun getEnterpriseDatabases(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetEnterpriseDatabasesResult {
        val argument = GetEnterpriseDatabasesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getEnterpriseDatabasesResultToKotlin(getEnterpriseDatabasesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterpriseDatabases].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dms&#46;kotlin&#46;inputs&#46;GetEnterpriseDatabasesPlainArgs].
     * @return A collection of values returned by getEnterpriseDatabases.
     */
    public suspend fun getEnterpriseDatabases(argument: suspend GetEnterpriseDatabasesPlainArgsBuilder.() -> Unit): GetEnterpriseDatabasesResult {
        val builder = GetEnterpriseDatabasesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterpriseDatabasesResultToKotlin(getEnterpriseDatabasesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of DMS Enterprise Instances in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.88.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const dmsEnterpriseInstancesDs = alicloud.dms.getEnterpriseInstances({
     *     netType: "CLASSIC",
     *     instanceType: "mysql",
     *     envType: "test",
     *     nameRegex: "tf_testAcc",
     *     outputFile: "dms_enterprise_instances.json",
     * });
     * export const firstDatabaseInstanceId = dmsEnterpriseInstancesDs.then(dmsEnterpriseInstancesDs => dmsEnterpriseInstancesDs.instances?.[0]?.instanceId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * dms_enterprise_instances_ds = alicloud.dms.get_enterprise_instances(net_type="CLASSIC",
     *     instance_type="mysql",
     *     env_type="test",
     *     name_regex="tf_testAcc",
     *     output_file="dms_enterprise_instances.json")
     * pulumi.export("firstDatabaseInstanceId", dms_enterprise_instances_ds.instances[0].instance_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var dmsEnterpriseInstancesDs = AliCloud.Dms.GetEnterpriseInstances.Invoke(new()
     *     {
     *         NetType = "CLASSIC",
     *         InstanceType = "mysql",
     *         EnvType = "test",
     *         NameRegex = "tf_testAcc",
     *         OutputFile = "dms_enterprise_instances.json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDatabaseInstanceId"] = dmsEnterpriseInstancesDs&#46;Apply(getEnterpriseInstancesResult => getEnterpriseInstancesResult&#46;Instances[0]?.InstanceId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		dmsEnterpriseInstancesDs, err := dms.GetEnterpriseInstances(ctx, &dms.GetEnterpriseInstancesArgs{
     * 			NetType:      pulumi.StringRef("CLASSIC"),
     * 			InstanceType: pulumi.StringRef("mysql"),
     * 			EnvType:      pulumi.StringRef("test"),
     * 			NameRegex:    pulumi.StringRef("tf_testAcc"),
     * 			OutputFile:   pulumi.StringRef("dms_enterprise_instances.json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDatabaseInstanceId", dmsEnterpriseInstancesDs.Instances[0].InstanceId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dms.DmsFunctions;
     * import com.pulumi.alicloud.dms.inputs.GetEnterpriseInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var dmsEnterpriseInstancesDs = DmsFunctions.getEnterpriseInstances(GetEnterpriseInstancesArgs.builder()
     *             .netType("CLASSIC")
     *             .instanceType("mysql")
     *             .envType("test")
     *             .nameRegex("tf_testAcc")
     *             .outputFile("dms_enterprise_instances.json")
     *             .build());
     *         ctx.export("firstDatabaseInstanceId", dmsEnterpriseInstancesDs.applyValue(getEnterpriseInstancesResult -> getEnterpriseInstancesResult.instances()[0].instanceId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   dmsEnterpriseInstancesDs:
     *     fn::invoke:
     *       Function: alicloud:dms:getEnterpriseInstances
     *       Arguments:
     *         netType: CLASSIC
     *         instanceType: mysql
     *         envType: test
     *         nameRegex: tf_testAcc
     *         outputFile: dms_enterprise_instances.json
     * outputs:
     *   firstDatabaseInstanceId: ${dmsEnterpriseInstancesDs.instances[0].instanceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEnterpriseInstances.
     * @return A collection of values returned by getEnterpriseInstances.
     */
    public suspend fun getEnterpriseInstances(argument: GetEnterpriseInstancesPlainArgs): GetEnterpriseInstancesResult =
        getEnterpriseInstancesResultToKotlin(getEnterpriseInstancesPlain(argument.toJava()).await())

    /**
     * @see [getEnterpriseInstances].
     * @param envType The type of the environment to which the database instance belongs.
     * @param instanceAliasRegex A regex string to filter the results by the DMS Enterprise Instance instance_alias.
     * @param instanceSource The source of the database instance.
     * @param instanceType The ID of the database instance.
     * @param nameRegex A regex string to filter the results by the DMS Enterprise Instance instance_alias.
     * @param netType The network type of the database instance. Valid values: CLASSIC and VPC. For more information about the valid values, see the description of the RegisterInstance operation.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param searchKey The keyword used to query database instances.
     * @param status Filter the results by status of the DMS Enterprise Instances. Valid values: `NORMAL`, `UNAVAILABLE`, `UNKNOWN`, `DELETED`, `DISABLE`.
     * @param tid The ID of the tenant in Data Management (DMS) Enterprise.
     * @return A collection of values returned by getEnterpriseInstances.
     */
    public suspend fun getEnterpriseInstances(
        envType: String? = null,
        instanceAliasRegex: String? = null,
        instanceSource: String? = null,
        instanceType: String? = null,
        nameRegex: String? = null,
        netType: String? = null,
        outputFile: String? = null,
        searchKey: String? = null,
        status: String? = null,
        tid: Int? = null,
    ): GetEnterpriseInstancesResult {
        val argument = GetEnterpriseInstancesPlainArgs(
            envType = envType,
            instanceAliasRegex = instanceAliasRegex,
            instanceSource = instanceSource,
            instanceType = instanceType,
            nameRegex = nameRegex,
            netType = netType,
            outputFile = outputFile,
            searchKey = searchKey,
            status = status,
            tid = tid,
        )
        return getEnterpriseInstancesResultToKotlin(getEnterpriseInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterpriseInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dms&#46;kotlin&#46;inputs&#46;GetEnterpriseInstancesPlainArgs].
     * @return A collection of values returned by getEnterpriseInstances.
     */
    public suspend fun getEnterpriseInstances(argument: suspend GetEnterpriseInstancesPlainArgsBuilder.() -> Unit): GetEnterpriseInstancesResult {
        val builder = GetEnterpriseInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterpriseInstancesResultToKotlin(getEnterpriseInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides DMS Enterprise Logic Database available to the user. [What is Logic Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createlogicdatabase).
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dms.DmsFunctions;
     * import com.pulumi.alicloud.dms.inputs.GetEnterpriseInstancesArgs;
     * import com.pulumi.alicloud.dms.inputs.GetEnterpriseLogicDatabasesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var dmsEnterpriseInstancesDs = DmsFunctions.getEnterpriseInstances(GetEnterpriseInstancesArgs.builder()
     *             .instanceType("mysql")
     *             .searchKey("tf-test-no-deleting")
     *             .build());
     *         final var default = DmsFunctions.getEnterpriseLogicDatabases(GetEnterpriseLogicDatabasesArgs.builder()
     *             .instanceId(dmsEnterpriseInstancesDs.applyValue(getEnterpriseInstancesResult -> getEnterpriseInstancesResult.instances()[0].instanceId()))
     *             .build());
     *         ctx.export("alicloudDmsEnterpriseLogicDatabaseExampleId", default_.databases()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   dmsEnterpriseInstancesDs:
     *     fn::invoke:
     *       Function: alicloud:dms:getEnterpriseInstances
     *       Arguments:
     *         instanceType: mysql
     *         searchKey: tf-test-no-deleting
     *   default:
     *     fn::invoke:
     *       Function: alicloud:dms:getEnterpriseLogicDatabases
     *       Arguments:
     *         instanceId: ${dmsEnterpriseInstancesDs.instances[0].instanceId}
     * outputs:
     *   alicloudDmsEnterpriseLogicDatabaseExampleId: ${default.databases[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEnterpriseLogicDatabases.
     * @return A collection of values returned by getEnterpriseLogicDatabases.
     */
    public suspend fun getEnterpriseLogicDatabases(argument: GetEnterpriseLogicDatabasesPlainArgs): GetEnterpriseLogicDatabasesResult =
        getEnterpriseLogicDatabasesResultToKotlin(getEnterpriseLogicDatabasesPlain(argument.toJava()).await())

    /**
     * @see [getEnterpriseLogicDatabases].
     * @param ids A list of Logic Database IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getEnterpriseLogicDatabases.
     */
    public suspend fun getEnterpriseLogicDatabases(
        ids: List<String>? = null,
        outputFile: String? =
            null,
    ): GetEnterpriseLogicDatabasesResult {
        val argument = GetEnterpriseLogicDatabasesPlainArgs(
            ids = ids,
            outputFile = outputFile,
        )
        return getEnterpriseLogicDatabasesResultToKotlin(getEnterpriseLogicDatabasesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterpriseLogicDatabases].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dms&#46;kotlin&#46;inputs&#46;GetEnterpriseLogicDatabasesPlainArgs].
     * @return A collection of values returned by getEnterpriseLogicDatabases.
     */
    public suspend fun getEnterpriseLogicDatabases(argument: suspend GetEnterpriseLogicDatabasesPlainArgsBuilder.() -> Unit): GetEnterpriseLogicDatabasesResult {
        val builder = GetEnterpriseLogicDatabasesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterpriseLogicDatabasesResultToKotlin(getEnterpriseLogicDatabasesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dms Enterprise Proxies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.188.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dms.getEnterpriseProxies({});
     * export const dmsEnterpriseProxyId1 = ids.then(ids => ids.proxies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dms.get_enterprise_proxies()
     * pulumi.export("dmsEnterpriseProxyId1", ids.proxies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dms.GetEnterpriseProxies.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["dmsEnterpriseProxyId1"] = ids&#46;Apply(getEnterpriseProxiesResult => getEnterpriseProxiesResult&#46;Proxies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dms.GetEnterpriseProxies(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dmsEnterpriseProxyId1", ids.Proxies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dms.DmsFunctions;
     * import com.pulumi.alicloud.dms.inputs.GetEnterpriseProxiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DmsFunctions.getEnterpriseProxies();
     *         ctx.export("dmsEnterpriseProxyId1", ids.applyValue(getEnterpriseProxiesResult -> getEnterpriseProxiesResult.proxies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dms:getEnterpriseProxies
     *       Arguments: {}
     * outputs:
     *   dmsEnterpriseProxyId1: ${ids.proxies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEnterpriseProxies.
     * @return A collection of values returned by getEnterpriseProxies.
     */
    public suspend fun getEnterpriseProxies(argument: GetEnterpriseProxiesPlainArgs): GetEnterpriseProxiesResult =
        getEnterpriseProxiesResultToKotlin(getEnterpriseProxiesPlain(argument.toJava()).await())

    /**
     * @see [getEnterpriseProxies].
     * @param ids A list of Proxy IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tid The ID of the tenant.
     * @return A collection of values returned by getEnterpriseProxies.
     */
    public suspend fun getEnterpriseProxies(
        ids: List<String>? = null,
        outputFile: String? = null,
        tid: String? = null,
    ): GetEnterpriseProxiesResult {
        val argument = GetEnterpriseProxiesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            tid = tid,
        )
        return getEnterpriseProxiesResultToKotlin(getEnterpriseProxiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterpriseProxies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dms&#46;kotlin&#46;inputs&#46;GetEnterpriseProxiesPlainArgs].
     * @return A collection of values returned by getEnterpriseProxies.
     */
    public suspend fun getEnterpriseProxies(argument: suspend GetEnterpriseProxiesPlainArgsBuilder.() -> Unit): GetEnterpriseProxiesResult {
        val builder = GetEnterpriseProxiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterpriseProxiesResultToKotlin(getEnterpriseProxiesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides DMS Enterprise Proxy Access available to the user.[What is Proxy Access](https://next.api.alibabacloud.com/document/dms-enterprise/2018-11-01/CreateProxyAccess)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultEnterpriseProxyAccess = new alicloud.dms.EnterpriseProxyAccess("default", {
     *     indepPassword: "PASSWORD-DEMO",
     *     proxyId: "1881",
     *     indepAccount: "dmstest",
     *     userId: "104442",
     * });
     * const default = alicloud.dms.getEnterpriseProxyAccessesOutput({
     *     ids: [defaultEnterpriseProxyAccess&#46;id],
     *     proxyId: "1881",
     * });
     * export const alicloudDmsProxyAccesesExampleId = _default.apply(_default => _default.accesses?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_enterprise_proxy_access = alicloud.dms.EnterpriseProxyAccess("default",
     *     indep_password="PASSWORD-DEMO",
     *     proxy_id="1881",
     *     indep_account="dmstest",
     *     user_id="104442")
     * default = alicloud.dms.get_enterprise_proxy_accesses_output(ids=[default_enterprise_proxy_access&#46;id],
     *     proxy_id="1881")
     * pulumi.export("alicloudDmsProxyAccesesExampleId", default.accesses[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultEnterpriseProxyAccess = new AliCloud.Dms.EnterpriseProxyAccess("default", new()
     *     {
     *         IndepPassword = "PASSWORD-DEMO",
     *         ProxyId = "1881",
     *         IndepAccount = "dmstest",
     *         UserId = "104442",
     *     });
     *     var @default = AliCloud.Dms.GetEnterpriseProxyAccesses.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultEnterpriseProxyAccess.Id,
     *         },
     *         ProxyId = "1881",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudDmsProxyAccesesExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getEnterpriseProxyAccessesResult => getEnterpriseProxyAccessesResult&#46;Accesses[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * defaultEnterpriseProxyAccess, err := dms.NewEnterpriseProxyAccess(ctx, "default", &dms.EnterpriseProxyAccessArgs{
     * IndepPassword: pulumi.String("PASSWORD-DEMO"),
     * ProxyId: pulumi.String("1881"),
     * IndepAccount: pulumi.String("dmstest"),
     * UserId: pulumi.String("104442"),
     * })
     * if err != nil {
     * return err
     * }
     * _default := dms.GetEnterpriseProxyAccessesOutput(ctx, dms.GetEnterpriseProxyAccessesOutputArgs{
     * Ids: pulumi.StringArray{
     * defaultEnterpriseProxyAccess.ID(),
     * },
     * ProxyId: pulumi.String("1881"),
     * }, nil);
     * ctx.Export("alicloudDmsProxyAccesesExampleId", _default.ApplyT(func(_default dms.GetEnterpriseProxyAccessesResult) (*string, error) {
     * return &default.Accesses[0].Id, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dms.EnterpriseProxyAccess;
     * import com.pulumi.alicloud.dms.EnterpriseProxyAccessArgs;
     * import com.pulumi.alicloud.dms.DmsFunctions;
     * import com.pulumi.alicloud.dms.inputs.GetEnterpriseProxyAccessesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultEnterpriseProxyAccess = new EnterpriseProxyAccess("defaultEnterpriseProxyAccess", EnterpriseProxyAccessArgs.builder()
     *             .indepPassword("PASSWORD-DEMO")
     *             .proxyId(1881)
     *             .indepAccount("dmstest")
     *             .userId(104442)
     *             .build());
     *         final var default = DmsFunctions.getEnterpriseProxyAccesses(GetEnterpriseProxyAccessesArgs.builder()
     *             .ids(defaultEnterpriseProxyAccess.id())
     *             .proxyId(1881)
     *             .build());
     *         ctx.export("alicloudDmsProxyAccesesExampleId", default_.applyValue(default_ -> default_.accesses()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultEnterpriseProxyAccess:
     *     type: alicloud:dms:EnterpriseProxyAccess
     *     name: default
     *     properties:
     *       indepPassword: PASSWORD-DEMO
     *       proxyId: 1881
     *       indepAccount: dmstest
     *       userId: 104442
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:dms:getEnterpriseProxyAccesses
     *       Arguments:
     *         ids:
     *           - ${defaultEnterpriseProxyAccess.id}
     *         proxyId: 1881
     * outputs:
     *   alicloudDmsProxyAccesesExampleId: ${default.accesses[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEnterpriseProxyAccesses.
     * @return A collection of values returned by getEnterpriseProxyAccesses.
     */
    public suspend fun getEnterpriseProxyAccesses(argument: GetEnterpriseProxyAccessesPlainArgs): GetEnterpriseProxyAccessesResult =
        getEnterpriseProxyAccessesResultToKotlin(getEnterpriseProxyAccessesPlain(argument.toJava()).await())

    /**
     * @see [getEnterpriseProxyAccesses].
     * @param enableDetails
     * @param ids A list of Proxy Access IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param proxyId The ID of the security agent.
     * @return A collection of values returned by getEnterpriseProxyAccesses.
     */
    public suspend fun getEnterpriseProxyAccesses(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        proxyId: String,
    ): GetEnterpriseProxyAccessesResult {
        val argument = GetEnterpriseProxyAccessesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            proxyId = proxyId,
        )
        return getEnterpriseProxyAccessesResultToKotlin(getEnterpriseProxyAccessesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterpriseProxyAccesses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dms&#46;kotlin&#46;inputs&#46;GetEnterpriseProxyAccessesPlainArgs].
     * @return A collection of values returned by getEnterpriseProxyAccesses.
     */
    public suspend fun getEnterpriseProxyAccesses(argument: suspend GetEnterpriseProxyAccessesPlainArgsBuilder.() -> Unit): GetEnterpriseProxyAccessesResult {
        val builder = GetEnterpriseProxyAccessesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterpriseProxyAccessesResultToKotlin(getEnterpriseProxyAccessesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of DMS Enterprise Users in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.90.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const dmsEnterpriseUsersDs = alicloud.dms.getEnterpriseUsers({
     *     ids: ["uid"],
     *     role: "USER",
     *     status: "NORMAL",
     * });
     * export const firstUserId = dmsEnterpriseUsersDs.then(dmsEnterpriseUsersDs => dmsEnterpriseUsersDs.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * dms_enterprise_users_ds = alicloud.dms.get_enterprise_users(ids=["uid"],
     *     role="USER",
     *     status="NORMAL")
     * pulumi.export("firstUserId", dms_enterprise_users_ds.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var dmsEnterpriseUsersDs = AliCloud.Dms.GetEnterpriseUsers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "uid",
     *         },
     *         Role = "USER",
     *         Status = "NORMAL",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstUserId"] = dmsEnterpriseUsersDs&#46;Apply(getEnterpriseUsersResult => getEnterpriseUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		dmsEnterpriseUsersDs, err := dms.GetEnterpriseUsers(ctx, &dms.GetEnterpriseUsersArgs{
     * 			Ids: []string{
     * 				"uid",
     * 			},
     * 			Role:   pulumi.StringRef("USER"),
     * 			Status: pulumi.StringRef("NORMAL"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstUserId", dmsEnterpriseUsersDs.Users[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dms.DmsFunctions;
     * import com.pulumi.alicloud.dms.inputs.GetEnterpriseUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var dmsEnterpriseUsersDs = DmsFunctions.getEnterpriseUsers(GetEnterpriseUsersArgs.builder()
     *             .ids("uid")
     *             .role("USER")
     *             .status("NORMAL")
     *             .build());
     *         ctx.export("firstUserId", dmsEnterpriseUsersDs.applyValue(getEnterpriseUsersResult -> getEnterpriseUsersResult.users()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   dmsEnterpriseUsersDs:
     *     fn::invoke:
     *       Function: alicloud:dms:getEnterpriseUsers
     *       Arguments:
     *         ids:
     *           - uid
     *         role: USER
     *         status: NORMAL
     * outputs:
     *   firstUserId: ${dmsEnterpriseUsersDs.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEnterpriseUsers.
     * @return A collection of values returned by getEnterpriseUsers.
     */
    public suspend fun getEnterpriseUsers(argument: GetEnterpriseUsersPlainArgs): GetEnterpriseUsersResult =
        getEnterpriseUsersResultToKotlin(getEnterpriseUsersPlain(argument.toJava()).await())

    /**
     * @see [getEnterpriseUsers].
     * @param ids A list of DMS Enterprise User IDs (UID).
     * @param nameRegex A regex string to filter the results by the DMS Enterprise User nick_name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param role The role of the user to query.
     * @param searchKey The keyword used to query users.
     * @param status The status of the user.
     * @param tid The ID of the tenant in DMS Enterprise.
     * @return A collection of values returned by getEnterpriseUsers.
     */
    public suspend fun getEnterpriseUsers(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        role: String? = null,
        searchKey: String? = null,
        status: String? = null,
        tid: Int? = null,
    ): GetEnterpriseUsersResult {
        val argument = GetEnterpriseUsersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            role = role,
            searchKey = searchKey,
            status = status,
            tid = tid,
        )
        return getEnterpriseUsersResultToKotlin(getEnterpriseUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnterpriseUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dms&#46;kotlin&#46;inputs&#46;GetEnterpriseUsersPlainArgs].
     * @return A collection of values returned by getEnterpriseUsers.
     */
    public suspend fun getEnterpriseUsers(argument: suspend GetEnterpriseUsersPlainArgsBuilder.() -> Unit): GetEnterpriseUsersResult {
        val builder = GetEnterpriseUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnterpriseUsersResultToKotlin(getEnterpriseUsersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of DMS User Tenants in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.161.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const default = alicloud.dms.getUserTenants({
     *     status: "ACTIVE",
     * });
     * export const tid = _default.then(_default => _default.ids?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * default = alicloud.dms.get_user_tenants(status="ACTIVE")
     * pulumi.export("tid", default.ids[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var @default = AliCloud.Dms.GetUserTenants.Invoke(new()
     *     {
     *         Status = "ACTIVE",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["tid"] = @default&#46;Apply(@default => @default&#46;Apply(getUserTenantsResult => getUserTenantsResult&#46;Ids[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_default, err := dms.GetUserTenants(ctx, &dms.GetUserTenantsArgs{
     * 			Status: pulumi.StringRef("ACTIVE"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("tid", _default.Ids[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dms.DmsFunctions;
     * import com.pulumi.alicloud.dms.inputs.GetUserTenantsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var default = DmsFunctions.getUserTenants(GetUserTenantsArgs.builder()
     *             .status("ACTIVE")
     *             .build());
     *         ctx.export("tid", default_.ids()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   default:
     *     fn::invoke:
     *       Function: alicloud:dms:getUserTenants
     *       Arguments:
     *         status: ACTIVE
     * outputs:
     *   tid: ${default.ids[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserTenants.
     * @return A collection of values returned by getUserTenants.
     */
    public suspend fun getUserTenants(argument: GetUserTenantsPlainArgs): GetUserTenantsResult =
        getUserTenantsResultToKotlin(getUserTenantsPlain(argument.toJava()).await())

    /**
     * @see [getUserTenants].
     * @param ids A list of DMS User Tenant IDs (TID).
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the user tenant.
     * @return A collection of values returned by getUserTenants.
     */
    public suspend fun getUserTenants(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetUserTenantsResult {
        val argument = GetUserTenantsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getUserTenantsResultToKotlin(getUserTenantsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserTenants].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dms&#46;kotlin&#46;inputs&#46;GetUserTenantsPlainArgs].
     * @return A collection of values returned by getUserTenants.
     */
    public suspend fun getUserTenants(argument: suspend GetUserTenantsPlainArgsBuilder.() -> Unit): GetUserTenantsResult {
        val builder = GetUserTenantsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserTenantsResultToKotlin(getUserTenantsPlain(builtArgument.toJava()).await())
    }
}
