@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnterpriseAuthorityTemplate].
 */
@PulumiTagMarker
public class EnterpriseAuthorityTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterpriseAuthorityTemplateArgs = EnterpriseAuthorityTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnterpriseAuthorityTemplateArgsBuilder.() -> Unit) {
        val builder = EnterpriseAuthorityTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnterpriseAuthorityTemplate {
        val builtJavaResource =
            com.pulumi.alicloud.dms.EnterpriseAuthorityTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnterpriseAuthorityTemplate(builtJavaResource)
    }
}

/**
 * Provides a DMS Enterprise Authority Template resource.
 * For information about DMS Enterprise Authority Template and how to use it, see [What is Authority Template](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createauthoritytemplate).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.dms.getUserTenants({
 *     status: "ACTIVE",
 * });
 * const defaultEnterpriseAuthorityTemplate = new alicloud.dms.EnterpriseAuthorityTemplate("default", {
 *     tid: _default.then(_default => _default.ids?.[0]),
 *     authorityTemplateName: name,
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.dms.get_user_tenants(status="ACTIVE")
 * default_enterprise_authority_template = alicloud.dms.EnterpriseAuthorityTemplate("default",
 *     tid=default.ids[0],
 *     authority_template_name=name,
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Dms.GetUserTenants.Invoke(new()
 *     {
 *         Status = "ACTIVE",
 *     });
 *     var defaultEnterpriseAuthorityTemplate = new AliCloud.Dms.EnterpriseAuthorityTemplate("default", new()
 *     {
 *         Tid = @default.Apply(@default => @default.Apply(getUserTenantsResult => getUserTenantsResult.Ids[0])),
 *         AuthorityTemplateName = name,
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := dms.GetUserTenants(ctx, &dms.GetUserTenantsArgs{
 * 			Status: pulumi.StringRef("ACTIVE"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewEnterpriseAuthorityTemplate(ctx, "default", &dms.EnterpriseAuthorityTemplateArgs{
 * 			Tid:                   pulumi.String(_default.Ids[0]),
 * 			AuthorityTemplateName: pulumi.String(name),
 * 			Description:           pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dms.DmsFunctions;
 * import com.pulumi.alicloud.dms.inputs.GetUserTenantsArgs;
 * import com.pulumi.alicloud.dms.EnterpriseAuthorityTemplate;
 * import com.pulumi.alicloud.dms.EnterpriseAuthorityTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = DmsFunctions.getUserTenants(GetUserTenantsArgs.builder()
 *             .status("ACTIVE")
 *             .build());
 *         var defaultEnterpriseAuthorityTemplate = new EnterpriseAuthorityTemplate("defaultEnterpriseAuthorityTemplate", EnterpriseAuthorityTemplateArgs.builder()
 *             .tid(default_.ids()[0])
 *             .authorityTemplateName(name)
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultEnterpriseAuthorityTemplate:
 *     type: alicloud:dms:EnterpriseAuthorityTemplate
 *     name: default
 *     properties:
 *       tid: ${default.ids[0]}
 *       authorityTemplateName: ${name}
 *       description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:dms:getUserTenants
 *       Arguments:
 *         status: ACTIVE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise Authority Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseAuthorityTemplate:EnterpriseAuthorityTemplate example <tid>:<authority_template_id>
 * ```
 */
public class EnterpriseAuthorityTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.dms.EnterpriseAuthorityTemplate,
) : KotlinCustomResource(javaResource, EnterpriseAuthorityTemplateMapper) {
    /**
     * Permission template ID.
     */
    public val authorityTemplateId: Output<Int>
        get() = javaResource.authorityTemplateId().applyValue({ args0 -> args0 })

    /**
     * Permission Template name.
     */
    public val authorityTemplateName: Output<String>
        get() = javaResource.authorityTemplateName().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Permission template description information.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tenant ID.
     */
    public val tid: Output<Int>
        get() = javaResource.tid().applyValue({ args0 -> args0 })
}

public object EnterpriseAuthorityTemplateMapper : ResourceMapper<EnterpriseAuthorityTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dms.EnterpriseAuthorityTemplate::class == javaResource::class

    override fun map(javaResource: Resource): EnterpriseAuthorityTemplate =
        EnterpriseAuthorityTemplate(
            javaResource as
                com.pulumi.alicloud.dms.EnterpriseAuthorityTemplate,
        )
}

/**
 * @see [EnterpriseAuthorityTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterpriseAuthorityTemplate].
 */
public suspend fun enterpriseAuthorityTemplate(
    name: String,
    block: suspend EnterpriseAuthorityTemplateResourceBuilder.() -> Unit,
): EnterpriseAuthorityTemplate {
    val builder = EnterpriseAuthorityTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterpriseAuthorityTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterpriseAuthorityTemplate(name: String): EnterpriseAuthorityTemplate {
    val builder = EnterpriseAuthorityTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
