@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.alicloud.dms.EnterpriseAuthorityTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DMS Enterprise Authority Template resource.
 * For information about DMS Enterprise Authority Template and how to use it, see [What is Authority Template](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createauthoritytemplate).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.dms.getUserTenants({
 *     status: "ACTIVE",
 * });
 * const defaultEnterpriseAuthorityTemplate = new alicloud.dms.EnterpriseAuthorityTemplate("default", {
 *     tid: _default.then(_default => _default.ids?.[0]),
 *     authorityTemplateName: name,
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.dms.get_user_tenants(status="ACTIVE")
 * default_enterprise_authority_template = alicloud.dms.EnterpriseAuthorityTemplate("default",
 *     tid=default.ids[0],
 *     authority_template_name=name,
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Dms.GetUserTenants.Invoke(new()
 *     {
 *         Status = "ACTIVE",
 *     });
 *     var defaultEnterpriseAuthorityTemplate = new AliCloud.Dms.EnterpriseAuthorityTemplate("default", new()
 *     {
 *         Tid = @default.Apply(@default => @default.Apply(getUserTenantsResult => getUserTenantsResult.Ids[0])),
 *         AuthorityTemplateName = name,
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := dms.GetUserTenants(ctx, &dms.GetUserTenantsArgs{
 * 			Status: pulumi.StringRef("ACTIVE"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewEnterpriseAuthorityTemplate(ctx, "default", &dms.EnterpriseAuthorityTemplateArgs{
 * 			Tid:                   pulumi.String(_default.Ids[0]),
 * 			AuthorityTemplateName: pulumi.String(name),
 * 			Description:           pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dms.DmsFunctions;
 * import com.pulumi.alicloud.dms.inputs.GetUserTenantsArgs;
 * import com.pulumi.alicloud.dms.EnterpriseAuthorityTemplate;
 * import com.pulumi.alicloud.dms.EnterpriseAuthorityTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = DmsFunctions.getUserTenants(GetUserTenantsArgs.builder()
 *             .status("ACTIVE")
 *             .build());
 *         var defaultEnterpriseAuthorityTemplate = new EnterpriseAuthorityTemplate("defaultEnterpriseAuthorityTemplate", EnterpriseAuthorityTemplateArgs.builder()
 *             .tid(default_.ids()[0])
 *             .authorityTemplateName(name)
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultEnterpriseAuthorityTemplate:
 *     type: alicloud:dms:EnterpriseAuthorityTemplate
 *     name: default
 *     properties:
 *       tid: ${default.ids[0]}
 *       authorityTemplateName: ${name}
 *       description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:dms:getUserTenants
 *       Arguments:
 *         status: ACTIVE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise Authority Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseAuthorityTemplate:EnterpriseAuthorityTemplate example <tid>:<authority_template_id>
 * ```
 * @property authorityTemplateName Permission Template name.
 * @property description Permission template description information.
 * @property tid Tenant ID.
 */
public data class EnterpriseAuthorityTemplateArgs(
    public val authorityTemplateName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val tid: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.EnterpriseAuthorityTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.EnterpriseAuthorityTemplateArgs =
        com.pulumi.alicloud.dms.EnterpriseAuthorityTemplateArgs.builder()
            .authorityTemplateName(authorityTemplateName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .tid(tid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseAuthorityTemplateArgs].
 */
@PulumiTagMarker
public class EnterpriseAuthorityTemplateArgsBuilder internal constructor() {
    private var authorityTemplateName: Output<String>? = null

    private var description: Output<String>? = null

    private var tid: Output<Int>? = null

    /**
     * @param value Permission Template name.
     */
    @JvmName("obegrrplulsftgsk")
    public suspend fun authorityTemplateName(`value`: Output<String>) {
        this.authorityTemplateName = value
    }

    /**
     * @param value Permission template description information.
     */
    @JvmName("mwlkqhwcgndhofih")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Tenant ID.
     */
    @JvmName("cxmmcsxhnlnighbo")
    public suspend fun tid(`value`: Output<Int>) {
        this.tid = value
    }

    /**
     * @param value Permission Template name.
     */
    @JvmName("xjiidwhvigedggdr")
    public suspend fun authorityTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorityTemplateName = mapped
    }

    /**
     * @param value Permission template description information.
     */
    @JvmName("tvpsmewewhpicwed")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Tenant ID.
     */
    @JvmName("qclrvvbvorptpaqw")
    public suspend fun tid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tid = mapped
    }

    internal fun build(): EnterpriseAuthorityTemplateArgs = EnterpriseAuthorityTemplateArgs(
        authorityTemplateName = authorityTemplateName,
        description = description,
        tid = tid,
    )
}
