@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.alicloud.dms.EnterpriseInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DMS Enterprise Instance resource.
 * > **NOTE:** API users must first register in DMS.
 * > **NOTE:** Available since v1.81.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const current = alicloud.getAccount({});
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultGetUserTenants = alicloud.dms.getUserTenants({
 *     status: "ACTIVE",
 * });
 * const defaultGetZones = alicloud.rds.getZones({
 *     engine: "MySQL",
 *     engineVersion: "8.0",
 *     instanceChargeType: "PostPaid",
 *     category: "HighAvailability",
 *     dbInstanceStorageType: "cloud_essd",
 * });
 * const defaultGetInstanceClasses = defaultGetZones.then(defaultGetZones => alicloud.rds.getInstanceClasses({
 *     zoneId: defaultGetZones.zones?.[0]?.id,
 *     engine: "MySQL",
 *     engineVersion: "8.0",
 *     category: "HighAvailability",
 *     dbInstanceStorageType: "cloud_essd",
 *     instanceChargeType: "PostPaid",
 * }));
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultInstance = new alicloud.rds.Instance("default", {
 *     engine: "MySQL",
 *     engineVersion: "8.0",
 *     dbInstanceStorageType: "cloud_essd",
 *     instanceType: defaultGetInstanceClasses.then(defaultGetInstanceClasses => defaultGetInstanceClasses.instanceClasses?.[0]?.instanceClass),
 *     instanceStorage: defaultGetInstanceClasses.then(defaultGetInstanceClasses => defaultGetInstanceClasses.instanceClasses?.[0]?.storageRange?.min),
 *     vswitchId: defaultSwitch.id,
 *     instanceName: name,
 *     securityIps: [
 *         "100.104.5.0/24",
 *         "192.168.0.6",
 *     ],
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultAccount = new alicloud.rds.Account("default", {
 *     dbInstanceId: defaultInstance.id,
 *     accountName: "tfexamplename",
 *     accountPassword: "Example12345",
 *     accountType: "Normal",
 * });
 * const defaultEnterpriseInstance = new alicloud.dms.EnterpriseInstance("default", {
 *     tid: defaultGetUserTenants.then(defaultGetUserTenants => defaultGetUserTenants.ids?.[0]),
 *     instanceType: "mysql",
 *     instanceSource: "RDS",
 *     networkType: "VPC",
 *     envType: "dev",
 *     host: defaultInstance.connectionString,
 *     port: 3306,
 *     databaseUser: defaultAccount.accountName,
 *     databasePassword: defaultAccount.accountPassword,
 *     instanceName: name,
 *     dbaUid: current.then(current => current.id),
 *     safeRule: "904496",
 *     useDsql: 1,
 *     queryTimeout: 60,
 *     exportTimeout: 600,
 *     ecsRegion: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * current = alicloud.get_account()
 * default = alicloud.get_regions(current=True)
 * default_get_user_tenants = alicloud.dms.get_user_tenants(status="ACTIVE")
 * default_get_zones = alicloud.rds.get_zones(engine="MySQL",
 *     engine_version="8.0",
 *     instance_charge_type="PostPaid",
 *     category="HighAvailability",
 *     db_instance_storage_type="cloud_essd")
 * default_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=default_get_zones.zones[0].id,
 *     engine="MySQL",
 *     engine_version="8.0",
 *     category="HighAvailability",
 *     db_instance_storage_type="cloud_essd",
 *     instance_charge_type="PostPaid")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_instance = alicloud.rds.Instance("default",
 *     engine="MySQL",
 *     engine_version="8.0",
 *     db_instance_storage_type="cloud_essd",
 *     instance_type=default_get_instance_classes.instance_classes[0].instance_class,
 *     instance_storage=default_get_instance_classes.instance_classes[0].storage_range.min,
 *     vswitch_id=default_switch.id,
 *     instance_name=name,
 *     security_ips=[
 *         "100.104.5.0/24",
 *         "192.168.0.6",
 *     ],
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_account = alicloud.rds.Account("default",
 *     db_instance_id=default_instance.id,
 *     account_name="tfexamplename",
 *     account_password="Example12345",
 *     account_type="Normal")
 * default_enterprise_instance = alicloud.dms.EnterpriseInstance("default",
 *     tid=default_get_user_tenants.ids[0],
 *     instance_type="mysql",
 *     instance_source="RDS",
 *     network_type="VPC",
 *     env_type="dev",
 *     host=default_instance.connection_string,
 *     port=3306,
 *     database_user=default_account.account_name,
 *     database_password=default_account.account_password,
 *     instance_name=name,
 *     dba_uid=current.id,
 *     safe_rule="904496",
 *     use_dsql=1,
 *     query_timeout=60,
 *     export_timeout=600,
 *     ecs_region=default.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var current = AliCloud.GetAccount.Invoke();
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultGetUserTenants = AliCloud.Dms.GetUserTenants.Invoke(new()
 *     {
 *         Status = "ACTIVE",
 *     });
 *     var defaultGetZones = AliCloud.Rds.GetZones.Invoke(new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "8.0",
 *         InstanceChargeType = "PostPaid",
 *         Category = "HighAvailability",
 *         DbInstanceStorageType = "cloud_essd",
 *     });
 *     var defaultGetInstanceClasses = AliCloud.Rds.GetInstanceClasses.Invoke(new()
 *     {
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         Engine = "MySQL",
 *         EngineVersion = "8.0",
 *         Category = "HighAvailability",
 *         DbInstanceStorageType = "cloud_essd",
 *         InstanceChargeType = "PostPaid",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultInstance = new AliCloud.Rds.Instance("default", new()
 *     {
 *         Engine = "MySQL",
 *         EngineVersion = "8.0",
 *         DbInstanceStorageType = "cloud_essd",
 *         InstanceType = defaultGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[0]?.InstanceClass),
 *         InstanceStorage = defaultGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses[0]?.StorageRange?.Min),
 *         VswitchId = defaultSwitch.Id,
 *         InstanceName = name,
 *         SecurityIps = new[]
 *         {
 *             "100.104.5.0/24",
 *             "192.168.0.6",
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultAccount = new AliCloud.Rds.Account("default", new()
 *     {
 *         DbInstanceId = defaultInstance.Id,
 *         AccountName = "tfexamplename",
 *         AccountPassword = "Example12345",
 *         AccountType = "Normal",
 *     });
 *     var defaultEnterpriseInstance = new AliCloud.Dms.EnterpriseInstance("default", new()
 *     {
 *         Tid = defaultGetUserTenants.Apply(getUserTenantsResult => getUserTenantsResult.Ids[0]),
 *         InstanceType = "mysql",
 *         InstanceSource = "RDS",
 *         NetworkType = "VPC",
 *         EnvType = "dev",
 *         Host = defaultInstance.ConnectionString,
 *         Port = 3306,
 *         DatabaseUser = defaultAccount.AccountName,
 *         DatabasePassword = defaultAccount.AccountPassword,
 *         InstanceName = name,
 *         DbaUid = current.Apply(getAccountResult => getAccountResult.Id),
 *         SafeRule = "904496",
 *         UseDsql = 1,
 *         QueryTimeout = 60,
 *         ExportTimeout = 600,
 *         EcsRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rds"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		current, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetUserTenants, err := dms.GetUserTenants(ctx, &dms.GetUserTenantsArgs{
 * 			Status: pulumi.StringRef("ACTIVE"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := rds.GetZones(ctx, &rds.GetZonesArgs{
 * 			Engine:                pulumi.StringRef("MySQL"),
 * 			EngineVersion:         pulumi.StringRef("8.0"),
 * 			InstanceChargeType:    pulumi.StringRef("PostPaid"),
 * 			Category:              pulumi.StringRef("HighAvailability"),
 * 			DbInstanceStorageType: pulumi.StringRef("cloud_essd"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceClasses, err := rds.GetInstanceClasses(ctx, &rds.GetInstanceClassesArgs{
 * 			ZoneId:                pulumi.StringRef(defaultGetZones.Zones[0].Id),
 * 			Engine:                pulumi.StringRef("MySQL"),
 * 			EngineVersion:         pulumi.StringRef("8.0"),
 * 			Category:              pulumi.StringRef("HighAvailability"),
 * 			DbInstanceStorageType: pulumi.StringRef("cloud_essd"),
 * 			InstanceChargeType:    pulumi.StringRef("PostPaid"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := rds.NewInstance(ctx, "default", &rds.InstanceArgs{
 * 			Engine:                pulumi.String("MySQL"),
 * 			EngineVersion:         pulumi.String("8.0"),
 * 			DbInstanceStorageType: pulumi.String("cloud_essd"),
 * 			InstanceType:          pulumi.String(defaultGetInstanceClasses.InstanceClasses[0].InstanceClass),
 * 			InstanceStorage:       pulumi.String(defaultGetInstanceClasses.InstanceClasses[0].StorageRange.Min),
 * 			VswitchId:             defaultSwitch.ID(),
 * 			InstanceName:          pulumi.String(name),
 * 			SecurityIps: pulumi.StringArray{
 * 				pulumi.String("100.104.5.0/24"),
 * 				pulumi.String("192.168.0.6"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAccount, err := rds.NewAccount(ctx, "default", &rds.AccountArgs{
 * 			DbInstanceId:    defaultInstance.ID(),
 * 			AccountName:     pulumi.String("tfexamplename"),
 * 			AccountPassword: pulumi.String("Example12345"),
 * 			AccountType:     pulumi.String("Normal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewEnterpriseInstance(ctx, "default", &dms.EnterpriseInstanceArgs{
 * 			Tid:              pulumi.String(defaultGetUserTenants.Ids[0]),
 * 			InstanceType:     pulumi.String("mysql"),
 * 			InstanceSource:   pulumi.String("RDS"),
 * 			NetworkType:      pulumi.String("VPC"),
 * 			EnvType:          pulumi.String("dev"),
 * 			Host:             defaultInstance.ConnectionString,
 * 			Port:             pulumi.Int(3306),
 * 			DatabaseUser:     defaultAccount.AccountName,
 * 			DatabasePassword: defaultAccount.AccountPassword,
 * 			InstanceName:     pulumi.String(name),
 * 			DbaUid:           pulumi.String(current.Id),
 * 			SafeRule:         pulumi.String("904496"),
 * 			UseDsql:          pulumi.Int(1),
 * 			QueryTimeout:     pulumi.Int(60),
 * 			ExportTimeout:    pulumi.Int(600),
 * 			EcsRegion:        pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.dms.DmsFunctions;
 * import com.pulumi.alicloud.dms.inputs.GetUserTenantsArgs;
 * import com.pulumi.alicloud.rds.RdsFunctions;
 * import com.pulumi.alicloud.rds.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.rds.inputs.GetInstanceClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.rds.Instance;
 * import com.pulumi.alicloud.rds.InstanceArgs;
 * import com.pulumi.alicloud.rds.Account;
 * import com.pulumi.alicloud.rds.AccountArgs;
 * import com.pulumi.alicloud.dms.EnterpriseInstance;
 * import com.pulumi.alicloud.dms.EnterpriseInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var current = AlicloudFunctions.getAccount();
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var defaultGetUserTenants = DmsFunctions.getUserTenants(GetUserTenantsArgs.builder()
 *             .status("ACTIVE")
 *             .build());
 *         final var defaultGetZones = RdsFunctions.getZones(GetZonesArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("8.0")
 *             .instanceChargeType("PostPaid")
 *             .category("HighAvailability")
 *             .dbInstanceStorageType("cloud_essd")
 *             .build());
 *         final var defaultGetInstanceClasses = RdsFunctions.getInstanceClasses(GetInstanceClassesArgs.builder()
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .engine("MySQL")
 *             .engineVersion("8.0")
 *             .category("HighAvailability")
 *             .dbInstanceStorageType("cloud_essd")
 *             .instanceChargeType("PostPaid")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .engine("MySQL")
 *             .engineVersion("8.0")
 *             .dbInstanceStorageType("cloud_essd")
 *             .instanceType(defaultGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[0].instanceClass()))
 *             .instanceStorage(defaultGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()[0].storageRange().min()))
 *             .vswitchId(defaultSwitch.id())
 *             .instanceName(name)
 *             .securityIps(
 *                 "100.104.5.0/24",
 *                 "192.168.0.6")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .dbInstanceId(defaultInstance.id())
 *             .accountName("tfexamplename")
 *             .accountPassword("Example12345")
 *             .accountType("Normal")
 *             .build());
 *         var defaultEnterpriseInstance = new EnterpriseInstance("defaultEnterpriseInstance", EnterpriseInstanceArgs.builder()
 *             .tid(defaultGetUserTenants.applyValue(getUserTenantsResult -> getUserTenantsResult.ids()[0]))
 *             .instanceType("mysql")
 *             .instanceSource("RDS")
 *             .networkType("VPC")
 *             .envType("dev")
 *             .host(defaultInstance.connectionString())
 *             .port(3306)
 *             .databaseUser(defaultAccount.accountName())
 *             .databasePassword(defaultAccount.accountPassword())
 *             .instanceName(name)
 *             .dbaUid(current.applyValue(getAccountResult -> getAccountResult.id()))
 *             .safeRule("904496")
 *             .useDsql(1)
 *             .queryTimeout(60)
 *             .exportTimeout(600)
 *             .ecsRegion(default_.regions()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultInstance:
 *     type: alicloud:rds:Instance
 *     name: default
 *     properties:
 *       engine: MySQL
 *       engineVersion: '8.0'
 *       dbInstanceStorageType: cloud_essd
 *       instanceType: ${defaultGetInstanceClasses.instanceClasses[0].instanceClass}
 *       instanceStorage: ${defaultGetInstanceClasses.instanceClasses[0].storageRange.min}
 *       vswitchId: ${defaultSwitch.id}
 *       instanceName: ${name}
 *       securityIps:
 *         - 100.104.5.0/24
 *         - 192.168.0.6
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultAccount:
 *     type: alicloud:rds:Account
 *     name: default
 *     properties:
 *       dbInstanceId: ${defaultInstance.id}
 *       accountName: tfexamplename
 *       accountPassword: Example12345
 *       accountType: Normal
 *   defaultEnterpriseInstance:
 *     type: alicloud:dms:EnterpriseInstance
 *     name: default
 *     properties:
 *       tid: ${defaultGetUserTenants.ids[0]}
 *       instanceType: mysql
 *       instanceSource: RDS
 *       networkType: VPC
 *       envType: dev
 *       host: ${defaultInstance.connectionString}
 *       port: 3306
 *       databaseUser: ${defaultAccount.accountName}
 *       databasePassword: ${defaultAccount.accountPassword}
 *       instanceName: ${name}
 *       dbaUid: ${current.id}
 *       safeRule: '904496'
 *       useDsql: 1
 *       queryTimeout: 60
 *       exportTimeout: 600
 *       ecsRegion: ${default.regions[0].id}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   defaultGetUserTenants:
 *     fn::invoke:
 *       Function: alicloud:dms:getUserTenants
 *       Arguments:
 *         status: ACTIVE
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:rds:getZones
 *       Arguments:
 *         engine: MySQL
 *         engineVersion: '8.0'
 *         instanceChargeType: PostPaid
 *         category: HighAvailability
 *         dbInstanceStorageType: cloud_essd
 *   defaultGetInstanceClasses:
 *     fn::invoke:
 *       Function: alicloud:rds:getInstanceClasses
 *       Arguments:
 *         zoneId: ${defaultGetZones.zones[0].id}
 *         engine: MySQL
 *         engineVersion: '8.0'
 *         category: HighAvailability
 *         dbInstanceStorageType: cloud_essd
 *         instanceChargeType: PostPaid
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise can be imported using host and port, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseInstance:EnterpriseInstance example rm-uf648hgs7874xxxx.mysql.rds.aliyuncs.com:3306
 * ```
 * @property dataLinkName Cross-database query datalink name.
 * @property databasePassword Database access password.
 * @property databaseUser Database access account.
 * @property dbaId The dba id of the database instance.
 * @property dbaUid The DBA of the instance is passed into the Alibaba Cloud uid of the DBA.
 * @property ddlOnline Whether to use online services, currently only supports MySQL and PolarDB. Valid values: `0` Not used, `1` Native online DDL priority, `2` DMS lock-free table structure change priority.
 * @property ecsInstanceId ECS instance ID. The value of InstanceSource is the ECS self-built library. This value must be passed.
 * @property ecsRegion The region where the instance is located. This value must be passed when the value of InstanceSource is RDS, ECS self-built library, and VPC dedicated line IDC.
 * @property envType Environment type. Valid values: `product` production environment, `dev` development environment, `pre` pre-release environment, `test` test environment, `sit` SIT environment, `uat` UAT environment, `pet` pressure test environment, `stag` STAG environment.
 * @property exportTimeout Export timeout, unit: s (seconds).
 * @property host Host address of the target database.
 * @property instanceAlias Field `instance_alias` has been deprecated from version 1.100.0. Use `instance_name` instead.
 * @property instanceId The instance id of the database instance.
 * @property instanceName Instance name, to help users quickly distinguish positioning.
 * @property instanceSource The source of the database instance. Valid values: `PUBLIC_OWN`, `RDS`, `ECS_OWN`, `VPC_IDC`.
 * @property instanceType Database type. Valid values: `MySQL`, `SQLServer`, `PostgreSQL`, `Oracle,` `DRDS`, `OceanBase`, `Mongo`, `Redis`.
 * @property networkType Network type. Valid values: `CLASSIC`, `VPC`.
 * @property port Access port of the target database.
 * @property queryTimeout Query timeout time, unit: s (seconds).
 * @property safeRule The security rule of the instance is passed into the name of the security rule in the enterprise.
 * @property safeRuleId The safe rule id of the database instance.
 * @property sid The SID. This value must be passed when InstanceType is PostgreSQL or Oracle.
 * @property skipTest Whether the instance ignores test connectivity. Valid values: `true`, `false`.
 * @property tid The tenant ID.
 * @property useDsql Whether to enable cross-instance query. Valid values: `0` not open, `1` open.
 * @property vpcId VPC ID. This value must be passed when the value of InstanceSource is VPC dedicated line IDC.
 */
public data class EnterpriseInstanceArgs(
    public val dataLinkName: Output<String>? = null,
    public val databasePassword: Output<String>? = null,
    public val databaseUser: Output<String>? = null,
    public val dbaId: Output<String>? = null,
    public val dbaUid: Output<Int>? = null,
    public val ddlOnline: Output<Int>? = null,
    public val ecsInstanceId: Output<String>? = null,
    public val ecsRegion: Output<String>? = null,
    public val envType: Output<String>? = null,
    public val exportTimeout: Output<Int>? = null,
    public val host: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_alias' has been deprecated from version 1.100.0. Use 'instance_name' instead.
  """,
    )
    public val instanceAlias: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceSource: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val queryTimeout: Output<Int>? = null,
    public val safeRule: Output<String>? = null,
    public val safeRuleId: Output<String>? = null,
    public val sid: Output<String>? = null,
    public val skipTest: Output<Boolean>? = null,
    public val tid: Output<Int>? = null,
    public val useDsql: Output<Int>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.EnterpriseInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.EnterpriseInstanceArgs =
        com.pulumi.alicloud.dms.EnterpriseInstanceArgs.builder()
            .dataLinkName(dataLinkName?.applyValue({ args0 -> args0 }))
            .databasePassword(databasePassword?.applyValue({ args0 -> args0 }))
            .databaseUser(databaseUser?.applyValue({ args0 -> args0 }))
            .dbaId(dbaId?.applyValue({ args0 -> args0 }))
            .dbaUid(dbaUid?.applyValue({ args0 -> args0 }))
            .ddlOnline(ddlOnline?.applyValue({ args0 -> args0 }))
            .ecsInstanceId(ecsInstanceId?.applyValue({ args0 -> args0 }))
            .ecsRegion(ecsRegion?.applyValue({ args0 -> args0 }))
            .envType(envType?.applyValue({ args0 -> args0 }))
            .exportTimeout(exportTimeout?.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .instanceAlias(instanceAlias?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceSource(instanceSource?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .safeRule(safeRule?.applyValue({ args0 -> args0 }))
            .safeRuleId(safeRuleId?.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .skipTest(skipTest?.applyValue({ args0 -> args0 }))
            .tid(tid?.applyValue({ args0 -> args0 }))
            .useDsql(useDsql?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseInstanceArgs].
 */
@PulumiTagMarker
public class EnterpriseInstanceArgsBuilder internal constructor() {
    private var dataLinkName: Output<String>? = null

    private var databasePassword: Output<String>? = null

    private var databaseUser: Output<String>? = null

    private var dbaId: Output<String>? = null

    private var dbaUid: Output<Int>? = null

    private var ddlOnline: Output<Int>? = null

    private var ecsInstanceId: Output<String>? = null

    private var ecsRegion: Output<String>? = null

    private var envType: Output<String>? = null

    private var exportTimeout: Output<Int>? = null

    private var host: Output<String>? = null

    private var instanceAlias: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceSource: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var networkType: Output<String>? = null

    private var port: Output<Int>? = null

    private var queryTimeout: Output<Int>? = null

    private var safeRule: Output<String>? = null

    private var safeRuleId: Output<String>? = null

    private var sid: Output<String>? = null

    private var skipTest: Output<Boolean>? = null

    private var tid: Output<Int>? = null

    private var useDsql: Output<Int>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Cross-database query datalink name.
     */
    @JvmName("esrhgqfwxccvtpxy")
    public suspend fun dataLinkName(`value`: Output<String>) {
        this.dataLinkName = value
    }

    /**
     * @param value Database access password.
     */
    @JvmName("jkokqxdyguwggipv")
    public suspend fun databasePassword(`value`: Output<String>) {
        this.databasePassword = value
    }

    /**
     * @param value Database access account.
     */
    @JvmName("jtymncrrxmloeacx")
    public suspend fun databaseUser(`value`: Output<String>) {
        this.databaseUser = value
    }

    /**
     * @param value The dba id of the database instance.
     */
    @JvmName("uryhkyxevdpsfuri")
    public suspend fun dbaId(`value`: Output<String>) {
        this.dbaId = value
    }

    /**
     * @param value The DBA of the instance is passed into the Alibaba Cloud uid of the DBA.
     */
    @JvmName("auceatinpinwbveh")
    public suspend fun dbaUid(`value`: Output<Int>) {
        this.dbaUid = value
    }

    /**
     * @param value Whether to use online services, currently only supports MySQL and PolarDB. Valid values: `0` Not used, `1` Native online DDL priority, `2` DMS lock-free table structure change priority.
     */
    @JvmName("vuiewheocrherbcn")
    public suspend fun ddlOnline(`value`: Output<Int>) {
        this.ddlOnline = value
    }

    /**
     * @param value ECS instance ID. The value of InstanceSource is the ECS self-built library. This value must be passed.
     */
    @JvmName("giduohxicpabrnnt")
    public suspend fun ecsInstanceId(`value`: Output<String>) {
        this.ecsInstanceId = value
    }

    /**
     * @param value The region where the instance is located. This value must be passed when the value of InstanceSource is RDS, ECS self-built library, and VPC dedicated line IDC.
     */
    @JvmName("abxeykryhhfblljc")
    public suspend fun ecsRegion(`value`: Output<String>) {
        this.ecsRegion = value
    }

    /**
     * @param value Environment type. Valid values: `product` production environment, `dev` development environment, `pre` pre-release environment, `test` test environment, `sit` SIT environment, `uat` UAT environment, `pet` pressure test environment, `stag` STAG environment.
     */
    @JvmName("ywnbadmkwdlsggeu")
    public suspend fun envType(`value`: Output<String>) {
        this.envType = value
    }

    /**
     * @param value Export timeout, unit: s (seconds).
     */
    @JvmName("gegjsqviuugndmsv")
    public suspend fun exportTimeout(`value`: Output<Int>) {
        this.exportTimeout = value
    }

    /**
     * @param value Host address of the target database.
     */
    @JvmName("dibmgpyjmekvkktc")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value Field `instance_alias` has been deprecated from version 1.100.0. Use `instance_name` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_alias' has been deprecated from version 1.100.0. Use 'instance_name' instead.
  """,
    )
    @JvmName("jbqfoykydrfhlbrv")
    public suspend fun instanceAlias(`value`: Output<String>) {
        this.instanceAlias = value
    }

    /**
     * @param value The instance id of the database instance.
     */
    @JvmName("icjixfxonkvgtfte")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Instance name, to help users quickly distinguish positioning.
     */
    @JvmName("svkpundbwonxomus")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The source of the database instance. Valid values: `PUBLIC_OWN`, `RDS`, `ECS_OWN`, `VPC_IDC`.
     */
    @JvmName("ddhhlxfwamleirje")
    public suspend fun instanceSource(`value`: Output<String>) {
        this.instanceSource = value
    }

    /**
     * @param value Database type. Valid values: `MySQL`, `SQLServer`, `PostgreSQL`, `Oracle,` `DRDS`, `OceanBase`, `Mongo`, `Redis`.
     */
    @JvmName("gqrigjcrchwkwuvd")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Network type. Valid values: `CLASSIC`, `VPC`.
     */
    @JvmName("kifwqmcmrskweehq")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value Access port of the target database.
     */
    @JvmName("skutyctsawltmnci")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Query timeout time, unit: s (seconds).
     */
    @JvmName("rsolnkvkckcnopoc")
    public suspend fun queryTimeout(`value`: Output<Int>) {
        this.queryTimeout = value
    }

    /**
     * @param value The security rule of the instance is passed into the name of the security rule in the enterprise.
     */
    @JvmName("ljbuacnjbeyftklq")
    public suspend fun safeRule(`value`: Output<String>) {
        this.safeRule = value
    }

    /**
     * @param value The safe rule id of the database instance.
     */
    @JvmName("kreweemoibkgxftr")
    public suspend fun safeRuleId(`value`: Output<String>) {
        this.safeRuleId = value
    }

    /**
     * @param value The SID. This value must be passed when InstanceType is PostgreSQL or Oracle.
     */
    @JvmName("ameedbroqksxhmdo")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Whether the instance ignores test connectivity. Valid values: `true`, `false`.
     */
    @JvmName("yruguxnrbaoawkrm")
    public suspend fun skipTest(`value`: Output<Boolean>) {
        this.skipTest = value
    }

    /**
     * @param value The tenant ID.
     */
    @JvmName("vkkfiibubqoiqsdy")
    public suspend fun tid(`value`: Output<Int>) {
        this.tid = value
    }

    /**
     * @param value Whether to enable cross-instance query. Valid values: `0` not open, `1` open.
     */
    @JvmName("wurdwfbkquradttt")
    public suspend fun useDsql(`value`: Output<Int>) {
        this.useDsql = value
    }

    /**
     * @param value VPC ID. This value must be passed when the value of InstanceSource is VPC dedicated line IDC.
     */
    @JvmName("wfvvmbyeghttyejp")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Cross-database query datalink name.
     */
    @JvmName("dntfcjjfsvdqywkn")
    public suspend fun dataLinkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLinkName = mapped
    }

    /**
     * @param value Database access password.
     */
    @JvmName("otppcufewbxvtewa")
    public suspend fun databasePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databasePassword = mapped
    }

    /**
     * @param value Database access account.
     */
    @JvmName("tqcnxoimtsplneqj")
    public suspend fun databaseUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseUser = mapped
    }

    /**
     * @param value The dba id of the database instance.
     */
    @JvmName("hlqwqmlsnaqkiwgd")
    public suspend fun dbaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbaId = mapped
    }

    /**
     * @param value The DBA of the instance is passed into the Alibaba Cloud uid of the DBA.
     */
    @JvmName("ckeqtcnrkykkgsed")
    public suspend fun dbaUid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbaUid = mapped
    }

    /**
     * @param value Whether to use online services, currently only supports MySQL and PolarDB. Valid values: `0` Not used, `1` Native online DDL priority, `2` DMS lock-free table structure change priority.
     */
    @JvmName("sxvcysgrnfnmpfav")
    public suspend fun ddlOnline(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddlOnline = mapped
    }

    /**
     * @param value ECS instance ID. The value of InstanceSource is the ECS self-built library. This value must be passed.
     */
    @JvmName("kopyeadvqlqcyitl")
    public suspend fun ecsInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsInstanceId = mapped
    }

    /**
     * @param value The region where the instance is located. This value must be passed when the value of InstanceSource is RDS, ECS self-built library, and VPC dedicated line IDC.
     */
    @JvmName("kmpcivwahkjuylga")
    public suspend fun ecsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsRegion = mapped
    }

    /**
     * @param value Environment type. Valid values: `product` production environment, `dev` development environment, `pre` pre-release environment, `test` test environment, `sit` SIT environment, `uat` UAT environment, `pet` pressure test environment, `stag` STAG environment.
     */
    @JvmName("ykqdwfnwwgrnsxac")
    public suspend fun envType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envType = mapped
    }

    /**
     * @param value Export timeout, unit: s (seconds).
     */
    @JvmName("asdtctmnheyhkexd")
    public suspend fun exportTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportTimeout = mapped
    }

    /**
     * @param value Host address of the target database.
     */
    @JvmName("awskcoelchapedlj")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Field `instance_alias` has been deprecated from version 1.100.0. Use `instance_name` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_alias' has been deprecated from version 1.100.0. Use 'instance_name' instead.
  """,
    )
    @JvmName("vlcnufpvdlxvtqfu")
    public suspend fun instanceAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceAlias = mapped
    }

    /**
     * @param value The instance id of the database instance.
     */
    @JvmName("rbwogsuyravnsdpf")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Instance name, to help users quickly distinguish positioning.
     */
    @JvmName("vmulfehgnygxkrlv")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The source of the database instance. Valid values: `PUBLIC_OWN`, `RDS`, `ECS_OWN`, `VPC_IDC`.
     */
    @JvmName("yxkrehjmdtbfahtf")
    public suspend fun instanceSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceSource = mapped
    }

    /**
     * @param value Database type. Valid values: `MySQL`, `SQLServer`, `PostgreSQL`, `Oracle,` `DRDS`, `OceanBase`, `Mongo`, `Redis`.
     */
    @JvmName("bjopdeslkagnoqoc")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Network type. Valid values: `CLASSIC`, `VPC`.
     */
    @JvmName("ylcxcgkdlmtfattb")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value Access port of the target database.
     */
    @JvmName("bkyuffvawfyuryie")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Query timeout time, unit: s (seconds).
     */
    @JvmName("wtlkipdiyylmjxph")
    public suspend fun queryTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value The security rule of the instance is passed into the name of the security rule in the enterprise.
     */
    @JvmName("neubdmuygnltbfcp")
    public suspend fun safeRule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.safeRule = mapped
    }

    /**
     * @param value The safe rule id of the database instance.
     */
    @JvmName("ueedueoexwdjjwno")
    public suspend fun safeRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.safeRuleId = mapped
    }

    /**
     * @param value The SID. This value must be passed when InstanceType is PostgreSQL or Oracle.
     */
    @JvmName("hwbbqulrpnvugstg")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Whether the instance ignores test connectivity. Valid values: `true`, `false`.
     */
    @JvmName("hjecvyiqrbdjtyda")
    public suspend fun skipTest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipTest = mapped
    }

    /**
     * @param value The tenant ID.
     */
    @JvmName("tewpixkwumxwkgbk")
    public suspend fun tid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tid = mapped
    }

    /**
     * @param value Whether to enable cross-instance query. Valid values: `0` not open, `1` open.
     */
    @JvmName("smfrlbwkmiakwwaw")
    public suspend fun useDsql(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useDsql = mapped
    }

    /**
     * @param value VPC ID. This value must be passed when the value of InstanceSource is VPC dedicated line IDC.
     */
    @JvmName("hqfhjbvsiyrsmtvt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): EnterpriseInstanceArgs = EnterpriseInstanceArgs(
        dataLinkName = dataLinkName,
        databasePassword = databasePassword,
        databaseUser = databaseUser,
        dbaId = dbaId,
        dbaUid = dbaUid,
        ddlOnline = ddlOnline,
        ecsInstanceId = ecsInstanceId,
        ecsRegion = ecsRegion,
        envType = envType,
        exportTimeout = exportTimeout,
        host = host,
        instanceAlias = instanceAlias,
        instanceId = instanceId,
        instanceName = instanceName,
        instanceSource = instanceSource,
        instanceType = instanceType,
        networkType = networkType,
        port = port,
        queryTimeout = queryTimeout,
        safeRule = safeRule,
        safeRuleId = safeRuleId,
        sid = sid,
        skipTest = skipTest,
        tid = tid,
        useDsql = useDsql,
        vpcId = vpcId,
    )
}
