@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EnterpriseLogicDatabase].
 */
@PulumiTagMarker
public class EnterpriseLogicDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterpriseLogicDatabaseArgs = EnterpriseLogicDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnterpriseLogicDatabaseArgsBuilder.() -> Unit) {
        val builder = EnterpriseLogicDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnterpriseLogicDatabase {
        val builtJavaResource = com.pulumi.alicloud.dms.EnterpriseLogicDatabase(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnterpriseLogicDatabase(builtJavaResource)
    }
}

/**
 * Provides a DMS Enterprise Logic Database resource.
 * For information about DMS Enterprise Logic Database and how to use it, see [What is Logic Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createlogicdatabase).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dms.EnterpriseLogicDatabase("default", {
 *     alias: "TF_logic_db_test",
 *     databaseIds: [
 *         "35617919",
 *         "35617920",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dms.EnterpriseLogicDatabase("default",
 *     alias="TF_logic_db_test",
 *     database_ids=[
 *         "35617919",
 *         "35617920",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dms.EnterpriseLogicDatabase("default", new()
 *     {
 *         Alias = "TF_logic_db_test",
 *         DatabaseIds = new[]
 *         {
 *             "35617919",
 *             "35617920",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dms.NewEnterpriseLogicDatabase(ctx, "default", &dms.EnterpriseLogicDatabaseArgs{
 * 			Alias: pulumi.String("TF_logic_db_test"),
 * 			DatabaseIds: pulumi.StringArray{
 * 				pulumi.String("35617919"),
 * 				pulumi.String("35617920"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dms.EnterpriseLogicDatabase;
 * import com.pulumi.alicloud.dms.EnterpriseLogicDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EnterpriseLogicDatabase("default", EnterpriseLogicDatabaseArgs.builder()
 *             .alias("TF_logic_db_test")
 *             .databaseIds(
 *                 "35617919",
 *                 "35617920")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dms:EnterpriseLogicDatabase
 *     properties:
 *       alias: TF_logic_db_test
 *       databaseIds:
 *         - '35617919'
 *         - '35617920'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise Logic Database can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseLogicDatabase:EnterpriseLogicDatabase example <id>
 * ```
 */
public class EnterpriseLogicDatabase internal constructor(
    override val javaResource: com.pulumi.alicloud.dms.EnterpriseLogicDatabase,
) : KotlinCustomResource(javaResource, EnterpriseLogicDatabaseMapper) {
    /**
     * Logical Library alias.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * Sub-Database ID
     */
    public val databaseIds: Output<List<String>>
        get() = javaResource.databaseIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Database type.
     */
    public val dbType: Output<String>
        get() = javaResource.dbType().applyValue({ args0 -> args0 })

    /**
     * Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
     */
    public val envType: Output<String>
        get() = javaResource.envType().applyValue({ args0 -> args0 })

    /**
     * Whether it is a logical Library, the return value is true.
     */
    public val logic: Output<Boolean>
        get() = javaResource.logic().applyValue({ args0 -> args0 })

    /**
     * The ID of the logical Library.
     */
    public val logicDatabaseId: Output<String>
        get() = javaResource.logicDatabaseId().applyValue({ args0 -> args0 })

    /**
     * The user ID list of the logical library Owner.
     */
    public val ownerIdLists: Output<List<String>>
        get() = javaResource.ownerIdLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The nickname list of the logical library Owner.
     */
    public val ownerNameLists: Output<List<String>>
        get() = javaResource.ownerNameLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Logical Library name.
     */
    public val schemaName: Output<String>
        get() = javaResource.schemaName().applyValue({ args0 -> args0 })

    /**
     * Logical library search name.
     */
    public val searchName: Output<String>
        get() = javaResource.searchName().applyValue({ args0 -> args0 })
}

public object EnterpriseLogicDatabaseMapper : ResourceMapper<EnterpriseLogicDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dms.EnterpriseLogicDatabase::class == javaResource::class

    override fun map(javaResource: Resource): EnterpriseLogicDatabase =
        EnterpriseLogicDatabase(javaResource as com.pulumi.alicloud.dms.EnterpriseLogicDatabase)
}

/**
 * @see [EnterpriseLogicDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterpriseLogicDatabase].
 */
public suspend fun enterpriseLogicDatabase(
    name: String,
    block: suspend EnterpriseLogicDatabaseResourceBuilder.() -> Unit,
): EnterpriseLogicDatabase {
    val builder = EnterpriseLogicDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterpriseLogicDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterpriseLogicDatabase(name: String): EnterpriseLogicDatabase {
    val builder = EnterpriseLogicDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
