@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.alicloud.dms.EnterpriseLogicDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DMS Enterprise Logic Database resource.
 * For information about DMS Enterprise Logic Database and how to use it, see [What is Logic Database](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-createlogicdatabase).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dms.EnterpriseLogicDatabase("default", {
 *     alias: "TF_logic_db_test",
 *     databaseIds: [
 *         "35617919",
 *         "35617920",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dms.EnterpriseLogicDatabase("default",
 *     alias="TF_logic_db_test",
 *     database_ids=[
 *         "35617919",
 *         "35617920",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dms.EnterpriseLogicDatabase("default", new()
 *     {
 *         Alias = "TF_logic_db_test",
 *         DatabaseIds = new[]
 *         {
 *             "35617919",
 *             "35617920",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dms.NewEnterpriseLogicDatabase(ctx, "default", &dms.EnterpriseLogicDatabaseArgs{
 * 			Alias: pulumi.String("TF_logic_db_test"),
 * 			DatabaseIds: pulumi.StringArray{
 * 				pulumi.String("35617919"),
 * 				pulumi.String("35617920"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dms.EnterpriseLogicDatabase;
 * import com.pulumi.alicloud.dms.EnterpriseLogicDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new EnterpriseLogicDatabase("default", EnterpriseLogicDatabaseArgs.builder()
 *             .alias("TF_logic_db_test")
 *             .databaseIds(
 *                 "35617919",
 *                 "35617920")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dms:EnterpriseLogicDatabase
 *     properties:
 *       alias: TF_logic_db_test
 *       databaseIds:
 *         - '35617919'
 *         - '35617920'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise Logic Database can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseLogicDatabase:EnterpriseLogicDatabase example <id>
 * ```
 * @property alias Logical Library alias.
 * @property databaseIds Sub-Database ID
 * @property logicDatabaseId The ID of the logical Library.
 */
public data class EnterpriseLogicDatabaseArgs(
    public val alias: Output<String>? = null,
    public val databaseIds: Output<List<String>>? = null,
    public val logicDatabaseId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.EnterpriseLogicDatabaseArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.EnterpriseLogicDatabaseArgs =
        com.pulumi.alicloud.dms.EnterpriseLogicDatabaseArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .databaseIds(databaseIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .logicDatabaseId(logicDatabaseId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseLogicDatabaseArgs].
 */
@PulumiTagMarker
public class EnterpriseLogicDatabaseArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var databaseIds: Output<List<String>>? = null

    private var logicDatabaseId: Output<String>? = null

    /**
     * @param value Logical Library alias.
     */
    @JvmName("cpqxhixwqfudoihm")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Sub-Database ID
     */
    @JvmName("benglcqhdgdsbwkl")
    public suspend fun databaseIds(`value`: Output<List<String>>) {
        this.databaseIds = value
    }

    @JvmName("njonwbyhgulekpxv")
    public suspend fun databaseIds(vararg values: Output<String>) {
        this.databaseIds = Output.all(values.asList())
    }

    /**
     * @param values Sub-Database ID
     */
    @JvmName("pgiubwaptaiqfmoi")
    public suspend fun databaseIds(values: List<Output<String>>) {
        this.databaseIds = Output.all(values)
    }

    /**
     * @param value The ID of the logical Library.
     */
    @JvmName("mcvvathjinywwmvs")
    public suspend fun logicDatabaseId(`value`: Output<String>) {
        this.logicDatabaseId = value
    }

    /**
     * @param value Logical Library alias.
     */
    @JvmName("vxhxameiggtktuhf")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Sub-Database ID
     */
    @JvmName("gphjhqxtwecnxnij")
    public suspend fun databaseIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseIds = mapped
    }

    /**
     * @param values Sub-Database ID
     */
    @JvmName("dpdrlumkbrgrdoba")
    public suspend fun databaseIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseIds = mapped
    }

    /**
     * @param value The ID of the logical Library.
     */
    @JvmName("lmficxtnpfpfnkep")
    public suspend fun logicDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicDatabaseId = mapped
    }

    internal fun build(): EnterpriseLogicDatabaseArgs = EnterpriseLogicDatabaseArgs(
        alias = alias,
        databaseIds = databaseIds,
        logicDatabaseId = logicDatabaseId,
    )
}
