@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnterpriseProxyAccess].
 */
@PulumiTagMarker
public class EnterpriseProxyAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterpriseProxyAccessArgs = EnterpriseProxyAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnterpriseProxyAccessArgsBuilder.() -> Unit) {
        val builder = EnterpriseProxyAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnterpriseProxyAccess {
        val builtJavaResource = com.pulumi.alicloud.dms.EnterpriseProxyAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnterpriseProxyAccess(builtJavaResource)
    }
}

/**
 * Provides a DMS Enterprise Proxy Access resource.
 * For information about DMS Enterprise Proxy Access and how to use it, see [What is Proxy Access](https://next.api.alibabacloud.com/document/dms-enterprise/2018-11-01/CreateProxyAccess).
 * > **NOTE:** Available since v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const dmsEnterpriseUsersDs = alicloud.dms.getEnterpriseUsers({
 *     role: "USER",
 *     status: "NORMAL",
 * });
 * const ids = alicloud.dms.getEnterpriseProxies({});
 * const _default = new alicloud.dms.EnterpriseProxyAccess("default", {
 *     proxyId: ids.then(ids => ids.proxies?.[0]?.id),
 *     userId: dmsEnterpriseUsersDs.then(dmsEnterpriseUsersDs => dmsEnterpriseUsersDs.users?.[0]?.userId),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * dms_enterprise_users_ds = alicloud.dms.get_enterprise_users(role="USER",
 *     status="NORMAL")
 * ids = alicloud.dms.get_enterprise_proxies()
 * default = alicloud.dms.EnterpriseProxyAccess("default",
 *     proxy_id=ids.proxies[0].id,
 *     user_id=dms_enterprise_users_ds.users[0].user_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dmsEnterpriseUsersDs = AliCloud.Dms.GetEnterpriseUsers.Invoke(new()
 *     {
 *         Role = "USER",
 *         Status = "NORMAL",
 *     });
 *     var ids = AliCloud.Dms.GetEnterpriseProxies.Invoke();
 *     var @default = new AliCloud.Dms.EnterpriseProxyAccess("default", new()
 *     {
 *         ProxyId = ids.Apply(getEnterpriseProxiesResult => getEnterpriseProxiesResult.Proxies[0]?.Id),
 *         UserId = dmsEnterpriseUsersDs.Apply(getEnterpriseUsersResult => getEnterpriseUsersResult.Users[0]?.UserId),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		dmsEnterpriseUsersDs, err := dms.GetEnterpriseUsers(ctx, &dms.GetEnterpriseUsersArgs{
 * 			Role:   pulumi.StringRef("USER"),
 * 			Status: pulumi.StringRef("NORMAL"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ids, err := dms.GetEnterpriseProxies(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewEnterpriseProxyAccess(ctx, "default", &dms.EnterpriseProxyAccessArgs{
 * 			ProxyId: pulumi.String(ids.Proxies[0].Id),
 * 			UserId:  pulumi.String(dmsEnterpriseUsersDs.Users[0].UserId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dms.DmsFunctions;
 * import com.pulumi.alicloud.dms.inputs.GetEnterpriseUsersArgs;
 * import com.pulumi.alicloud.dms.inputs.GetEnterpriseProxiesArgs;
 * import com.pulumi.alicloud.dms.EnterpriseProxyAccess;
 * import com.pulumi.alicloud.dms.EnterpriseProxyAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var dmsEnterpriseUsersDs = DmsFunctions.getEnterpriseUsers(GetEnterpriseUsersArgs.builder()
 *             .role("USER")
 *             .status("NORMAL")
 *             .build());
 *         final var ids = DmsFunctions.getEnterpriseProxies();
 *         var default_ = new EnterpriseProxyAccess("default", EnterpriseProxyAccessArgs.builder()
 *             .proxyId(ids.applyValue(getEnterpriseProxiesResult -> getEnterpriseProxiesResult.proxies()[0].id()))
 *             .userId(dmsEnterpriseUsersDs.applyValue(getEnterpriseUsersResult -> getEnterpriseUsersResult.users()[0].userId()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dms:EnterpriseProxyAccess
 *     properties:
 *       proxyId: ${ids.proxies[0].id}
 *       userId: ${dmsEnterpriseUsersDs.users[0].userId}
 * variables:
 *   dmsEnterpriseUsersDs:
 *     fn::invoke:
 *       Function: alicloud:dms:getEnterpriseUsers
 *       Arguments:
 *         role: USER
 *         status: NORMAL
 *   ids:
 *     fn::invoke:
 *       Function: alicloud:dms:getEnterpriseProxies
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise Proxy Access can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseProxyAccess:EnterpriseProxyAccess example <id>
 * ```
 */
public class EnterpriseProxyAccess internal constructor(
    override val javaResource: com.pulumi.alicloud.dms.EnterpriseProxyAccess,
) : KotlinCustomResource(javaResource, EnterpriseProxyAccessMapper) {
    /**
     * The authorized account of the security agent.
     */
    public val accessId: Output<String>
        get() = javaResource.accessId().applyValue({ args0 -> args0 })

    /**
     * Secure access agent authorization password.
     */
    public val accessSecret: Output<String>
        get() = javaResource.accessSecret().applyValue({ args0 -> args0 })

    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Database account.
     */
    public val indepAccount: Output<String>?
        get() = javaResource.indepAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Database password.
     */
    public val indepPassword: Output<String>?
        get() = javaResource.indepPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The source information of the security access agent permission is enabled, and the return value is as follows:
     * * **Owner Authorization**: The UID of the owner in parentheses.
     * * **Work Order Authorization**: The ticket number in parentheses is the number of the user to apply for permission.
     */
    public val originInfo: Output<String>
        get() = javaResource.originInfo().applyValue({ args0 -> args0 })

    /**
     * Security Protection authorization ID. After the target user is authorized by the security protection agent, the system automatically generates a security protection authorization ID, which is globally unique.
     */
    public val proxyAccessId: Output<String>
        get() = javaResource.proxyAccessId().applyValue({ args0 -> args0 })

    /**
     * The ID of the security agent.
     */
    public val proxyId: Output<String>
        get() = javaResource.proxyId().applyValue({ args0 -> args0 })

    /**
     * The user ID.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })

    /**
     * User nickname.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })

    /**
     * User UID.
     */
    public val userUid: Output<String>
        get() = javaResource.userUid().applyValue({ args0 -> args0 })
}

public object EnterpriseProxyAccessMapper : ResourceMapper<EnterpriseProxyAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dms.EnterpriseProxyAccess::class == javaResource::class

    override fun map(javaResource: Resource): EnterpriseProxyAccess =
        EnterpriseProxyAccess(javaResource as com.pulumi.alicloud.dms.EnterpriseProxyAccess)
}

/**
 * @see [EnterpriseProxyAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterpriseProxyAccess].
 */
public suspend fun enterpriseProxyAccess(
    name: String,
    block: suspend EnterpriseProxyAccessResourceBuilder.() -> Unit,
): EnterpriseProxyAccess {
    val builder = EnterpriseProxyAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterpriseProxyAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterpriseProxyAccess(name: String): EnterpriseProxyAccess {
    val builder = EnterpriseProxyAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
