@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.alicloud.dms.EnterpriseProxyAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DMS Enterprise Proxy Access resource.
 * For information about DMS Enterprise Proxy Access and how to use it, see [What is Proxy Access](https://next.api.alibabacloud.com/document/dms-enterprise/2018-11-01/CreateProxyAccess).
 * > **NOTE:** Available since v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const dmsEnterpriseUsersDs = alicloud.dms.getEnterpriseUsers({
 *     role: "USER",
 *     status: "NORMAL",
 * });
 * const ids = alicloud.dms.getEnterpriseProxies({});
 * const _default = new alicloud.dms.EnterpriseProxyAccess("default", {
 *     proxyId: ids.then(ids => ids.proxies?.[0]?.id),
 *     userId: dmsEnterpriseUsersDs.then(dmsEnterpriseUsersDs => dmsEnterpriseUsersDs.users?.[0]?.userId),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * dms_enterprise_users_ds = alicloud.dms.get_enterprise_users(role="USER",
 *     status="NORMAL")
 * ids = alicloud.dms.get_enterprise_proxies()
 * default = alicloud.dms.EnterpriseProxyAccess("default",
 *     proxy_id=ids.proxies[0].id,
 *     user_id=dms_enterprise_users_ds.users[0].user_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dmsEnterpriseUsersDs = AliCloud.Dms.GetEnterpriseUsers.Invoke(new()
 *     {
 *         Role = "USER",
 *         Status = "NORMAL",
 *     });
 *     var ids = AliCloud.Dms.GetEnterpriseProxies.Invoke();
 *     var @default = new AliCloud.Dms.EnterpriseProxyAccess("default", new()
 *     {
 *         ProxyId = ids.Apply(getEnterpriseProxiesResult => getEnterpriseProxiesResult.Proxies[0]?.Id),
 *         UserId = dmsEnterpriseUsersDs.Apply(getEnterpriseUsersResult => getEnterpriseUsersResult.Users[0]?.UserId),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		dmsEnterpriseUsersDs, err := dms.GetEnterpriseUsers(ctx, &dms.GetEnterpriseUsersArgs{
 * 			Role:   pulumi.StringRef("USER"),
 * 			Status: pulumi.StringRef("NORMAL"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ids, err := dms.GetEnterpriseProxies(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewEnterpriseProxyAccess(ctx, "default", &dms.EnterpriseProxyAccessArgs{
 * 			ProxyId: pulumi.String(ids.Proxies[0].Id),
 * 			UserId:  pulumi.String(dmsEnterpriseUsersDs.Users[0].UserId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dms.DmsFunctions;
 * import com.pulumi.alicloud.dms.inputs.GetEnterpriseUsersArgs;
 * import com.pulumi.alicloud.dms.inputs.GetEnterpriseProxiesArgs;
 * import com.pulumi.alicloud.dms.EnterpriseProxyAccess;
 * import com.pulumi.alicloud.dms.EnterpriseProxyAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var dmsEnterpriseUsersDs = DmsFunctions.getEnterpriseUsers(GetEnterpriseUsersArgs.builder()
 *             .role("USER")
 *             .status("NORMAL")
 *             .build());
 *         final var ids = DmsFunctions.getEnterpriseProxies();
 *         var default_ = new EnterpriseProxyAccess("default", EnterpriseProxyAccessArgs.builder()
 *             .proxyId(ids.applyValue(getEnterpriseProxiesResult -> getEnterpriseProxiesResult.proxies()[0].id()))
 *             .userId(dmsEnterpriseUsersDs.applyValue(getEnterpriseUsersResult -> getEnterpriseUsersResult.users()[0].userId()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dms:EnterpriseProxyAccess
 *     properties:
 *       proxyId: ${ids.proxies[0].id}
 *       userId: ${dmsEnterpriseUsersDs.users[0].userId}
 * variables:
 *   dmsEnterpriseUsersDs:
 *     fn::invoke:
 *       Function: alicloud:dms:getEnterpriseUsers
 *       Arguments:
 *         role: USER
 *         status: NORMAL
 *   ids:
 *     fn::invoke:
 *       Function: alicloud:dms:getEnterpriseProxies
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise Proxy Access can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseProxyAccess:EnterpriseProxyAccess example <id>
 * ```
 * @property indepAccount Database account.
 * @property indepPassword Database password.
 * @property proxyAccessId Security Protection authorization ID. After the target user is authorized by the security protection agent, the system automatically generates a security protection authorization ID, which is globally unique.
 * @property proxyId The ID of the security agent.
 * @property userId The user ID.
 */
public data class EnterpriseProxyAccessArgs(
    public val indepAccount: Output<String>? = null,
    public val indepPassword: Output<String>? = null,
    public val proxyAccessId: Output<String>? = null,
    public val proxyId: Output<String>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.EnterpriseProxyAccessArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.EnterpriseProxyAccessArgs =
        com.pulumi.alicloud.dms.EnterpriseProxyAccessArgs.builder()
            .indepAccount(indepAccount?.applyValue({ args0 -> args0 }))
            .indepPassword(indepPassword?.applyValue({ args0 -> args0 }))
            .proxyAccessId(proxyAccessId?.applyValue({ args0 -> args0 }))
            .proxyId(proxyId?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseProxyAccessArgs].
 */
@PulumiTagMarker
public class EnterpriseProxyAccessArgsBuilder internal constructor() {
    private var indepAccount: Output<String>? = null

    private var indepPassword: Output<String>? = null

    private var proxyAccessId: Output<String>? = null

    private var proxyId: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value Database account.
     */
    @JvmName("festabjaabkyfaev")
    public suspend fun indepAccount(`value`: Output<String>) {
        this.indepAccount = value
    }

    /**
     * @param value Database password.
     */
    @JvmName("yvchbmkbyfgcfuhv")
    public suspend fun indepPassword(`value`: Output<String>) {
        this.indepPassword = value
    }

    /**
     * @param value Security Protection authorization ID. After the target user is authorized by the security protection agent, the system automatically generates a security protection authorization ID, which is globally unique.
     */
    @JvmName("aimktrscvnakjpap")
    public suspend fun proxyAccessId(`value`: Output<String>) {
        this.proxyAccessId = value
    }

    /**
     * @param value The ID of the security agent.
     */
    @JvmName("osjwasgwrguxgchk")
    public suspend fun proxyId(`value`: Output<String>) {
        this.proxyId = value
    }

    /**
     * @param value The user ID.
     */
    @JvmName("nxpvtreataensnle")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value Database account.
     */
    @JvmName("koiwqoibtruxlwod")
    public suspend fun indepAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indepAccount = mapped
    }

    /**
     * @param value Database password.
     */
    @JvmName("xkergayduletykij")
    public suspend fun indepPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indepPassword = mapped
    }

    /**
     * @param value Security Protection authorization ID. After the target user is authorized by the security protection agent, the system automatically generates a security protection authorization ID, which is globally unique.
     */
    @JvmName("xlhakpywisraoxmb")
    public suspend fun proxyAccessId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyAccessId = mapped
    }

    /**
     * @param value The ID of the security agent.
     */
    @JvmName("lbgbkysxxaifpmox")
    public suspend fun proxyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyId = mapped
    }

    /**
     * @param value The user ID.
     */
    @JvmName("xmhpeeolllslblii")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): EnterpriseProxyAccessArgs = EnterpriseProxyAccessArgs(
        indepAccount = indepAccount,
        indepPassword = indepPassword,
        proxyAccessId = proxyAccessId,
        proxyId = proxyId,
        userId = userId,
    )
}
