@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EnterpriseUser].
 */
@PulumiTagMarker
public class EnterpriseUserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterpriseUserArgs = EnterpriseUserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnterpriseUserArgsBuilder.() -> Unit) {
        val builder = EnterpriseUserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnterpriseUser {
        val builtJavaResource = com.pulumi.alicloud.dms.EnterpriseUser(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnterpriseUser(builtJavaResource)
    }
}

/**
 * Provides a DMS Enterprise User resource. For information about Alidms Enterprise User and how to use it, see [What is Resource Alidms Enterprise User](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-registeruser).
 * > **NOTE:** Available since v1.90.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexamplename";
 * const _default = new alicloud.ram.User("default", {
 *     name: name,
 *     displayName: name,
 *     mobile: "86-18688888888",
 *     email: "hello.uuu@aaa.com",
 *     comments: "example",
 * });
 * const defaultEnterpriseUser = new alicloud.dms.EnterpriseUser("default", {
 *     uid: _default.id,
 *     userName: name,
 *     roleNames: ["DBA"],
 *     mobile: "86-18688888888",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexamplename"
 * default = alicloud.ram.User("default",
 *     name=name,
 *     display_name=name,
 *     mobile="86-18688888888",
 *     email="hello.uuu@aaa.com",
 *     comments="example")
 * default_enterprise_user = alicloud.dms.EnterpriseUser("default",
 *     uid=default.id,
 *     user_name=name,
 *     role_names=["DBA"],
 *     mobile="86-18688888888")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexamplename";
 *     var @default = new AliCloud.Ram.User("default", new()
 *     {
 *         Name = name,
 *         DisplayName = name,
 *         Mobile = "86-18688888888",
 *         Email = "hello.uuu@aaa.com",
 *         Comments = "example",
 *     });
 *     var defaultEnterpriseUser = new AliCloud.Dms.EnterpriseUser("default", new()
 *     {
 *         Uid = @default.Id,
 *         UserName = name,
 *         RoleNames = new[]
 *         {
 *             "DBA",
 *         },
 *         Mobile = "86-18688888888",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexamplename"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ram.NewUser(ctx, "default", &ram.UserArgs{
 * 			Name:        pulumi.String(name),
 * 			DisplayName: pulumi.String(name),
 * 			Mobile:      pulumi.String("86-18688888888"),
 * 			Email:       pulumi.String("hello.uuu@aaa.com"),
 * 			Comments:    pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewEnterpriseUser(ctx, "default", &dms.EnterpriseUserArgs{
 * 			Uid:      _default.ID(),
 * 			UserName: pulumi.String(name),
 * 			RoleNames: pulumi.StringArray{
 * 				pulumi.String("DBA"),
 * 			},
 * 			Mobile: pulumi.String("86-18688888888"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import com.pulumi.alicloud.dms.EnterpriseUser;
 * import com.pulumi.alicloud.dms.EnterpriseUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexamplename");
 *         var default_ = new User("default", UserArgs.builder()
 *             .name(name)
 *             .displayName(name)
 *             .mobile("86-18688888888")
 *             .email("hello.uuu@aaa.com")
 *             .comments("example")
 *             .build());
 *         var defaultEnterpriseUser = new EnterpriseUser("defaultEnterpriseUser", EnterpriseUserArgs.builder()
 *             .uid(default_.id())
 *             .userName(name)
 *             .roleNames("DBA")
 *             .mobile("86-18688888888")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexamplename
 * resources:
 *   default:
 *     type: alicloud:ram:User
 *     properties:
 *       name: ${name}
 *       displayName: ${name}
 *       mobile: 86-18688888888
 *       email: hello.uuu@aaa.com
 *       comments: example
 *   defaultEnterpriseUser:
 *     type: alicloud:dms:EnterpriseUser
 *     name: default
 *     properties:
 *       uid: ${default.id}
 *       userName: ${name}
 *       roleNames:
 *         - DBA
 *       mobile: 86-18688888888
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseUser:EnterpriseUser example 24356xxx
 * ```
 */
public class EnterpriseUser internal constructor(
    override val javaResource: com.pulumi.alicloud.dms.EnterpriseUser,
) : KotlinCustomResource(javaResource, EnterpriseUserMapper) {
    /**
     * Maximum number of inquiries on the day.
     */
    public val maxExecuteCount: Output<Int>?
        get() = javaResource.maxExecuteCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Query the maximum number of rows on the day.
     */
    public val maxResultCount: Output<Int>?
        get() = javaResource.maxResultCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DingTalk number or mobile number of the user.
     */
    public val mobile: Output<String>?
        get() = javaResource.mobile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * It has been deprecated from 1.100.0 and use `user_name` instead.
     */
    @Deprecated(
        message = """
  Field 'nick_name' has been deprecated from version 1.100.0. Use 'user_name' instead.
  """,
    )
    public val nickName: Output<String>
        get() = javaResource.nickName().applyValue({ args0 -> args0 })

    /**
     * The roles that the user plays.
     */
    public val roleNames: Output<List<String>>?
        get() = javaResource.roleNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The state of DMS Enterprise User. Valid values: `NORMAL`, `DISABLE`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tenant ID.
     */
    public val tid: Output<Int>?
        get() = javaResource.tid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Alibaba Cloud unique ID (UID) of the user to add.
     */
    public val uid: Output<String>
        get() = javaResource.uid().applyValue({ args0 -> args0 })

    /**
     * The nickname of the user.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object EnterpriseUserMapper : ResourceMapper<EnterpriseUser> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dms.EnterpriseUser::class == javaResource::class

    override fun map(javaResource: Resource): EnterpriseUser = EnterpriseUser(
        javaResource as
            com.pulumi.alicloud.dms.EnterpriseUser,
    )
}

/**
 * @see [EnterpriseUser].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterpriseUser].
 */
public suspend fun enterpriseUser(
    name: String,
    block: suspend EnterpriseUserResourceBuilder.() -> Unit,
): EnterpriseUser {
    val builder = EnterpriseUserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterpriseUser].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterpriseUser(name: String): EnterpriseUser {
    val builder = EnterpriseUserResourceBuilder()
    builder.name(name)
    return builder.build()
}
