@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin

import com.pulumi.alicloud.dms.EnterpriseUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DMS Enterprise User resource. For information about Alidms Enterprise User and how to use it, see [What is Resource Alidms Enterprise User](https://www.alibabacloud.com/help/en/dms/developer-reference/api-dms-enterprise-2018-11-01-registeruser).
 * > **NOTE:** Available since v1.90.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexamplename";
 * const _default = new alicloud.ram.User("default", {
 *     name: name,
 *     displayName: name,
 *     mobile: "86-18688888888",
 *     email: "hello.uuu@aaa.com",
 *     comments: "example",
 * });
 * const defaultEnterpriseUser = new alicloud.dms.EnterpriseUser("default", {
 *     uid: _default.id,
 *     userName: name,
 *     roleNames: ["DBA"],
 *     mobile: "86-18688888888",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexamplename"
 * default = alicloud.ram.User("default",
 *     name=name,
 *     display_name=name,
 *     mobile="86-18688888888",
 *     email="hello.uuu@aaa.com",
 *     comments="example")
 * default_enterprise_user = alicloud.dms.EnterpriseUser("default",
 *     uid=default.id,
 *     user_name=name,
 *     role_names=["DBA"],
 *     mobile="86-18688888888")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexamplename";
 *     var @default = new AliCloud.Ram.User("default", new()
 *     {
 *         Name = name,
 *         DisplayName = name,
 *         Mobile = "86-18688888888",
 *         Email = "hello.uuu@aaa.com",
 *         Comments = "example",
 *     });
 *     var defaultEnterpriseUser = new AliCloud.Dms.EnterpriseUser("default", new()
 *     {
 *         Uid = @default.Id,
 *         UserName = name,
 *         RoleNames = new[]
 *         {
 *             "DBA",
 *         },
 *         Mobile = "86-18688888888",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexamplename"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ram.NewUser(ctx, "default", &ram.UserArgs{
 * 			Name:        pulumi.String(name),
 * 			DisplayName: pulumi.String(name),
 * 			Mobile:      pulumi.String("86-18688888888"),
 * 			Email:       pulumi.String("hello.uuu@aaa.com"),
 * 			Comments:    pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dms.NewEnterpriseUser(ctx, "default", &dms.EnterpriseUserArgs{
 * 			Uid:      _default.ID(),
 * 			UserName: pulumi.String(name),
 * 			RoleNames: pulumi.StringArray{
 * 				pulumi.String("DBA"),
 * 			},
 * 			Mobile: pulumi.String("86-18688888888"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ram.User;
 * import com.pulumi.alicloud.ram.UserArgs;
 * import com.pulumi.alicloud.dms.EnterpriseUser;
 * import com.pulumi.alicloud.dms.EnterpriseUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexamplename");
 *         var default_ = new User("default", UserArgs.builder()
 *             .name(name)
 *             .displayName(name)
 *             .mobile("86-18688888888")
 *             .email("hello.uuu@aaa.com")
 *             .comments("example")
 *             .build());
 *         var defaultEnterpriseUser = new EnterpriseUser("defaultEnterpriseUser", EnterpriseUserArgs.builder()
 *             .uid(default_.id())
 *             .userName(name)
 *             .roleNames("DBA")
 *             .mobile("86-18688888888")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexamplename
 * resources:
 *   default:
 *     type: alicloud:ram:User
 *     properties:
 *       name: ${name}
 *       displayName: ${name}
 *       mobile: 86-18688888888
 *       email: hello.uuu@aaa.com
 *       comments: example
 *   defaultEnterpriseUser:
 *     type: alicloud:dms:EnterpriseUser
 *     name: default
 *     properties:
 *       uid: ${default.id}
 *       userName: ${name}
 *       roleNames:
 *         - DBA
 *       mobile: 86-18688888888
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DMS Enterprise User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dms/enterpriseUser:EnterpriseUser example 24356xxx
 * ```
 * @property maxExecuteCount Maximum number of inquiries on the day.
 * @property maxResultCount Query the maximum number of rows on the day.
 * @property mobile The DingTalk number or mobile number of the user.
 * @property nickName It has been deprecated from 1.100.0 and use `user_name` instead.
 * @property roleNames The roles that the user plays.
 * @property status The state of DMS Enterprise User. Valid values: `NORMAL`, `DISABLE`.
 * @property tid The tenant ID.
 * @property uid The Alibaba Cloud unique ID (UID) of the user to add.
 * @property userName The nickname of the user.
 */
public data class EnterpriseUserArgs(
    public val maxExecuteCount: Output<Int>? = null,
    public val maxResultCount: Output<Int>? = null,
    public val mobile: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'nick_name' has been deprecated from version 1.100.0. Use 'user_name' instead.
  """,
    )
    public val nickName: Output<String>? = null,
    public val roleNames: Output<List<String>>? = null,
    public val status: Output<String>? = null,
    public val tid: Output<Int>? = null,
    public val uid: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.EnterpriseUserArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.EnterpriseUserArgs =
        com.pulumi.alicloud.dms.EnterpriseUserArgs.builder()
            .maxExecuteCount(maxExecuteCount?.applyValue({ args0 -> args0 }))
            .maxResultCount(maxResultCount?.applyValue({ args0 -> args0 }))
            .mobile(mobile?.applyValue({ args0 -> args0 }))
            .nickName(nickName?.applyValue({ args0 -> args0 }))
            .roleNames(roleNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tid(tid?.applyValue({ args0 -> args0 }))
            .uid(uid?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseUserArgs].
 */
@PulumiTagMarker
public class EnterpriseUserArgsBuilder internal constructor() {
    private var maxExecuteCount: Output<Int>? = null

    private var maxResultCount: Output<Int>? = null

    private var mobile: Output<String>? = null

    private var nickName: Output<String>? = null

    private var roleNames: Output<List<String>>? = null

    private var status: Output<String>? = null

    private var tid: Output<Int>? = null

    private var uid: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Maximum number of inquiries on the day.
     */
    @JvmName("gauearodnjnqutpd")
    public suspend fun maxExecuteCount(`value`: Output<Int>) {
        this.maxExecuteCount = value
    }

    /**
     * @param value Query the maximum number of rows on the day.
     */
    @JvmName("drkqsfqgpmcbbvau")
    public suspend fun maxResultCount(`value`: Output<Int>) {
        this.maxResultCount = value
    }

    /**
     * @param value The DingTalk number or mobile number of the user.
     */
    @JvmName("xqeosycojdsntonq")
    public suspend fun mobile(`value`: Output<String>) {
        this.mobile = value
    }

    /**
     * @param value It has been deprecated from 1.100.0 and use `user_name` instead.
     */
    @Deprecated(
        message = """
  Field 'nick_name' has been deprecated from version 1.100.0. Use 'user_name' instead.
  """,
    )
    @JvmName("ggdqdbfvkcglyfdn")
    public suspend fun nickName(`value`: Output<String>) {
        this.nickName = value
    }

    /**
     * @param value The roles that the user plays.
     */
    @JvmName("rcrhdqrfmqbsxare")
    public suspend fun roleNames(`value`: Output<List<String>>) {
        this.roleNames = value
    }

    @JvmName("bcscgwesdpsokldk")
    public suspend fun roleNames(vararg values: Output<String>) {
        this.roleNames = Output.all(values.asList())
    }

    /**
     * @param values The roles that the user plays.
     */
    @JvmName("vgqfqitldomxwqsm")
    public suspend fun roleNames(values: List<Output<String>>) {
        this.roleNames = Output.all(values)
    }

    /**
     * @param value The state of DMS Enterprise User. Valid values: `NORMAL`, `DISABLE`.
     */
    @JvmName("rhekatkxupeqsofy")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The tenant ID.
     */
    @JvmName("djdnmkubyisrlddw")
    public suspend fun tid(`value`: Output<Int>) {
        this.tid = value
    }

    /**
     * @param value The Alibaba Cloud unique ID (UID) of the user to add.
     */
    @JvmName("duarhnpjrggjflxd")
    public suspend fun uid(`value`: Output<String>) {
        this.uid = value
    }

    /**
     * @param value The nickname of the user.
     */
    @JvmName("dmpxeqcjpdvlrcvu")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Maximum number of inquiries on the day.
     */
    @JvmName("vuyswyvdiiybqwib")
    public suspend fun maxExecuteCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxExecuteCount = mapped
    }

    /**
     * @param value Query the maximum number of rows on the day.
     */
    @JvmName("ssrclmdlicnqksjp")
    public suspend fun maxResultCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxResultCount = mapped
    }

    /**
     * @param value The DingTalk number or mobile number of the user.
     */
    @JvmName("hbcufyhmwcotsocc")
    public suspend fun mobile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobile = mapped
    }

    /**
     * @param value It has been deprecated from 1.100.0 and use `user_name` instead.
     */
    @Deprecated(
        message = """
  Field 'nick_name' has been deprecated from version 1.100.0. Use 'user_name' instead.
  """,
    )
    @JvmName("gjmoqwynervnfpee")
    public suspend fun nickName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nickName = mapped
    }

    /**
     * @param value The roles that the user plays.
     */
    @JvmName("uwtuceiktholgpif")
    public suspend fun roleNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleNames = mapped
    }

    /**
     * @param values The roles that the user plays.
     */
    @JvmName("yppnldgmoeivbuyt")
    public suspend fun roleNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleNames = mapped
    }

    /**
     * @param value The state of DMS Enterprise User. Valid values: `NORMAL`, `DISABLE`.
     */
    @JvmName("lkjwseycbsrwftae")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tenant ID.
     */
    @JvmName("arhafqyvroyhtrve")
    public suspend fun tid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tid = mapped
    }

    /**
     * @param value The Alibaba Cloud unique ID (UID) of the user to add.
     */
    @JvmName("tkxsipphxboftwxd")
    public suspend fun uid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uid = mapped
    }

    /**
     * @param value The nickname of the user.
     */
    @JvmName("boxegtvqgxxjrwjw")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): EnterpriseUserArgs = EnterpriseUserArgs(
        maxExecuteCount = maxExecuteCount,
        maxResultCount = maxResultCount,
        mobile = mobile,
        nickName = nickName,
        roleNames = roleNames,
        status = status,
        tid = tid,
        uid = uid,
        userName = userName,
    )
}
