@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.inputs

import com.pulumi.alicloud.dms.inputs.GetEnterpriseDatabasesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnterpriseDatabases.
 * @property ids A list of Database IDs.
 * @property instanceId The instance ID of the target database.
 * @property nameRegex A regex string to filter the results by the database Schema Name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetEnterpriseDatabasesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.inputs.GetEnterpriseDatabasesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.inputs.GetEnterpriseDatabasesPlainArgs =
        com.pulumi.alicloud.dms.inputs.GetEnterpriseDatabasesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterpriseDatabasesPlainArgs].
 */
@PulumiTagMarker
public class GetEnterpriseDatabasesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Database IDs.
     */
    @JvmName("teigwhshdowfquvq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Database IDs.
     */
    @JvmName("brlujwhluuodoosc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The instance ID of the target database.
     */
    @JvmName("awlbopdfkawcmhan")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter the results by the database Schema Name.
     */
    @JvmName("gpyrbplwbjrmbxwy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hohjaoanwpyxfjlj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetEnterpriseDatabasesPlainArgs = GetEnterpriseDatabasesPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
