@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.inputs

import com.pulumi.alicloud.dms.inputs.GetEnterpriseInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnterpriseInstances.
 * @property envType The type of the environment to which the database instance belongs.
 * @property instanceAliasRegex A regex string to filter the results by the DMS Enterprise Instance instance_alias.
 * @property instanceSource The source of the database instance.
 * @property instanceType The ID of the database instance.
 * @property nameRegex A regex string to filter the results by the DMS Enterprise Instance instance_alias.
 * @property netType The network type of the database instance. Valid values: CLASSIC and VPC. For more information about the valid values, see the description of the RegisterInstance operation.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property searchKey The keyword used to query database instances.
 * @property status Filter the results by status of the DMS Enterprise Instances. Valid values: `NORMAL`, `UNAVAILABLE`, `UNKNOWN`, `DELETED`, `DISABLE`.
 * @property tid The ID of the tenant in Data Management (DMS) Enterprise.
 */
public data class GetEnterpriseInstancesPlainArgs(
    public val envType: String? = null,
    public val instanceAliasRegex: String? = null,
    public val instanceSource: String? = null,
    public val instanceType: String? = null,
    public val nameRegex: String? = null,
    public val netType: String? = null,
    public val outputFile: String? = null,
    public val searchKey: String? = null,
    public val status: String? = null,
    public val tid: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.inputs.GetEnterpriseInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.inputs.GetEnterpriseInstancesPlainArgs =
        com.pulumi.alicloud.dms.inputs.GetEnterpriseInstancesPlainArgs.builder()
            .envType(envType?.let({ args0 -> args0 }))
            .instanceAliasRegex(instanceAliasRegex?.let({ args0 -> args0 }))
            .instanceSource(instanceSource?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .netType(netType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .searchKey(searchKey?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tid(tid?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterpriseInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetEnterpriseInstancesPlainArgsBuilder internal constructor() {
    private var envType: String? = null

    private var instanceAliasRegex: String? = null

    private var instanceSource: String? = null

    private var instanceType: String? = null

    private var nameRegex: String? = null

    private var netType: String? = null

    private var outputFile: String? = null

    private var searchKey: String? = null

    private var status: String? = null

    private var tid: Int? = null

    /**
     * @param value The type of the environment to which the database instance belongs.
     */
    @JvmName("vlyqaoyrydcmjtwf")
    public suspend fun envType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.envType = mapped
    }

    /**
     * @param value A regex string to filter the results by the DMS Enterprise Instance instance_alias.
     */
    @JvmName("fjyjxfgqkxqdekjk")
    public suspend fun instanceAliasRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceAliasRegex = mapped
    }

    /**
     * @param value The source of the database instance.
     */
    @JvmName("heyjwmcuexwsikcv")
    public suspend fun instanceSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceSource = mapped
    }

    /**
     * @param value The ID of the database instance.
     */
    @JvmName("lpdokibpykotnfro")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value A regex string to filter the results by the DMS Enterprise Instance instance_alias.
     */
    @JvmName("kaphaajmbhtbdhnc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The network type of the database instance. Valid values: CLASSIC and VPC. For more information about the valid values, see the description of the RegisterInstance operation.
     */
    @JvmName("gxdjxpunqmeexlqh")
    public suspend fun netType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.netType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xqsnfoxfnfctdbfa")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The keyword used to query database instances.
     */
    @JvmName("caokifhwfhsbcgls")
    public suspend fun searchKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchKey = mapped
    }

    /**
     * @param value Filter the results by status of the DMS Enterprise Instances. Valid values: `NORMAL`, `UNAVAILABLE`, `UNKNOWN`, `DELETED`, `DISABLE`.
     */
    @JvmName("xkhbgtfqoonlpbic")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the tenant in Data Management (DMS) Enterprise.
     */
    @JvmName("pqakkbxnjvhhsdhh")
    public suspend fun tid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tid = mapped
    }

    internal fun build(): GetEnterpriseInstancesPlainArgs = GetEnterpriseInstancesPlainArgs(
        envType = envType,
        instanceAliasRegex = instanceAliasRegex,
        instanceSource = instanceSource,
        instanceType = instanceType,
        nameRegex = nameRegex,
        netType = netType,
        outputFile = outputFile,
        searchKey = searchKey,
        status = status,
        tid = tid,
    )
}
