@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.inputs

import com.pulumi.alicloud.dms.inputs.GetEnterpriseLogicDatabasesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnterpriseLogicDatabases.
 * @property ids A list of Logic Database IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetEnterpriseLogicDatabasesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.inputs.GetEnterpriseLogicDatabasesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.inputs.GetEnterpriseLogicDatabasesPlainArgs =
        com.pulumi.alicloud.dms.inputs.GetEnterpriseLogicDatabasesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterpriseLogicDatabasesPlainArgs].
 */
@PulumiTagMarker
public class GetEnterpriseLogicDatabasesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Logic Database IDs.
     */
    @JvmName("osncxyphjjgteigk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Logic Database IDs.
     */
    @JvmName("jnyfmnbdvvwwuoit")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sxpicqdatgnsbisx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetEnterpriseLogicDatabasesPlainArgs = GetEnterpriseLogicDatabasesPlainArgs(
        ids = ids,
        outputFile = outputFile,
    )
}
