@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.inputs

import com.pulumi.alicloud.dms.inputs.GetEnterpriseProxiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnterpriseProxies.
 * @property ids A list of Proxy IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property tid The ID of the tenant.
 */
public data class GetEnterpriseProxiesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val tid: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.inputs.GetEnterpriseProxiesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.inputs.GetEnterpriseProxiesPlainArgs =
        com.pulumi.alicloud.dms.inputs.GetEnterpriseProxiesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tid(tid?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterpriseProxiesPlainArgs].
 */
@PulumiTagMarker
public class GetEnterpriseProxiesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var tid: String? = null

    /**
     * @param value A list of Proxy IDs.
     */
    @JvmName("mxogrumqtwucwtoh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Proxy IDs.
     */
    @JvmName("bewqdienbtcruwqt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("casqueredfnjlobr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the tenant.
     */
    @JvmName("texpujkffyeocknj")
    public suspend fun tid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tid = mapped
    }

    internal fun build(): GetEnterpriseProxiesPlainArgs = GetEnterpriseProxiesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        tid = tid,
    )
}
