@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.inputs

import com.pulumi.alicloud.dms.inputs.GetEnterpriseProxyAccessesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnterpriseProxyAccesses.
 * @property enableDetails
 * @property ids A list of Proxy Access IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property proxyId The ID of the security agent.
 */
public data class GetEnterpriseProxyAccessesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val proxyId: String,
) : ConvertibleToJava<com.pulumi.alicloud.dms.inputs.GetEnterpriseProxyAccessesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.inputs.GetEnterpriseProxyAccessesPlainArgs =
        com.pulumi.alicloud.dms.inputs.GetEnterpriseProxyAccessesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .proxyId(proxyId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterpriseProxyAccessesPlainArgs].
 */
@PulumiTagMarker
public class GetEnterpriseProxyAccessesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var proxyId: String? = null

    /**
     * @param value
     */
    @JvmName("vpauconkssrcxyxc")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Proxy Access IDs.
     */
    @JvmName("qubnkvjdjajupefy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Proxy Access IDs.
     */
    @JvmName("vvhnxubyxjccpyws")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pokbdiiykjqmnkyo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the security agent.
     */
    @JvmName("xkuqfobdqjmeccwh")
    public suspend fun proxyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.proxyId = mapped
    }

    internal fun build(): GetEnterpriseProxyAccessesPlainArgs = GetEnterpriseProxyAccessesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        proxyId = proxyId ?: throw PulumiNullFieldException("proxyId"),
    )
}
