@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.inputs

import com.pulumi.alicloud.dms.inputs.GetEnterpriseUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnterpriseUsers.
 * @property ids A list of DMS Enterprise User IDs (UID).
 * @property nameRegex A regex string to filter the results by the DMS Enterprise User nick_name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property role The role of the user to query.
 * @property searchKey The keyword used to query users.
 * @property status The status of the user.
 * @property tid The ID of the tenant in DMS Enterprise.
 */
public data class GetEnterpriseUsersPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val role: String? = null,
    public val searchKey: String? = null,
    public val status: String? = null,
    public val tid: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.inputs.GetEnterpriseUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.inputs.GetEnterpriseUsersPlainArgs =
        com.pulumi.alicloud.dms.inputs.GetEnterpriseUsersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .role(role?.let({ args0 -> args0 }))
            .searchKey(searchKey?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tid(tid?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterpriseUsersPlainArgs].
 */
@PulumiTagMarker
public class GetEnterpriseUsersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var role: String? = null

    private var searchKey: String? = null

    private var status: String? = null

    private var tid: Int? = null

    /**
     * @param value A list of DMS Enterprise User IDs (UID).
     */
    @JvmName("hmcipbnbxxenrnie")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of DMS Enterprise User IDs (UID).
     */
    @JvmName("hiikosmmjtqlnhgg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter the results by the DMS Enterprise User nick_name.
     */
    @JvmName("iefgyfwmwiveageg")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ewloijsxvldgwflf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The role of the user to query.
     */
    @JvmName("lifgpwjyebbuqoqe")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.role = mapped
    }

    /**
     * @param value The keyword used to query users.
     */
    @JvmName("cjycvgidjojyfdpv")
    public suspend fun searchKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchKey = mapped
    }

    /**
     * @param value The status of the user.
     */
    @JvmName("qsvydkubfclqaakv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the tenant in DMS Enterprise.
     */
    @JvmName("anbflbscyddhunaj")
    public suspend fun tid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tid = mapped
    }

    internal fun build(): GetEnterpriseUsersPlainArgs = GetEnterpriseUsersPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        role = role,
        searchKey = searchKey,
        status = status,
        tid = tid,
    )
}
