@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.inputs

import com.pulumi.alicloud.dms.inputs.GetUserTenantsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserTenants.
 * @property ids A list of DMS User Tenant IDs (TID).
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the user tenant.
 */
public data class GetUserTenantsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dms.inputs.GetUserTenantsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dms.inputs.GetUserTenantsPlainArgs =
        com.pulumi.alicloud.dms.inputs.GetUserTenantsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserTenantsPlainArgs].
 */
@PulumiTagMarker
public class GetUserTenantsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of DMS User Tenant IDs (TID).
     */
    @JvmName("bjfuyiascaswhxkn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of DMS User Tenant IDs (TID).
     */
    @JvmName("rptcekebyfosomnp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rhbvkjhuaubeddun")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the user tenant.
     */
    @JvmName("vuotukoiyhmhvqhx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetUserTenantsPlainArgs = GetUserTenantsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
