@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalogName The name of the Database Directory.> PG Series databases will display the database name.
 * @property databaseId The ID of the physical library.
 * @property dbType Database type.
 * @property dbaId The DBA user ID of the target database.
 * @property dbaName The DBA nickname of the target Library.
 * @property encoding Database encoding.
 * @property envType The environment type of the database.
 * @property host The database connection address.
 * @property id The Database ID, same value as `database_id`.
 * @property instanceId The instance ID of the target database.
 * @property ownerIdLists Library Owner User ID list.
 * @property ownerNameLists Library Owner nickname list.
 * @property port The connection port of the database.
 * @property schemaName The name of the database.> PG Series databases will display schema names.
 * @property searchName Library search name.
 * @property sid Database SID.> only Oracle Database Display.
 * @property state Library status, value description:-**NORMAL**: NORMAL-**DISABLE**: Disabled-**OFFLINE**: OFFLINE-**NOT_EXIST**: does not exist
 */
public data class GetEnterpriseDatabasesDatabase(
    public val catalogName: String,
    public val databaseId: String,
    public val dbType: String,
    public val dbaId: String,
    public val dbaName: String,
    public val encoding: String,
    public val envType: String,
    public val host: String,
    public val id: String,
    public val instanceId: String,
    public val ownerIdLists: List<String>,
    public val ownerNameLists: List<String>,
    public val port: Int,
    public val schemaName: String,
    public val searchName: String,
    public val sid: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseDatabasesDatabase): GetEnterpriseDatabasesDatabase = GetEnterpriseDatabasesDatabase(
            catalogName = javaType.catalogName(),
            databaseId = javaType.databaseId(),
            dbType = javaType.dbType(),
            dbaId = javaType.dbaId(),
            dbaName = javaType.dbaName(),
            encoding = javaType.encoding(),
            envType = javaType.envType(),
            host = javaType.host(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            ownerIdLists = javaType.ownerIdLists().map({ args0 -> args0 }),
            ownerNameLists = javaType.ownerNameLists().map({ args0 -> args0 }),
            port = javaType.port(),
            schemaName = javaType.schemaName(),
            searchName = javaType.searchName(),
            sid = javaType.sid(),
            state = javaType.state(),
        )
    }
}
