@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataLinkName The name of the data link for the database instance.
 * @property databasePassword The logon password of the database instance.
 * @property databaseUser The logon username of the database instance.
 * @property dbaId The ID of the database administrator (DBA) of the database instance.
 * @property dbaNickName The nickname of the DBA.
 * @property ddlOnline Indicates whether the online data description language (DDL) service was enabled for the database instance.
 * @property ecsInstanceId The ID of the Elastic Compute Service (ECS) instance to which the database instance belongs.
 * @property ecsRegion The region where the database instance resides.
 * @property envType The type of the environment to which the database instance belongs.
 * @property exportTimeout The timeout period for exporting the database instance.
 * @property host The endpoint of the database instance.
 * @property id
 * @property instanceAlias The alias of the database instance.
 * @property instanceId The ID of the database instance.
 * @property instanceName
 * @property instanceSource The source of the database instance.
 * @property instanceType The ID of the database instance.
 * @property port The connection port of the database instance.
 * @property queryTimeout The timeout period for querying the database instance.
 * @property safeRuleId The ID of the security rule for the database instance.
 * @property sid The system ID (SID) of the database instance.
 * @property status Filter the results by status of the DMS Enterprise Instances. Valid values: `NORMAL`, `UNAVAILABLE`, `UNKNOWN`, `DELETED`, `DISABLE`.
 * @property useDsql Indicates whether cross-database query was enabled for the database instance.
 * @property vpcId The ID of the Virtual Private Cloud (VPC) to which the database instance belongs.
 */
public data class GetEnterpriseInstancesInstance(
    public val dataLinkName: String,
    public val databasePassword: String,
    public val databaseUser: String,
    public val dbaId: String,
    public val dbaNickName: String,
    public val ddlOnline: Int,
    public val ecsInstanceId: String,
    public val ecsRegion: String,
    public val envType: String,
    public val exportTimeout: Int,
    public val host: String,
    public val id: String,
    public val instanceAlias: String,
    public val instanceId: String,
    public val instanceName: String,
    public val instanceSource: String,
    public val instanceType: String,
    public val port: Int,
    public val queryTimeout: Int,
    public val safeRuleId: String,
    public val sid: String,
    public val status: String,
    public val useDsql: Int,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseInstancesInstance): GetEnterpriseInstancesInstance = GetEnterpriseInstancesInstance(
            dataLinkName = javaType.dataLinkName(),
            databasePassword = javaType.databasePassword(),
            databaseUser = javaType.databaseUser(),
            dbaId = javaType.dbaId(),
            dbaNickName = javaType.dbaNickName(),
            ddlOnline = javaType.ddlOnline(),
            ecsInstanceId = javaType.ecsInstanceId(),
            ecsRegion = javaType.ecsRegion(),
            envType = javaType.envType(),
            exportTimeout = javaType.exportTimeout(),
            host = javaType.host(),
            id = javaType.id(),
            instanceAlias = javaType.instanceAlias(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            instanceSource = javaType.instanceSource(),
            instanceType = javaType.instanceType(),
            port = javaType.port(),
            queryTimeout = javaType.queryTimeout(),
            safeRuleId = javaType.safeRuleId(),
            sid = javaType.sid(),
            status = javaType.status(),
            useDsql = javaType.useDsql(),
            vpcId = javaType.vpcId(),
        )
    }
}
