@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEnterpriseInstances.
 * @property envType The type of the environment to which the database instance belongs..
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of DMS Enterprise IDs (Each of them consists of host:port).
 * @property instanceAliasRegex
 * @property instanceSource The ID of the database instance.
 * @property instanceType The ID of the database instance.
 * @property instances A list of KMS keys. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of DMS Enterprise names.
 * @property netType
 * @property outputFile
 * @property searchKey
 * @property status The status of the database instance.
 * @property tid
 */
public data class GetEnterpriseInstancesResult(
    public val envType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceAliasRegex: String? = null,
    public val instanceSource: String? = null,
    public val instanceType: String? = null,
    public val instances: List<GetEnterpriseInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val netType: String? = null,
    public val outputFile: String? = null,
    public val searchKey: String? = null,
    public val status: String? = null,
    public val tid: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseInstancesResult): GetEnterpriseInstancesResult = GetEnterpriseInstancesResult(
            envType = javaType.envType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceAliasRegex = javaType.instanceAliasRegex().map({ args0 -> args0 }).orElse(null),
            instanceSource = javaType.instanceSource().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            netType = javaType.netType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            searchKey = javaType.searchKey().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tid = javaType.tid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
