@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alias Logical Library alias.
 * @property databaseIds Sub-Database ID.
 * @property dbType Database type.
 * @property envType Environment type, return value is as follows:-product: production environment-dev: development environment-pre: Advance Environment-test: test environment-sit:SIT environment-uat:UAT environment-pet: Pressure measurement environment-stag:STAG environment
 * @property id Logic Database ID.
 * @property logic Whether it is a logical Library, the return value is true.
 * @property logicDatabaseId The ID of the logical Library.
 * @property ownerIdLists The user ID list of the logical library Owner.
 * @property ownerNameLists The nickname list of the logical library Owner.
 * @property schemaName Logical Library name.
 * @property searchName Logical library search name.
 */
public data class GetEnterpriseLogicDatabasesDatabase(
    public val alias: String,
    public val databaseIds: List<String>,
    public val dbType: String,
    public val envType: String,
    public val id: String,
    public val logic: Boolean,
    public val logicDatabaseId: String,
    public val ownerIdLists: List<String>,
    public val ownerNameLists: List<String>,
    public val schemaName: String,
    public val searchName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseLogicDatabasesDatabase): GetEnterpriseLogicDatabasesDatabase = GetEnterpriseLogicDatabasesDatabase(
            alias = javaType.alias(),
            databaseIds = javaType.databaseIds().map({ args0 -> args0 }),
            dbType = javaType.dbType(),
            envType = javaType.envType(),
            id = javaType.id(),
            logic = javaType.logic(),
            logicDatabaseId = javaType.logicDatabaseId(),
            ownerIdLists = javaType.ownerIdLists().map({ args0 -> args0 }),
            ownerNameLists = javaType.ownerNameLists().map({ args0 -> args0 }),
            schemaName = javaType.schemaName(),
            searchName = javaType.searchName(),
        )
    }
}
