@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEnterpriseLogicDatabases.
 * @property databases A list of Logic Database Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Logic Database IDs.
 * @property outputFile
 */
public data class GetEnterpriseLogicDatabasesResult(
    public val databases: List<GetEnterpriseLogicDatabasesDatabase>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseLogicDatabasesResult): GetEnterpriseLogicDatabasesResult = GetEnterpriseLogicDatabasesResult(
            databases = javaType.databases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseLogicDatabasesDatabase.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
