@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property creatorId The ID of the user who enabled the secure access proxy feature.
 * @property creatorName The nickname of the user who enabled the secure access proxy feature.
 * @property httpsPort The port that was used by HTTPS clients to connect to the database instance.
 * @property id The ID of the Proxy.
 * @property instanceId The ID of the database instance.
 * @property privateEnable Indicates whether the internal endpoint is enabled. Default value: true.
 * @property privateHost The internal endpoint.
 * @property protocolPort Database protocol connection port number.
 * @property protocolType Database protocol type, for example, MYSQL.
 * @property proxyId The ID of the secure access proxy.
 * @property publicEnable Indicates whether the public endpoint is enabled.
 * @property publicHost The public endpoint. A public endpoint is returned no matter whether the public endpoint is enabled or disabled. **Note:** When the public network address is in the **true** state, the returned public network address is a valid address with DNS resolution capability. When the public address is in the **false** state, the returned Public address is an invalid address without DNS resolution.
 */
public data class GetEnterpriseProxiesProxy(
    public val creatorId: String,
    public val creatorName: String,
    public val httpsPort: Int,
    public val id: String,
    public val instanceId: String,
    public val privateEnable: Boolean,
    public val privateHost: String,
    public val protocolPort: Int,
    public val protocolType: String,
    public val proxyId: String,
    public val publicEnable: Boolean,
    public val publicHost: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseProxiesProxy): GetEnterpriseProxiesProxy = GetEnterpriseProxiesProxy(
            creatorId = javaType.creatorId(),
            creatorName = javaType.creatorName(),
            httpsPort = javaType.httpsPort(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            privateEnable = javaType.privateEnable(),
            privateHost = javaType.privateHost(),
            protocolPort = javaType.protocolPort(),
            protocolType = javaType.protocolType(),
            proxyId = javaType.proxyId(),
            publicEnable = javaType.publicEnable(),
            publicHost = javaType.publicHost(),
        )
    }
}
