@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEnterpriseProxies.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property proxies
 * @property tid
 */
public data class GetEnterpriseProxiesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val proxies: List<GetEnterpriseProxiesProxy>,
    public val tid: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseProxiesResult): GetEnterpriseProxiesResult = GetEnterpriseProxiesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            proxies = javaType.proxies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseProxiesProxy.Companion.toKotlin(args0)
                })
            }),
            tid = javaType.tid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
