@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessId The authorized account of the security agent.
 * @property accessSecret
 * @property createTime The authorization time of the security access agent permission.
 * @property id Security Protection authorization ID.
 * @property indepAccount Database account.
 * @property instanceId The ID of the instance.
 * @property originInfo The source information of the security access agent permission is enabled, and the return value is as follows:**Owner Authorization**: The UID of the owner in parentheses.**Work Order Authorization**: The ticket number in parentheses is the number of the user to apply for permission.
 * @property proxyAccessId Security Protection authorization ID. After the target user is authorized by the security protection agent, the system automatically generates a security protection authorization ID, which is globally unique.
 * @property proxyId The ID of the security agent.
 * @property userId The user ID.
 * @property userName User nickname.
 * @property userUid User UID.
 */
public data class GetEnterpriseProxyAccessesAccess(
    public val accessId: String,
    public val accessSecret: String,
    public val createTime: String,
    public val id: String,
    public val indepAccount: String,
    public val instanceId: String,
    public val originInfo: String,
    public val proxyAccessId: String,
    public val proxyId: String,
    public val userId: String,
    public val userName: String,
    public val userUid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseProxyAccessesAccess): GetEnterpriseProxyAccessesAccess = GetEnterpriseProxyAccessesAccess(
            accessId = javaType.accessId(),
            accessSecret = javaType.accessSecret(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            indepAccount = javaType.indepAccount(),
            instanceId = javaType.instanceId(),
            originInfo = javaType.originInfo(),
            proxyAccessId = javaType.proxyAccessId(),
            proxyId = javaType.proxyId(),
            userId = javaType.userId(),
            userName = javaType.userName(),
            userUid = javaType.userUid(),
        )
    }
}
