@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEnterpriseProxyAccesses.
 * @property accesses A list of Proxy Access Entries. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Proxy Access IDs.
 * @property outputFile
 * @property proxyId The ID of the security agent.
 */
public data class GetEnterpriseProxyAccessesResult(
    public val accesses: List<GetEnterpriseProxyAccessesAccess>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val proxyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseProxyAccessesResult): GetEnterpriseProxyAccessesResult = GetEnterpriseProxyAccessesResult(
            accesses = javaType.accesses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseProxyAccessesAccess.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            proxyId = javaType.proxyId(),
        )
    }
}
