@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEnterpriseUsers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of DMS Enterprise User IDs (UID).
 * @property nameRegex
 * @property names A list of DMS Enterprise User names.
 * @property outputFile
 * @property role
 * @property searchKey
 * @property status The status of the user.
 * @property tid
 * @property users A list of DMS Enterprise Users. Each element contains the following attributes:
 */
public data class GetEnterpriseUsersResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val role: String? = null,
    public val searchKey: String? = null,
    public val status: String? = null,
    public val tid: Int? = null,
    public val users: List<GetEnterpriseUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseUsersResult): GetEnterpriseUsersResult = GetEnterpriseUsersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
            searchKey = javaType.searchKey().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tid = javaType.tid().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dms.kotlin.outputs.GetEnterpriseUsersUser.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
