@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id The Alibaba Cloud unique ID (UID) of the user.
 * @property mobile The DingTalk number or mobile number of the user.
 * @property nickName The nickname of the user.
 * @property parentUid The Alibaba Cloud unique ID (UID) of the parent account if the user corresponds to a Resource Access Management (RAM) user.
 * @property roleIds The list ids of the role that the user plays.
 * @property roleNames The list names of the role that he user plays.
 * @property status The status of the user.
 * @property uid
 * @property userId The ID of the user.
 * @property userName The nickname of the user.
 */
public data class GetEnterpriseUsersUser(
    public val id: String,
    public val mobile: String,
    public val nickName: String,
    public val parentUid: Int,
    public val roleIds: List<Int>,
    public val roleNames: List<String>,
    public val status: String,
    public val uid: String,
    public val userId: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetEnterpriseUsersUser): GetEnterpriseUsersUser = GetEnterpriseUsersUser(
            id = javaType.id(),
            mobile = javaType.mobile(),
            nickName = javaType.nickName(),
            parentUid = javaType.parentUid(),
            roleIds = javaType.roleIds().map({ args0 -> args0 }),
            roleNames = javaType.roleNames().map({ args0 -> args0 }),
            status = javaType.status(),
            uid = javaType.uid(),
            userId = javaType.userId(),
            userName = javaType.userName(),
        )
    }
}
