@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUserTenants.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of DMS User Tenant IDs (UID).
 * @property names A list of DMS User Tenant names.
 * @property outputFile
 * @property status The status of the user tenant.
 * @property tenants A list of DMS User Tenants. Each element contains the following attributes:
 */
public data class GetUserTenantsResult(
    public val id: String,
    public val ids: List<String>,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tenants: List<GetUserTenantsTenant>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetUserTenantsResult): GetUserTenantsResult = GetUserTenantsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tenants = javaType.tenants().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dms.kotlin.outputs.GetUserTenantsTenant.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
