@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The user tenant id.
 * @property status The status of the user tenant.
 * @property tenantName The name of the user tenant.
 * @property tid The user tenant id. Same as id.
 */
public data class GetUserTenantsTenant(
    public val id: String,
    public val status: String,
    public val tenantName: String,
    public val tid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dms.outputs.GetUserTenantsTenant): GetUserTenantsTenant = GetUserTenantsTenant(
            id = javaType.id(),
            status = javaType.status(),
            tenantName = javaType.tenantName(),
            tid = javaType.tid(),
        )
    }
}
