@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.kotlin.outputs.AccessStrategyDefaultAddrPool
import com.pulumi.alicloud.dns.kotlin.outputs.AccessStrategyFailoverAddrPool
import com.pulumi.alicloud.dns.kotlin.outputs.AccessStrategyLine
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.dns.kotlin.outputs.AccessStrategyDefaultAddrPool.Companion.toKotlin as accessStrategyDefaultAddrPoolToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.AccessStrategyFailoverAddrPool.Companion.toKotlin as accessStrategyFailoverAddrPoolToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.AccessStrategyLine.Companion.toKotlin as accessStrategyLineToKotlin

/**
 * Builder for [AccessStrategy].
 */
@PulumiTagMarker
public class AccessStrategyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessStrategyArgs = AccessStrategyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessStrategyArgsBuilder.() -> Unit) {
        val builder = AccessStrategyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessStrategy {
        val builtJavaResource = com.pulumi.alicloud.dns.AccessStrategy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessStrategy(builtJavaResource)
    }
}

/**
 * Provides a DNS Access Strategy resource.
 * For information about DNS Access Strategy and how to use it, see [What is Access Strategy](https://www.alibabacloud.com/help/doc-detail/189620.html).
 * > **NOTE:** Available since v1.152.0.
 * ## Import
 * DNS Access Strategy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/accessStrategy:AccessStrategy example <id>
 * ```
 */
public class AccessStrategy internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.AccessStrategy,
) : KotlinCustomResource(javaResource, AccessStrategyMapper) {
    /**
     * The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
     */
    public val accessMode: Output<String>
        get() = javaResource.accessMode().applyValue({ args0 -> args0 })

    /**
     * The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    public val defaultAddrPoolType: Output<String>
        get() = javaResource.defaultAddrPoolType().applyValue({ args0 -> args0 })

    /**
     * List of primary address pool collections. See `default_addr_pools` below for details.
     */
    public val defaultAddrPools: Output<List<AccessStrategyDefaultAddrPool>>
        get() = javaResource.defaultAddrPools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> accessStrategyDefaultAddrPoolToKotlin(args0) })
            })
        })

    /**
     * Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
     */
    public val defaultLatencyOptimization: Output<String>?
        get() = javaResource.defaultLatencyOptimization().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
     */
    public val defaultLbaStrategy: Output<String>?
        get() = javaResource.defaultLbaStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
     */
    public val defaultMaxReturnAddrNum: Output<Int>?
        get() = javaResource.defaultMaxReturnAddrNum().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum number of available addresses for the primary address pool set.
     */
    public val defaultMinAvailableAddrNum: Output<Int>
        get() = javaResource.defaultMinAvailableAddrNum().applyValue({ args0 -> args0 })

    /**
     * The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    public val failoverAddrPoolType: Output<String>?
        get() = javaResource.failoverAddrPoolType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    public val failoverAddrPools: Output<List<AccessStrategyFailoverAddrPool>>?
        get() = javaResource.failoverAddrPools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        accessStrategyFailoverAddrPoolToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
     */
    public val failoverLatencyOptimization: Output<String>?
        get() = javaResource.failoverLatencyOptimization().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
     */
    public val failoverLbaStrategy: Output<String>?
        get() = javaResource.failoverLbaStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of returned addresses in the standby address pool.
     */
    public val failoverMaxReturnAddrNum: Output<Int>?
        get() = javaResource.failoverMaxReturnAddrNum().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum number of available addresses in the standby address pool.
     */
    public val failoverMinAvailableAddrNum: Output<Int>?
        get() = javaResource.failoverMinAvailableAddrNum().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Id of the associated instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The lang.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    public val lines: Output<List<AccessStrategyLine>>?
        get() = javaResource.lines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> accessStrategyLineToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
     */
    public val strategyMode: Output<String>
        get() = javaResource.strategyMode().applyValue({ args0 -> args0 })

    /**
     * The name of the access policy.
     */
    public val strategyName: Output<String>
        get() = javaResource.strategyName().applyValue({ args0 -> args0 })
}

public object AccessStrategyMapper : ResourceMapper<AccessStrategy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.AccessStrategy::class == javaResource::class

    override fun map(javaResource: Resource): AccessStrategy = AccessStrategy(
        javaResource as
            com.pulumi.alicloud.dns.AccessStrategy,
    )
}

/**
 * @see [AccessStrategy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessStrategy].
 */
public suspend fun accessStrategy(
    name: String,
    block: suspend AccessStrategyResourceBuilder.() -> Unit,
): AccessStrategy {
    val builder = AccessStrategyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessStrategy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessStrategy(name: String): AccessStrategy {
    val builder = AccessStrategyResourceBuilder()
    builder.name(name)
    return builder.build()
}
