@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.AccessStrategyArgs.builder
import com.pulumi.alicloud.dns.kotlin.inputs.AccessStrategyDefaultAddrPoolArgs
import com.pulumi.alicloud.dns.kotlin.inputs.AccessStrategyDefaultAddrPoolArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.AccessStrategyFailoverAddrPoolArgs
import com.pulumi.alicloud.dns.kotlin.inputs.AccessStrategyFailoverAddrPoolArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.AccessStrategyLineArgs
import com.pulumi.alicloud.dns.kotlin.inputs.AccessStrategyLineArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DNS Access Strategy resource.
 * For information about DNS Access Strategy and how to use it, see [What is Access Strategy](https://www.alibabacloud.com/help/doc-detail/189620.html).
 * > **NOTE:** Available since v1.152.0.
 * ## Import
 * DNS Access Strategy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/accessStrategy:AccessStrategy example <id>
 * ```
 * @property accessMode The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
 * @property defaultAddrPoolType The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
 * @property defaultAddrPools List of primary address pool collections. See `default_addr_pools` below for details.
 * @property defaultLatencyOptimization Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
 * @property defaultLbaStrategy The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
 * @property defaultMaxReturnAddrNum The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
 * @property defaultMinAvailableAddrNum The minimum number of available addresses for the primary address pool set.
 * @property failoverAddrPoolType The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
 * @property failoverAddrPools List of backup address pool sets. See `failover_addr_pools` below for details.
 * @property failoverLatencyOptimization Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
 * @property failoverLbaStrategy The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
 * @property failoverMaxReturnAddrNum The maximum number of returned addresses in the standby address pool.
 * @property failoverMinAvailableAddrNum The minimum number of available addresses in the standby address pool.
 * @property instanceId The Id of the associated instance.
 * @property lang The lang.
 * @property lines The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
 * @property strategyMode The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
 * @property strategyName The name of the access policy.
 */
public data class AccessStrategyArgs(
    public val accessMode: Output<String>? = null,
    public val defaultAddrPoolType: Output<String>? = null,
    public val defaultAddrPools: Output<List<AccessStrategyDefaultAddrPoolArgs>>? = null,
    public val defaultLatencyOptimization: Output<String>? = null,
    public val defaultLbaStrategy: Output<String>? = null,
    public val defaultMaxReturnAddrNum: Output<Int>? = null,
    public val defaultMinAvailableAddrNum: Output<Int>? = null,
    public val failoverAddrPoolType: Output<String>? = null,
    public val failoverAddrPools: Output<List<AccessStrategyFailoverAddrPoolArgs>>? = null,
    public val failoverLatencyOptimization: Output<String>? = null,
    public val failoverLbaStrategy: Output<String>? = null,
    public val failoverMaxReturnAddrNum: Output<Int>? = null,
    public val failoverMinAvailableAddrNum: Output<Int>? = null,
    public val instanceId: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val lines: Output<List<AccessStrategyLineArgs>>? = null,
    public val strategyMode: Output<String>? = null,
    public val strategyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.AccessStrategyArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.AccessStrategyArgs =
        com.pulumi.alicloud.dns.AccessStrategyArgs.builder()
            .accessMode(accessMode?.applyValue({ args0 -> args0 }))
            .defaultAddrPoolType(defaultAddrPoolType?.applyValue({ args0 -> args0 }))
            .defaultAddrPools(
                defaultAddrPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultLatencyOptimization(defaultLatencyOptimization?.applyValue({ args0 -> args0 }))
            .defaultLbaStrategy(defaultLbaStrategy?.applyValue({ args0 -> args0 }))
            .defaultMaxReturnAddrNum(defaultMaxReturnAddrNum?.applyValue({ args0 -> args0 }))
            .defaultMinAvailableAddrNum(defaultMinAvailableAddrNum?.applyValue({ args0 -> args0 }))
            .failoverAddrPoolType(failoverAddrPoolType?.applyValue({ args0 -> args0 }))
            .failoverAddrPools(
                failoverAddrPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .failoverLatencyOptimization(failoverLatencyOptimization?.applyValue({ args0 -> args0 }))
            .failoverLbaStrategy(failoverLbaStrategy?.applyValue({ args0 -> args0 }))
            .failoverMaxReturnAddrNum(failoverMaxReturnAddrNum?.applyValue({ args0 -> args0 }))
            .failoverMinAvailableAddrNum(failoverMinAvailableAddrNum?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .lines(lines?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .strategyMode(strategyMode?.applyValue({ args0 -> args0 }))
            .strategyName(strategyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessStrategyArgs].
 */
@PulumiTagMarker
public class AccessStrategyArgsBuilder internal constructor() {
    private var accessMode: Output<String>? = null

    private var defaultAddrPoolType: Output<String>? = null

    private var defaultAddrPools: Output<List<AccessStrategyDefaultAddrPoolArgs>>? = null

    private var defaultLatencyOptimization: Output<String>? = null

    private var defaultLbaStrategy: Output<String>? = null

    private var defaultMaxReturnAddrNum: Output<Int>? = null

    private var defaultMinAvailableAddrNum: Output<Int>? = null

    private var failoverAddrPoolType: Output<String>? = null

    private var failoverAddrPools: Output<List<AccessStrategyFailoverAddrPoolArgs>>? = null

    private var failoverLatencyOptimization: Output<String>? = null

    private var failoverLbaStrategy: Output<String>? = null

    private var failoverMaxReturnAddrNum: Output<Int>? = null

    private var failoverMinAvailableAddrNum: Output<Int>? = null

    private var instanceId: Output<String>? = null

    private var lang: Output<String>? = null

    private var lines: Output<List<AccessStrategyLineArgs>>? = null

    private var strategyMode: Output<String>? = null

    private var strategyName: Output<String>? = null

    /**
     * @param value The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
     */
    @JvmName("bjicljnqpawntccc")
    public suspend fun accessMode(`value`: Output<String>) {
        this.accessMode = value
    }

    /**
     * @param value The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    @JvmName("liahhdalsmxuxjbm")
    public suspend fun defaultAddrPoolType(`value`: Output<String>) {
        this.defaultAddrPoolType = value
    }

    /**
     * @param value List of primary address pool collections. See `default_addr_pools` below for details.
     */
    @JvmName("wsvfesthptfepxkh")
    public suspend fun defaultAddrPools(`value`: Output<List<AccessStrategyDefaultAddrPoolArgs>>) {
        this.defaultAddrPools = value
    }

    @JvmName("dujdmkopqojruuiv")
    public suspend fun defaultAddrPools(vararg values: Output<AccessStrategyDefaultAddrPoolArgs>) {
        this.defaultAddrPools = Output.all(values.asList())
    }

    /**
     * @param values List of primary address pool collections. See `default_addr_pools` below for details.
     */
    @JvmName("ujjbppjowfqwukkw")
    public suspend fun defaultAddrPools(values: List<Output<AccessStrategyDefaultAddrPoolArgs>>) {
        this.defaultAddrPools = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
     */
    @JvmName("nrgvkiluhcabguxd")
    public suspend fun defaultLatencyOptimization(`value`: Output<String>) {
        this.defaultLatencyOptimization = value
    }

    /**
     * @param value The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("mvecnrmiygngddmt")
    public suspend fun defaultLbaStrategy(`value`: Output<String>) {
        this.defaultLbaStrategy = value
    }

    /**
     * @param value The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
     */
    @JvmName("cbnvjdltkajvrjmb")
    public suspend fun defaultMaxReturnAddrNum(`value`: Output<Int>) {
        this.defaultMaxReturnAddrNum = value
    }

    /**
     * @param value The minimum number of available addresses for the primary address pool set.
     */
    @JvmName("fowsgbuduaiwtmil")
    public suspend fun defaultMinAvailableAddrNum(`value`: Output<Int>) {
        this.defaultMinAvailableAddrNum = value
    }

    /**
     * @param value The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    @JvmName("cgcmkaxnchphuaoq")
    public suspend fun failoverAddrPoolType(`value`: Output<String>) {
        this.failoverAddrPoolType = value
    }

    /**
     * @param value List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    @JvmName("oxaxaogyjghjdyid")
    public suspend fun failoverAddrPools(`value`: Output<List<AccessStrategyFailoverAddrPoolArgs>>) {
        this.failoverAddrPools = value
    }

    @JvmName("fepgbekkqsfvjmyu")
    public suspend fun failoverAddrPools(vararg values: Output<AccessStrategyFailoverAddrPoolArgs>) {
        this.failoverAddrPools = Output.all(values.asList())
    }

    /**
     * @param values List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    @JvmName("vaufcvornikwdvpc")
    public suspend fun failoverAddrPools(values: List<Output<AccessStrategyFailoverAddrPoolArgs>>) {
        this.failoverAddrPools = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
     */
    @JvmName("xnevcecshkwmhxig")
    public suspend fun failoverLatencyOptimization(`value`: Output<String>) {
        this.failoverLatencyOptimization = value
    }

    /**
     * @param value The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
     */
    @JvmName("bkitwkgnnwemrcsk")
    public suspend fun failoverLbaStrategy(`value`: Output<String>) {
        this.failoverLbaStrategy = value
    }

    /**
     * @param value The maximum number of returned addresses in the standby address pool.
     */
    @JvmName("dpfasehwutvvwqej")
    public suspend fun failoverMaxReturnAddrNum(`value`: Output<Int>) {
        this.failoverMaxReturnAddrNum = value
    }

    /**
     * @param value The minimum number of available addresses in the standby address pool.
     */
    @JvmName("jernhxugaacruixg")
    public suspend fun failoverMinAvailableAddrNum(`value`: Output<Int>) {
        this.failoverMinAvailableAddrNum = value
    }

    /**
     * @param value The Id of the associated instance.
     */
    @JvmName("xumnwbdhraferabw")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The lang.
     */
    @JvmName("ropmfmsvuwhujros")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("cngpyvelaebbtqfj")
    public suspend fun lines(`value`: Output<List<AccessStrategyLineArgs>>) {
        this.lines = value
    }

    @JvmName("yakfgqmeenggkgud")
    public suspend fun lines(vararg values: Output<AccessStrategyLineArgs>) {
        this.lines = Output.all(values.asList())
    }

    /**
     * @param values The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("dmjxnxjsshwufkjk")
    public suspend fun lines(values: List<Output<AccessStrategyLineArgs>>) {
        this.lines = Output.all(values)
    }

    /**
     * @param value The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
     */
    @JvmName("nuvdscrtumhfdkfb")
    public suspend fun strategyMode(`value`: Output<String>) {
        this.strategyMode = value
    }

    /**
     * @param value The name of the access policy.
     */
    @JvmName("ahffbnxgaphpmnbd")
    public suspend fun strategyName(`value`: Output<String>) {
        this.strategyName = value
    }

    /**
     * @param value The primary/secondary switchover policy for address pool groups. Valid values: `AUTO`, `DEFAULT`, `FAILOVER`.
     */
    @JvmName("iqggrdxypsauudrj")
    public suspend fun accessMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessMode = mapped
    }

    /**
     * @param value The type of the primary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    @JvmName("jbmgvxcslodxcyeu")
    public suspend fun defaultAddrPoolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAddrPoolType = mapped
    }

    /**
     * @param value List of primary address pool collections. See `default_addr_pools` below for details.
     */
    @JvmName("ieptevorxyalymxv")
    public suspend fun defaultAddrPools(`value`: List<AccessStrategyDefaultAddrPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAddrPools = mapped
    }

    /**
     * @param argument List of primary address pool collections. See `default_addr_pools` below for details.
     */
    @JvmName("symqqualajcpatdb")
    public suspend fun defaultAddrPools(argument: List<suspend AccessStrategyDefaultAddrPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessStrategyDefaultAddrPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultAddrPools = mapped
    }

    /**
     * @param argument List of primary address pool collections. See `default_addr_pools` below for details.
     */
    @JvmName("pddisyhmacrhnein")
    public suspend fun defaultAddrPools(vararg argument: suspend AccessStrategyDefaultAddrPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AccessStrategyDefaultAddrPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultAddrPools = mapped
    }

    /**
     * @param argument List of primary address pool collections. See `default_addr_pools` below for details.
     */
    @JvmName("wxtkmahqscukxkxr")
    public suspend fun defaultAddrPools(argument: suspend AccessStrategyDefaultAddrPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessStrategyDefaultAddrPoolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.defaultAddrPools = mapped
    }

    /**
     * @param values List of primary address pool collections. See `default_addr_pools` below for details.
     */
    @JvmName("umtxkcphvbunibsy")
    public suspend fun defaultAddrPools(vararg values: AccessStrategyDefaultAddrPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAddrPools = mapped
    }

    /**
     * @param value Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values: `OPEN`, `CLOSE`.
     */
    @JvmName("ugwbouebffowrqmp")
    public suspend fun defaultLatencyOptimization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLatencyOptimization = mapped
    }

    /**
     * @param value The load balancing policy of the primary address pool group. Valid values: `ALL_RR`, `RATIO`. **NOTE:** The `default_lba_strategy` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("ruqgcaknyvieefli")
    public suspend fun defaultLbaStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLbaStrategy = mapped
    }

    /**
     * @param value The maximum number of addresses returned by the primary address pool set. **NOTE:** The `default_max_return_addr_num` is required under the condition that `strategy_mode` is `LATENCY`.
     */
    @JvmName("ckpnnsuiwldklvhd")
    public suspend fun defaultMaxReturnAddrNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMaxReturnAddrNum = mapped
    }

    /**
     * @param value The minimum number of available addresses for the primary address pool set.
     */
    @JvmName("jpsparuvdqovfbtb")
    public suspend fun defaultMinAvailableAddrNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMinAvailableAddrNum = mapped
    }

    /**
     * @param value The type of the secondary address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    @JvmName("htutpxpimsigfnvo")
    public suspend fun failoverAddrPoolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverAddrPoolType = mapped
    }

    /**
     * @param value List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    @JvmName("xitfoxgeqmiucjmd")
    public suspend fun failoverAddrPools(`value`: List<AccessStrategyFailoverAddrPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverAddrPools = mapped
    }

    /**
     * @param argument List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    @JvmName("hnrhmdvdollokkuh")
    public suspend fun failoverAddrPools(argument: List<suspend AccessStrategyFailoverAddrPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessStrategyFailoverAddrPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverAddrPools = mapped
    }

    /**
     * @param argument List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    @JvmName("nrohpxamcqdcvcrn")
    public suspend fun failoverAddrPools(vararg argument: suspend AccessStrategyFailoverAddrPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AccessStrategyFailoverAddrPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverAddrPools = mapped
    }

    /**
     * @param argument List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    @JvmName("ovbctktiguawgtav")
    public suspend fun failoverAddrPools(argument: suspend AccessStrategyFailoverAddrPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessStrategyFailoverAddrPoolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.failoverAddrPools = mapped
    }

    /**
     * @param values List of backup address pool sets. See `failover_addr_pools` below for details.
     */
    @JvmName("shjisuuyolanvmmr")
    public suspend fun failoverAddrPools(vararg values: AccessStrategyFailoverAddrPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverAddrPools = mapped
    }

    /**
     * @param value Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values: `OPEN`, `CLOSE`.
     */
    @JvmName("olnpswumjhunbplu")
    public suspend fun failoverLatencyOptimization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverLatencyOptimization = mapped
    }

    /**
     * @param value The load balancing policy of the secondary address pool group. Valid values: `ALL_RR`, `RATIO`.
     */
    @JvmName("sndtggovbfgxjjmk")
    public suspend fun failoverLbaStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverLbaStrategy = mapped
    }

    /**
     * @param value The maximum number of returned addresses in the standby address pool.
     */
    @JvmName("gxgofosocxqqdqph")
    public suspend fun failoverMaxReturnAddrNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverMaxReturnAddrNum = mapped
    }

    /**
     * @param value The minimum number of available addresses in the standby address pool.
     */
    @JvmName("bfnltxbengulsvxv")
    public suspend fun failoverMinAvailableAddrNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverMinAvailableAddrNum = mapped
    }

    /**
     * @param value The Id of the associated instance.
     */
    @JvmName("ryprmlovwjuvxiev")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("ttnhxrvrymmlakih")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("cyfowuxgusfmpabi")
    public suspend fun lines(`value`: List<AccessStrategyLineArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lines = mapped
    }

    /**
     * @param argument The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("hghauswiwtjepfst")
    public suspend fun lines(argument: List<suspend AccessStrategyLineArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessStrategyLineArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lines = mapped
    }

    /**
     * @param argument The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("nsfpiyooigavnoqp")
    public suspend fun lines(vararg argument: suspend AccessStrategyLineArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AccessStrategyLineArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lines = mapped
    }

    /**
     * @param argument The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("utdyqgvkejkuonsw")
    public suspend fun lines(argument: suspend AccessStrategyLineArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessStrategyLineArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lines = mapped
    }

    /**
     * @param values The source regions. See `lines` below for details. **NOTE:** The `lines` is required under the condition that `strategy_mode` is `GEO`.
     */
    @JvmName("tckbrvlpgmmkbalm")
    public suspend fun lines(vararg values: AccessStrategyLineArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lines = mapped
    }

    /**
     * @param value The type of the access policy. Valid values: `GEO` or `LATENCY`. `GEO`: based on geographic location. `LATENCY`: Based on delay.
     */
    @JvmName("ltijhegdvsuxqfuq")
    public suspend fun strategyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategyMode = mapped
    }

    /**
     * @param value The name of the access policy.
     */
    @JvmName("njngacqnvrlstwxo")
    public suspend fun strategyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategyName = mapped
    }

    internal fun build(): AccessStrategyArgs = AccessStrategyArgs(
        accessMode = accessMode,
        defaultAddrPoolType = defaultAddrPoolType,
        defaultAddrPools = defaultAddrPools,
        defaultLatencyOptimization = defaultLatencyOptimization,
        defaultLbaStrategy = defaultLbaStrategy,
        defaultMaxReturnAddrNum = defaultMaxReturnAddrNum,
        defaultMinAvailableAddrNum = defaultMinAvailableAddrNum,
        failoverAddrPoolType = failoverAddrPoolType,
        failoverAddrPools = failoverAddrPools,
        failoverLatencyOptimization = failoverLatencyOptimization,
        failoverLbaStrategy = failoverLbaStrategy,
        failoverMaxReturnAddrNum = failoverMaxReturnAddrNum,
        failoverMinAvailableAddrNum = failoverMinAvailableAddrNum,
        instanceId = instanceId,
        lang = lang,
        lines = lines,
        strategyMode = strategyMode,
        strategyName = strategyName,
    )
}
