@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.AddressPoolArgs.builder
import com.pulumi.alicloud.dns.kotlin.inputs.AddressPoolAddressArgs
import com.pulumi.alicloud.dns.kotlin.inputs.AddressPoolAddressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Alidns Address Pool resource.
 * For information about Alidns Address Pool and how to use it, see [What is Address Pool](https://www.alibabacloud.com/help/doc-detail/189621.html).
 * > **NOTE:** Available since v1.152.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const domainName = config.get("domainName") || "alicloud-provider.com";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultAlarmContactGroup = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: name});
 * const defaultGtmInstance = new alicloud.dns.GtmInstance("default", {
 *     instanceName: name,
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewalStatus: "ManualRenewal",
 *     packageEdition: "standard",
 *     healthCheckTaskCount: 100,
 *     smsNotificationCount: 1000,
 *     publicCnameMode: "SYSTEM_ASSIGN",
 *     ttl: 60,
 *     cnameType: "PUBLIC",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     alertGroups: [defaultAlarmContactGroup&#46;alarmContactGroupName],
 *     publicUserDomainName: domainName,
 *     alertConfigs: [{
 *         smsNotice: true,
 *         noticeType: "ADDR_ALERT",
 *         emailNotice: true,
 *         dingtalkNotice: true,
 *     }],
 * });
 * const defaultAddressPool = new alicloud.dns.AddressPool("default", {
 *     addressPoolName: name,
 *     instanceId: defaultGtmInstance.id,
 *     lbaStrategy: "RATIO",
 *     type: "IPV4",
 *     addresses: [{
 *         attributeInfo: `    {
 *       "lineCodeRectifyType": "RECTIFIED",
 *       "lineCodes": ["os_namerica_us"]
 *     }
 * `,
 *         remark: "address_remark",
 *         address: "1.1.1.1",
 *         mode: "SMART",
 *         lbaWeight: 1,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * domain_name = config.get("domainName")
 * if domain_name is None:
 *     domain_name = "alicloud-provider.com"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
 * default_gtm_instance = alicloud.dns.GtmInstance("default",
 *     instance_name=name,
 *     payment_type="Subscription",
 *     period=1,
 *     renewal_status="ManualRenewal",
 *     package_edition="standard",
 *     health_check_task_count=100,
 *     sms_notification_count=1000,
 *     public_cname_mode="SYSTEM_ASSIGN",
 *     ttl=60,
 *     cname_type="PUBLIC",
 *     resource_group_id=default.groups[0].id,
 *     alert_groups=[default_alarm_contact_group&#46;alarm_contact_group_name],
 *     public_user_domain_name=domain_name,
 *     alert_configs=[{
 *         "sms_notice": True,
 *         "notice_type": "ADDR_ALERT",
 *         "email_notice": True,
 *         "dingtalk_notice": True,
 *     }])
 * default_address_pool = alicloud.dns.AddressPool("default",
 *     address_pool_name=name,
 *     instance_id=default_gtm_instance.id,
 *     lba_strategy="RATIO",
 *     type="IPV4",
 *     addresses=[{
 *         "attribute_info": """    {
 *       "lineCodeRectifyType": "RECTIFIED",
 *       "lineCodes": ["os_namerica_us"]
 *     }
 * """,
 *         "remark": "address_remark",
 *         "address": "1.1.1.1",
 *         "mode": "SMART",
 *         "lba_weight": 1,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var domainName = config.Get("domainName") ?? "alicloud-provider.com";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultAlarmContactGroup = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *     });
 *     var defaultGtmInstance = new AliCloud.Dns.GtmInstance("default", new()
 *     {
 *         InstanceName = name,
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewalStatus = "ManualRenewal",
 *         PackageEdition = "standard",
 *         HealthCheckTaskCount = 100,
 *         SmsNotificationCount = 1000,
 *         PublicCnameMode = "SYSTEM_ASSIGN",
 *         Ttl = 60,
 *         CnameType = "PUBLIC",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         AlertGroups = new[]
 *         {
 *             defaultAlarmContactGroup.AlarmContactGroupName,
 *         },
 *         PublicUserDomainName = domainName,
 *         AlertConfigs = new[]
 *         {
 *             new AliCloud.Dns.Inputs.GtmInstanceAlertConfigArgs
 *             {
 *                 SmsNotice = true,
 *                 NoticeType = "ADDR_ALERT",
 *                 EmailNotice = true,
 *                 DingtalkNotice = true,
 *             },
 *         },
 *     });
 *     var defaultAddressPool = new AliCloud.Dns.AddressPool("default", new()
 *     {
 *         AddressPoolName = name,
 *         InstanceId = defaultGtmInstance.Id,
 *         LbaStrategy = "RATIO",
 *         Type = "IPV4",
 *         Addresses = new[]
 *         {
 *             new AliCloud.Dns.Inputs.AddressPoolAddressArgs
 *             {
 *                 AttributeInfo = @"    {
 *       ""lineCodeRectifyType"": ""RECTIFIED"",
 *       ""lineCodes"": [""os_namerica_us""]
 *     }
 * ",
 *                 Remark = "address_remark",
 *                 Address = "1.1.1.1",
 *                 Mode = "SMART",
 *                 LbaWeight = 1,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domainName := "alicloud-provider.com"
 * 		if param := cfg.Get("domainName"); param != "" {
 * 			domainName = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlarmContactGroup, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGtmInstance, err := dns.NewGtmInstance(ctx, "default", &dns.GtmInstanceArgs{
 * 			InstanceName:         pulumi.String(name),
 * 			PaymentType:          pulumi.String("Subscription"),
 * 			Period:               pulumi.Int(1),
 * 			RenewalStatus:        pulumi.String("ManualRenewal"),
 * 			PackageEdition:       pulumi.String("standard"),
 * 			HealthCheckTaskCount: pulumi.Int(100),
 * 			SmsNotificationCount: pulumi.Int(1000),
 * 			PublicCnameMode:      pulumi.String("SYSTEM_ASSIGN"),
 * 			Ttl:                  pulumi.Int(60),
 * 			CnameType:            pulumi.String("PUBLIC"),
 * 			ResourceGroupId:      pulumi.String(_default.Groups[0].Id),
 * 			AlertGroups: pulumi.StringArray{
 * 				defaultAlarmContactGroup.AlarmContactGroupName,
 * 			},
 * 			PublicUserDomainName: pulumi.String(domainName),
 * 			AlertConfigs: dns.GtmInstanceAlertConfigArray{
 * 				&dns.GtmInstanceAlertConfigArgs{
 * 					SmsNotice:      pulumi.Bool(true),
 * 					NoticeType:     pulumi.String("ADDR_ALERT"),
 * 					EmailNotice:    pulumi.Bool(true),
 * 					DingtalkNotice: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dns.NewAddressPool(ctx, "default", &dns.AddressPoolArgs{
 * 			AddressPoolName: pulumi.String(name),
 * 			InstanceId:      defaultGtmInstance.ID(),
 * 			LbaStrategy:     pulumi.String("RATIO"),
 * 			Type:            pulumi.String("IPV4"),
 * 			Addresses: dns.AddressPoolAddressArray{
 * 				&dns.AddressPoolAddressArgs{
 * 					AttributeInfo: pulumi.String("    {\n      \"lineCodeRectifyType\": \"RECTIFIED\",\n      \"lineCodes\": [\"os_namerica_us\"]\n    }\n"),
 * 					Remark:        pulumi.String("address_remark"),
 * 					Address:       pulumi.String("1.1.1.1"),
 * 					Mode:          pulumi.String("SMART"),
 * 					LbaWeight:     pulumi.Int(1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.dns.GtmInstance;
 * import com.pulumi.alicloud.dns.GtmInstanceArgs;
 * import com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs;
 * import com.pulumi.alicloud.dns.AddressPool;
 * import com.pulumi.alicloud.dns.AddressPoolArgs;
 * import com.pulumi.alicloud.dns.inputs.AddressPoolAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var domainName = config.get("domainName").orElse("alicloud-provider.com");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultAlarmContactGroup = new AlarmContactGroup("defaultAlarmContactGroup", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .build());
 *         var defaultGtmInstance = new GtmInstance("defaultGtmInstance", GtmInstanceArgs.builder()
 *             .instanceName(name)
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewalStatus("ManualRenewal")
 *             .packageEdition("standard")
 *             .healthCheckTaskCount(100)
 *             .smsNotificationCount(1000)
 *             .publicCnameMode("SYSTEM_ASSIGN")
 *             .ttl(60)
 *             .cnameType("PUBLIC")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .alertGroups(defaultAlarmContactGroup.alarmContactGroupName())
 *             .publicUserDomainName(domainName)
 *             .alertConfigs(GtmInstanceAlertConfigArgs.builder()
 *                 .smsNotice(true)
 *                 .noticeType("ADDR_ALERT")
 *                 .emailNotice(true)
 *                 .dingtalkNotice(true)
 *                 .build())
 *             .build());
 *         var defaultAddressPool = new AddressPool("defaultAddressPool", AddressPoolArgs.builder()
 *             .addressPoolName(name)
 *             .instanceId(defaultGtmInstance.id())
 *             .lbaStrategy("RATIO")
 *             .type("IPV4")
 *             .addresses(AddressPoolAddressArgs.builder()
 *                 .attributeInfo("""
 *     {
 *       "lineCodeRectifyType": "RECTIFIED",
 *       "lineCodes": ["os_namerica_us"]
 *     }
 *                 """)
 *                 .remark("address_remark")
 *                 .address("1.1.1.1")
 *                 .mode("SMART")
 *                 .lbaWeight(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 *   domainName:
 *     type: string
 *     default: alicloud-provider.com
 * resources:
 *   defaultAlarmContactGroup:
 *     type: alicloud:cms:AlarmContactGroup
 *     name: default
 *     properties:
 *       alarmContactGroupName: ${name}
 *   defaultGtmInstance:
 *     type: alicloud:dns:GtmInstance
 *     name: default
 *     properties:
 *       instanceName: ${name}
 *       paymentType: Subscription
 *       period: 1
 *       renewalStatus: ManualRenewal
 *       packageEdition: standard
 *       healthCheckTaskCount: 100
 *       smsNotificationCount: 1000
 *       publicCnameMode: SYSTEM_ASSIGN
 *       ttl: 60
 *       cnameType: PUBLIC
 *       resourceGroupId: ${default.groups[0].id}
 *       alertGroups:
 *         - ${defaultAlarmContactGroup.alarmContactGroupName}
 *       publicUserDomainName: ${domainName}
 *       alertConfigs:
 *         - smsNotice: true
 *           noticeType: ADDR_ALERT
 *           emailNotice: true
 *           dingtalkNotice: true
 *   defaultAddressPool:
 *     type: alicloud:dns:AddressPool
 *     name: default
 *     properties:
 *       addressPoolName: ${name}
 *       instanceId: ${defaultGtmInstance.id}
 *       lbaStrategy: RATIO
 *       type: IPV4
 *       addresses:
 *         - attributeInfo: |2
 *                 {
 *                   "lineCodeRectifyType": "RECTIFIED",
 *                   "lineCodes": ["os_namerica_us"]
 *                 }
 *           remark: address_remark
 *           address: 1.1.1.1
 *           mode: SMART
 *           lbaWeight: 1
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns Address Pool can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/addressPool:AddressPool example <id>
 * ```
 * @property addressPoolName The name of the address pool.
 * @property addresses The address lists of the Address Pool. See `address` below for details.
 * @property instanceId The ID of the instance.
 * @property lbaStrategy The load balancing policy of the address pool. Valid values:`ALL_RR` or `RATIO`. `ALL_RR`: returns all addresses. `RATIO`: returns addresses by weight.
 * @property type The type of the address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
 */
public data class AddressPoolArgs(
    public val addressPoolName: Output<String>? = null,
    public val addresses: Output<List<AddressPoolAddressArgs>>? = null,
    public val instanceId: Output<String>? = null,
    public val lbaStrategy: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.AddressPoolArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.AddressPoolArgs =
        com.pulumi.alicloud.dns.AddressPoolArgs.builder()
            .addressPoolName(addressPoolName?.applyValue({ args0 -> args0 }))
            .addresses(
                addresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .lbaStrategy(lbaStrategy?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddressPoolArgs].
 */
@PulumiTagMarker
public class AddressPoolArgsBuilder internal constructor() {
    private var addressPoolName: Output<String>? = null

    private var addresses: Output<List<AddressPoolAddressArgs>>? = null

    private var instanceId: Output<String>? = null

    private var lbaStrategy: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the address pool.
     */
    @JvmName("mlbgelpjvldaswyu")
    public suspend fun addressPoolName(`value`: Output<String>) {
        this.addressPoolName = value
    }

    /**
     * @param value The address lists of the Address Pool. See `address` below for details.
     */
    @JvmName("heyarnghnrbupqvu")
    public suspend fun addresses(`value`: Output<List<AddressPoolAddressArgs>>) {
        this.addresses = value
    }

    @JvmName("hrrpwcgrueaogbbx")
    public suspend fun addresses(vararg values: Output<AddressPoolAddressArgs>) {
        this.addresses = Output.all(values.asList())
    }

    /**
     * @param values The address lists of the Address Pool. See `address` below for details.
     */
    @JvmName("wqxjviaepixhhagm")
    public suspend fun addresses(values: List<Output<AddressPoolAddressArgs>>) {
        this.addresses = Output.all(values)
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("urrgicgkbwyuxnwv")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The load balancing policy of the address pool. Valid values:`ALL_RR` or `RATIO`. `ALL_RR`: returns all addresses. `RATIO`: returns addresses by weight.
     */
    @JvmName("njifjrkmhrcrgwug")
    public suspend fun lbaStrategy(`value`: Output<String>) {
        this.lbaStrategy = value
    }

    /**
     * @param value The type of the address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    @JvmName("gqruvcnsuurqkxii")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the address pool.
     */
    @JvmName("mcsynexvoisuybab")
    public suspend fun addressPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPoolName = mapped
    }

    /**
     * @param value The address lists of the Address Pool. See `address` below for details.
     */
    @JvmName("xoifpcodkvoixmeb")
    public suspend fun addresses(`value`: List<AddressPoolAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param argument The address lists of the Address Pool. See `address` below for details.
     */
    @JvmName("auwsscrjerrpujou")
    public suspend fun addresses(argument: List<suspend AddressPoolAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddressPoolAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addresses = mapped
    }

    /**
     * @param argument The address lists of the Address Pool. See `address` below for details.
     */
    @JvmName("qxgwhgscdujvrysu")
    public suspend fun addresses(vararg argument: suspend AddressPoolAddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AddressPoolAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addresses = mapped
    }

    /**
     * @param argument The address lists of the Address Pool. See `address` below for details.
     */
    @JvmName("ceifunnjerjffhfs")
    public suspend fun addresses(argument: suspend AddressPoolAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AddressPoolAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.addresses = mapped
    }

    /**
     * @param values The address lists of the Address Pool. See `address` below for details.
     */
    @JvmName("gmopwlhfimwtndob")
    public suspend fun addresses(vararg values: AddressPoolAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("vmeeqrdkdokisgwr")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The load balancing policy of the address pool. Valid values:`ALL_RR` or `RATIO`. `ALL_RR`: returns all addresses. `RATIO`: returns addresses by weight.
     */
    @JvmName("whhfcunpncedbjem")
    public suspend fun lbaStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbaStrategy = mapped
    }

    /**
     * @param value The type of the address pool. Valid values: `IPV4`, `IPV6`, `DOMAIN`.
     */
    @JvmName("pwstqqtkdymkxaav")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AddressPoolArgs = AddressPoolArgs(
        addressPoolName = addressPoolName,
        addresses = addresses,
        instanceId = instanceId,
        lbaStrategy = lbaStrategy,
        type = type,
    )
}
