@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [AlidnsDomain].
 */
@PulumiTagMarker
public class AlidnsDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlidnsDomainArgs = AlidnsDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlidnsDomainArgsBuilder.() -> Unit) {
        val builder = AlidnsDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlidnsDomain {
        val builtJavaResource = com.pulumi.alicloud.dns.AlidnsDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlidnsDomain(builtJavaResource)
    }
}

/**
 * Provides a Alidns domain resource.
 * > **NOTE:** The domain name which you want to add must be already registered and had not added by another account. Every domain name can only exist in a unique group.
 * > **NOTE:** Available since v1.95.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dns.DomainGroup("default", {domainGroupName: "tf-example"});
 * const defaultAlidnsDomain = new alicloud.dns.AlidnsDomain("default", {
 *     domainName: "starmove.com",
 *     groupId: _default.id,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dns.DomainGroup("default", domain_group_name="tf-example")
 * default_alidns_domain = alicloud.dns.AlidnsDomain("default",
 *     domain_name="starmove.com",
 *     group_id=default.id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dns.DomainGroup("default", new()
 *     {
 *         DomainGroupName = "tf-example",
 *     });
 *     var defaultAlidnsDomain = new AliCloud.Dns.AlidnsDomain("default", new()
 *     {
 *         DomainName = "starmove.com",
 *         GroupId = @default.Id,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewDomainGroup(ctx, "default", &dns.DomainGroupArgs{
 * 			DomainGroupName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dns.NewAlidnsDomain(ctx, "default", &dns.AlidnsDomainArgs{
 * 			DomainName: pulumi.String("starmove.com"),
 * 			GroupId:    _default.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DomainGroup;
 * import com.pulumi.alicloud.dns.DomainGroupArgs;
 * import com.pulumi.alicloud.dns.AlidnsDomain;
 * import com.pulumi.alicloud.dns.AlidnsDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DomainGroup("default", DomainGroupArgs.builder()
 *             .domainGroupName("tf-example")
 *             .build());
 *         var defaultAlidnsDomain = new AlidnsDomain("defaultAlidnsDomain", AlidnsDomainArgs.builder()
 *             .domainName("starmove.com")
 *             .groupId(default_.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dns:DomainGroup
 *     properties:
 *       domainGroupName: tf-example
 *   defaultAlidnsDomain:
 *     type: alicloud:dns:AlidnsDomain
 *     name: default
 *     properties:
 *       domainName: starmove.com
 *       groupId: ${default.id}
 *       tags:
 *         Created: TF
 *         For: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns domain can be imported using the id or domain name, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/alidnsDomain:AlidnsDomain example aliyun.com
 * ```
 */
public class AlidnsDomain internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.AlidnsDomain,
) : KotlinCustomResource(javaResource, AlidnsDomainMapper) {
    /**
     * A list of the dns server name.
     */
    public val dnsServers: Output<List<String>>
        get() = javaResource.dnsServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The domain ID.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Name of the domain. This name without suffix can have a string of 1 to 63 characters(domain name subject, excluding suffix), must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Id of the group in which the domain will add. If not supplied, then use default group.
     */
    public val groupId: Output<String>?
        get() = javaResource.groupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Domain name group name.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * User language.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Only return punycode codes for Chinese domain names.
     */
    public val punyCode: Output<String>
        get() = javaResource.punyCode().applyValue({ args0 -> args0 })

    /**
     * Remarks information for your domain name.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Id of resource group which the dns domain belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be [1, 20] characters in length. It can contain A-Z, a-z, numbers, underscores (_), and hyphens (-). It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be [1, 20] characters in length. It can contain A-Z, a-z, numbers, underscores (_), and hyphens (-). It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object AlidnsDomainMapper : ResourceMapper<AlidnsDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.AlidnsDomain::class == javaResource::class

    override fun map(javaResource: Resource): AlidnsDomain = AlidnsDomain(
        javaResource as
            com.pulumi.alicloud.dns.AlidnsDomain,
    )
}

/**
 * @see [AlidnsDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlidnsDomain].
 */
public suspend fun alidnsDomain(
    name: String,
    block: suspend AlidnsDomainResourceBuilder.() -> Unit,
): AlidnsDomain {
    val builder = AlidnsDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlidnsDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alidnsDomain(name: String): AlidnsDomain {
    val builder = AlidnsDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
