@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlidnsInstance].
 */
@PulumiTagMarker
public class AlidnsInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlidnsInstanceArgs = AlidnsInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlidnsInstanceArgsBuilder.() -> Unit) {
        val builder = AlidnsInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlidnsInstance {
        val builtJavaResource = com.pulumi.alicloud.dns.AlidnsInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlidnsInstance(builtJavaResource)
    }
}

/**
 * Create an Alidns Instance resource.
 * > **NOTE:** Available since v1.95.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.dns.AlidnsInstance("example", {
 *     dnsSecurity: "no",
 *     domainNumbers: "2",
 *     period: 1,
 *     renewPeriod: 1,
 *     renewalStatus: "ManualRenewal",
 *     versionCode: "version_personal",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.dns.AlidnsInstance("example",
 *     dns_security="no",
 *     domain_numbers="2",
 *     period=1,
 *     renew_period=1,
 *     renewal_status="ManualRenewal",
 *     version_code="version_personal")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Dns.AlidnsInstance("example", new()
 *     {
 *         DnsSecurity = "no",
 *         DomainNumbers = "2",
 *         Period = 1,
 *         RenewPeriod = 1,
 *         RenewalStatus = "ManualRenewal",
 *         VersionCode = "version_personal",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewAlidnsInstance(ctx, "example", &dns.AlidnsInstanceArgs{
 * 			DnsSecurity:   pulumi.String("no"),
 * 			DomainNumbers: pulumi.String("2"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(1),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			VersionCode:   pulumi.String("version_personal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.AlidnsInstance;
 * import com.pulumi.alicloud.dns.AlidnsInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AlidnsInstance("example", AlidnsInstanceArgs.builder()
 *             .dnsSecurity("no")
 *             .domainNumbers("2")
 *             .period(1)
 *             .renewPeriod(1)
 *             .renewalStatus("ManualRenewal")
 *             .versionCode("version_personal")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:dns:AlidnsInstance
 *     properties:
 *       dnsSecurity: no
 *       domainNumbers: '2'
 *       period: 1
 *       renewPeriod: 1
 *       renewalStatus: ManualRenewal
 *       versionCode: version_personal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS instance be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/alidnsInstance:AlidnsInstance example dns-cn-v0h1ldjhfff
 * ```
 */
public class AlidnsInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.AlidnsInstance,
) : KotlinCustomResource(javaResource, AlidnsInstanceMapper) {
    /**
     * Alidns security level. Valid values: `no`, `basic`, `advanced`.
     */
    public val dnsSecurity: Output<String>
        get() = javaResource.dnsSecurity().applyValue({ args0 -> args0 })

    /**
     * Number of domain names bound.
     */
    public val domainNumbers: Output<String>
        get() = javaResource.domainNumbers().applyValue({ args0 -> args0 })

    /**
     * The billing method of the Alidns instance. Valid values: `Subscription`. Default to `Subscription`.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Automatic renewal period, the unit is month. When setting RenewalStatus to AutoRenewal, it must be set.
     */
    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, default to `ManualRenewal`.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * Paid package version. Valid values: `version_personal`, `version_enterprise_basic`, `version_enterprise_advanced`.
     */
    public val versionCode: Output<String>
        get() = javaResource.versionCode().applyValue({ args0 -> args0 })

    /**
     * Paid package version name.
     */
    public val versionName: Output<String>
        get() = javaResource.versionName().applyValue({ args0 -> args0 })
}

public object AlidnsInstanceMapper : ResourceMapper<AlidnsInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.AlidnsInstance::class == javaResource::class

    override fun map(javaResource: Resource): AlidnsInstance = AlidnsInstance(
        javaResource as
            com.pulumi.alicloud.dns.AlidnsInstance,
    )
}

/**
 * @see [AlidnsInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlidnsInstance].
 */
public suspend fun alidnsInstance(
    name: String,
    block: suspend AlidnsInstanceResourceBuilder.() -> Unit,
): AlidnsInstance {
    val builder = AlidnsInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlidnsInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alidnsInstance(name: String): AlidnsInstance {
    val builder = AlidnsInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
