@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.AlidnsInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Create an Alidns Instance resource.
 * > **NOTE:** Available since v1.95.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.dns.AlidnsInstance("example", {
 *     dnsSecurity: "no",
 *     domainNumbers: "2",
 *     period: 1,
 *     renewPeriod: 1,
 *     renewalStatus: "ManualRenewal",
 *     versionCode: "version_personal",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.dns.AlidnsInstance("example",
 *     dns_security="no",
 *     domain_numbers="2",
 *     period=1,
 *     renew_period=1,
 *     renewal_status="ManualRenewal",
 *     version_code="version_personal")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Dns.AlidnsInstance("example", new()
 *     {
 *         DnsSecurity = "no",
 *         DomainNumbers = "2",
 *         Period = 1,
 *         RenewPeriod = 1,
 *         RenewalStatus = "ManualRenewal",
 *         VersionCode = "version_personal",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewAlidnsInstance(ctx, "example", &dns.AlidnsInstanceArgs{
 * 			DnsSecurity:   pulumi.String("no"),
 * 			DomainNumbers: pulumi.String("2"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(1),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			VersionCode:   pulumi.String("version_personal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.AlidnsInstance;
 * import com.pulumi.alicloud.dns.AlidnsInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AlidnsInstance("example", AlidnsInstanceArgs.builder()
 *             .dnsSecurity("no")
 *             .domainNumbers("2")
 *             .period(1)
 *             .renewPeriod(1)
 *             .renewalStatus("ManualRenewal")
 *             .versionCode("version_personal")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:dns:AlidnsInstance
 *     properties:
 *       dnsSecurity: no
 *       domainNumbers: '2'
 *       period: 1
 *       renewPeriod: 1
 *       renewalStatus: ManualRenewal
 *       versionCode: version_personal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS instance be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/alidnsInstance:AlidnsInstance example dns-cn-v0h1ldjhfff
 * ```
 * @property dnsSecurity Alidns security level. Valid values: `no`, `basic`, `advanced`.
 * @property domainNumbers Number of domain names bound.
 * @property paymentType The billing method of the Alidns instance. Valid values: `Subscription`. Default to `Subscription`.
 * @property period Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
 * @property renewPeriod Automatic renewal period, the unit is month. When setting RenewalStatus to AutoRenewal, it must be set.
 * @property renewalStatus Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, default to `ManualRenewal`.
 * @property versionCode Paid package version. Valid values: `version_personal`, `version_enterprise_basic`, `version_enterprise_advanced`.
 */
public data class AlidnsInstanceArgs(
    public val dnsSecurity: Output<String>? = null,
    public val domainNumbers: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val versionCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.AlidnsInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.AlidnsInstanceArgs =
        com.pulumi.alicloud.dns.AlidnsInstanceArgs.builder()
            .dnsSecurity(dnsSecurity?.applyValue({ args0 -> args0 }))
            .domainNumbers(domainNumbers?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .versionCode(versionCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlidnsInstanceArgs].
 */
@PulumiTagMarker
public class AlidnsInstanceArgsBuilder internal constructor() {
    private var dnsSecurity: Output<String>? = null

    private var domainNumbers: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var versionCode: Output<String>? = null

    /**
     * @param value Alidns security level. Valid values: `no`, `basic`, `advanced`.
     */
    @JvmName("wfmiodlswyhwpiol")
    public suspend fun dnsSecurity(`value`: Output<String>) {
        this.dnsSecurity = value
    }

    /**
     * @param value Number of domain names bound.
     */
    @JvmName("fbkmgbanucsdaaff")
    public suspend fun domainNumbers(`value`: Output<String>) {
        this.domainNumbers = value
    }

    /**
     * @param value The billing method of the Alidns instance. Valid values: `Subscription`. Default to `Subscription`.
     */
    @JvmName("papfsxbwstolbmeh")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    @JvmName("krykvsncxiiugjuv")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Automatic renewal period, the unit is month. When setting RenewalStatus to AutoRenewal, it must be set.
     */
    @JvmName("acqbrtbcbbpvowal")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, default to `ManualRenewal`.
     */
    @JvmName("lempitymboukrsak")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value Paid package version. Valid values: `version_personal`, `version_enterprise_basic`, `version_enterprise_advanced`.
     */
    @JvmName("wftpxjafwpvulayo")
    public suspend fun versionCode(`value`: Output<String>) {
        this.versionCode = value
    }

    /**
     * @param value Alidns security level. Valid values: `no`, `basic`, `advanced`.
     */
    @JvmName("wyejujiurekwaqri")
    public suspend fun dnsSecurity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSecurity = mapped
    }

    /**
     * @param value Number of domain names bound.
     */
    @JvmName("tbfwuutuowqveymi")
    public suspend fun domainNumbers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNumbers = mapped
    }

    /**
     * @param value The billing method of the Alidns instance. Valid values: `Subscription`. Default to `Subscription`.
     */
    @JvmName("qsvioabkosvbeveo")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    @JvmName("wpkdlmgdoovckgmp")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Automatic renewal period, the unit is month. When setting RenewalStatus to AutoRenewal, it must be set.
     */
    @JvmName("gqieujmltqwtgsad")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, default to `ManualRenewal`.
     */
    @JvmName("bavcdkdxdwhkfyae")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value Paid package version. Valid values: `version_personal`, `version_enterprise_basic`, `version_enterprise_advanced`.
     */
    @JvmName("iohtqhjxthdfhibw")
    public suspend fun versionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionCode = mapped
    }

    internal fun build(): AlidnsInstanceArgs = AlidnsInstanceArgs(
        dnsSecurity = dnsSecurity,
        domainNumbers = domainNumbers,
        paymentType = paymentType,
        period = period,
        renewPeriod = renewPeriod,
        renewalStatus = renewalStatus,
        versionCode = versionCode,
    )
}
