@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlidnsRecord].
 */
@PulumiTagMarker
public class AlidnsRecordResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlidnsRecordArgs = AlidnsRecordArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlidnsRecordArgsBuilder.() -> Unit) {
        val builder = AlidnsRecordArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlidnsRecord {
        val builtJavaResource = com.pulumi.alicloud.dns.AlidnsRecord(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlidnsRecord(builtJavaResource)
    }
}

/**
 * Provides a Alidns Record resource. For information about Alidns Domain Record and how to use it, see [What is Resource Alidns Record](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/adding-a-dns-record).
 * > **NOTE:** Available since v1.85.0.
 * > **NOTE:** When the site is an international site, the `type` neither supports `REDIRECT_URL` nor `REDIRECT_URL`
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dns.DomainGroup("default", {domainGroupName: "tf-example"});
 * const defaultAlidnsDomain = new alicloud.dns.AlidnsDomain("default", {
 *     domainName: "starmove.com",
 *     groupId: _default.id,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const record = new alicloud.dns.AlidnsRecord("record", {
 *     domainName: defaultAlidnsDomain.domainName,
 *     rr: "alimail",
 *     type: "CNAME",
 *     value: "mail.mxhichin.com",
 *     remark: "tf-example",
 *     status: "ENABLE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dns.DomainGroup("default", domain_group_name="tf-example")
 * default_alidns_domain = alicloud.dns.AlidnsDomain("default",
 *     domain_name="starmove.com",
 *     group_id=default.id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * record = alicloud.dns.AlidnsRecord("record",
 *     domain_name=default_alidns_domain.domain_name,
 *     rr="alimail",
 *     type="CNAME",
 *     value="mail.mxhichin.com",
 *     remark="tf-example",
 *     status="ENABLE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dns.DomainGroup("default", new()
 *     {
 *         DomainGroupName = "tf-example",
 *     });
 *     var defaultAlidnsDomain = new AliCloud.Dns.AlidnsDomain("default", new()
 *     {
 *         DomainName = "starmove.com",
 *         GroupId = @default.Id,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var record = new AliCloud.Dns.AlidnsRecord("record", new()
 *     {
 *         DomainName = defaultAlidnsDomain.DomainName,
 *         Rr = "alimail",
 *         Type = "CNAME",
 *         Value = "mail.mxhichin.com",
 *         Remark = "tf-example",
 *         Status = "ENABLE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewDomainGroup(ctx, "default", &dns.DomainGroupArgs{
 * 			DomainGroupName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlidnsDomain, err := dns.NewAlidnsDomain(ctx, "default", &dns.AlidnsDomainArgs{
 * 			DomainName: pulumi.String("starmove.com"),
 * 			GroupId:    _default.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dns.NewAlidnsRecord(ctx, "record", &dns.AlidnsRecordArgs{
 * 			DomainName: defaultAlidnsDomain.DomainName,
 * 			Rr:         pulumi.String("alimail"),
 * 			Type:       pulumi.String("CNAME"),
 * 			Value:      pulumi.String("mail.mxhichin.com"),
 * 			Remark:     pulumi.String("tf-example"),
 * 			Status:     pulumi.String("ENABLE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DomainGroup;
 * import com.pulumi.alicloud.dns.DomainGroupArgs;
 * import com.pulumi.alicloud.dns.AlidnsDomain;
 * import com.pulumi.alicloud.dns.AlidnsDomainArgs;
 * import com.pulumi.alicloud.dns.AlidnsRecord;
 * import com.pulumi.alicloud.dns.AlidnsRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DomainGroup("default", DomainGroupArgs.builder()
 *             .domainGroupName("tf-example")
 *             .build());
 *         var defaultAlidnsDomain = new AlidnsDomain("defaultAlidnsDomain", AlidnsDomainArgs.builder()
 *             .domainName("starmove.com")
 *             .groupId(default_.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var record = new AlidnsRecord("record", AlidnsRecordArgs.builder()
 *             .domainName(defaultAlidnsDomain.domainName())
 *             .rr("alimail")
 *             .type("CNAME")
 *             .value("mail.mxhichin.com")
 *             .remark("tf-example")
 *             .status("ENABLE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dns:DomainGroup
 *     properties:
 *       domainGroupName: tf-example
 *   defaultAlidnsDomain:
 *     type: alicloud:dns:AlidnsDomain
 *     name: default
 *     properties:
 *       domainName: starmove.com
 *       groupId: ${default.id}
 *       tags:
 *         Created: TF
 *         For: example
 *   record:
 *     type: alicloud:dns:AlidnsRecord
 *     properties:
 *       domainName: ${defaultAlidnsDomain.domainName}
 *       rr: alimail
 *       type: CNAME
 *       value: mail.mxhichin.com
 *       remark: tf-example
 *       status: ENABLE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns Domain Record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/alidnsRecord:AlidnsRecord example abc123456
 * ```
 */
public class AlidnsRecord internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.AlidnsRecord,
) : KotlinCustomResource(javaResource, AlidnsRecordMapper) {
    /**
     * Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * User language.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resolution line of domain record. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/adding-a-dns-record) or using alicloud.dns.getResolutionLines in data source to get the value.
     */
    public val line: Output<String>?
        get() = javaResource.line().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The priority of domain record. Valid values: `[1-10]`. When the `type` is `MX`, this parameter is required.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The remark of the domain record.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Host record for the domain record. This host_record can have at most 253 characters, and each part split with `.` can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as `-`, `.`, `*`, `@`, and must not begin or end with `-`.
     */
    public val rr: Output<String>
        get() = javaResource.rr().applyValue({ args0 -> args0 })

    /**
     * The status of the domain record. Valid values: `ENABLE`,`DISABLE`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
     */
    public val ttl: Output<Int>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of domain record. Valid values: `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The IP address of the client.
     */
    public val userClientIp: Output<String>?
        get() = javaResource.userClientIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object AlidnsRecordMapper : ResourceMapper<AlidnsRecord> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.AlidnsRecord::class == javaResource::class

    override fun map(javaResource: Resource): AlidnsRecord = AlidnsRecord(
        javaResource as
            com.pulumi.alicloud.dns.AlidnsRecord,
    )
}

/**
 * @see [AlidnsRecord].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlidnsRecord].
 */
public suspend fun alidnsRecord(
    name: String,
    block: suspend AlidnsRecordResourceBuilder.() -> Unit,
): AlidnsRecord {
    val builder = AlidnsRecordResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlidnsRecord].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alidnsRecord(name: String): AlidnsRecord {
    val builder = AlidnsRecordResourceBuilder()
    builder.name(name)
    return builder.build()
}
