@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.AlidnsRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Alidns Record resource. For information about Alidns Domain Record and how to use it, see [What is Resource Alidns Record](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/adding-a-dns-record).
 * > **NOTE:** Available since v1.85.0.
 * > **NOTE:** When the site is an international site, the `type` neither supports `REDIRECT_URL` nor `REDIRECT_URL`
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dns.DomainGroup("default", {domainGroupName: "tf-example"});
 * const defaultAlidnsDomain = new alicloud.dns.AlidnsDomain("default", {
 *     domainName: "starmove.com",
 *     groupId: _default.id,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const record = new alicloud.dns.AlidnsRecord("record", {
 *     domainName: defaultAlidnsDomain.domainName,
 *     rr: "alimail",
 *     type: "CNAME",
 *     value: "mail.mxhichin.com",
 *     remark: "tf-example",
 *     status: "ENABLE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dns.DomainGroup("default", domain_group_name="tf-example")
 * default_alidns_domain = alicloud.dns.AlidnsDomain("default",
 *     domain_name="starmove.com",
 *     group_id=default.id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * record = alicloud.dns.AlidnsRecord("record",
 *     domain_name=default_alidns_domain.domain_name,
 *     rr="alimail",
 *     type="CNAME",
 *     value="mail.mxhichin.com",
 *     remark="tf-example",
 *     status="ENABLE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dns.DomainGroup("default", new()
 *     {
 *         DomainGroupName = "tf-example",
 *     });
 *     var defaultAlidnsDomain = new AliCloud.Dns.AlidnsDomain("default", new()
 *     {
 *         DomainName = "starmove.com",
 *         GroupId = @default.Id,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var record = new AliCloud.Dns.AlidnsRecord("record", new()
 *     {
 *         DomainName = defaultAlidnsDomain.DomainName,
 *         Rr = "alimail",
 *         Type = "CNAME",
 *         Value = "mail.mxhichin.com",
 *         Remark = "tf-example",
 *         Status = "ENABLE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewDomainGroup(ctx, "default", &dns.DomainGroupArgs{
 * 			DomainGroupName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlidnsDomain, err := dns.NewAlidnsDomain(ctx, "default", &dns.AlidnsDomainArgs{
 * 			DomainName: pulumi.String("starmove.com"),
 * 			GroupId:    _default.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dns.NewAlidnsRecord(ctx, "record", &dns.AlidnsRecordArgs{
 * 			DomainName: defaultAlidnsDomain.DomainName,
 * 			Rr:         pulumi.String("alimail"),
 * 			Type:       pulumi.String("CNAME"),
 * 			Value:      pulumi.String("mail.mxhichin.com"),
 * 			Remark:     pulumi.String("tf-example"),
 * 			Status:     pulumi.String("ENABLE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DomainGroup;
 * import com.pulumi.alicloud.dns.DomainGroupArgs;
 * import com.pulumi.alicloud.dns.AlidnsDomain;
 * import com.pulumi.alicloud.dns.AlidnsDomainArgs;
 * import com.pulumi.alicloud.dns.AlidnsRecord;
 * import com.pulumi.alicloud.dns.AlidnsRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DomainGroup("default", DomainGroupArgs.builder()
 *             .domainGroupName("tf-example")
 *             .build());
 *         var defaultAlidnsDomain = new AlidnsDomain("defaultAlidnsDomain", AlidnsDomainArgs.builder()
 *             .domainName("starmove.com")
 *             .groupId(default_.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var record = new AlidnsRecord("record", AlidnsRecordArgs.builder()
 *             .domainName(defaultAlidnsDomain.domainName())
 *             .rr("alimail")
 *             .type("CNAME")
 *             .value("mail.mxhichin.com")
 *             .remark("tf-example")
 *             .status("ENABLE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dns:DomainGroup
 *     properties:
 *       domainGroupName: tf-example
 *   defaultAlidnsDomain:
 *     type: alicloud:dns:AlidnsDomain
 *     name: default
 *     properties:
 *       domainName: starmove.com
 *       groupId: ${default.id}
 *       tags:
 *         Created: TF
 *         For: example
 *   record:
 *     type: alicloud:dns:AlidnsRecord
 *     properties:
 *       domainName: ${defaultAlidnsDomain.domainName}
 *       rr: alimail
 *       type: CNAME
 *       value: mail.mxhichin.com
 *       remark: tf-example
 *       status: ENABLE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns Domain Record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/alidnsRecord:AlidnsRecord example abc123456
 * ```
 * @property domainName Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
 * @property lang User language.
 * @property line The resolution line of domain record. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/adding-a-dns-record) or using alicloud.dns.getResolutionLines in data source to get the value.
 * @property priority The priority of domain record. Valid values: `[1-10]`. When the `type` is `MX`, this parameter is required.
 * @property remark The remark of the domain record.
 * @property rr Host record for the domain record. This host_record can have at most 253 characters, and each part split with `.` can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as `-`, `.`, `*`, `@`, and must not begin or end with `-`.
 * @property status The status of the domain record. Valid values: `ENABLE`,`DISABLE`.
 * @property ttl The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
 * @property type The type of domain record. Valid values: `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
 * @property userClientIp The IP address of the client.
 * @property value The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
 */
public data class AlidnsRecordArgs(
    public val domainName: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val line: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val remark: Output<String>? = null,
    public val rr: Output<String>? = null,
    public val status: Output<String>? = null,
    public val ttl: Output<Int>? = null,
    public val type: Output<String>? = null,
    public val userClientIp: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.AlidnsRecordArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.AlidnsRecordArgs =
        com.pulumi.alicloud.dns.AlidnsRecordArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .line(line?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .rr(rr?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .userClientIp(userClientIp?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlidnsRecordArgs].
 */
@PulumiTagMarker
public class AlidnsRecordArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var lang: Output<String>? = null

    private var line: Output<String>? = null

    private var priority: Output<Int>? = null

    private var remark: Output<String>? = null

    private var rr: Output<String>? = null

    private var status: Output<String>? = null

    private var ttl: Output<Int>? = null

    private var type: Output<String>? = null

    private var userClientIp: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("eistjbcximctvakm")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value User language.
     */
    @JvmName("atswqgqywdfbxajn")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The resolution line of domain record. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/adding-a-dns-record) or using alicloud.dns.getResolutionLines in data source to get the value.
     */
    @JvmName("pixvnxlhclsomiov")
    public suspend fun line(`value`: Output<String>) {
        this.line = value
    }

    /**
     * @param value The priority of domain record. Valid values: `[1-10]`. When the `type` is `MX`, this parameter is required.
     */
    @JvmName("lsrgxnnncfytvihm")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The remark of the domain record.
     */
    @JvmName("qhxsdbfhuhphwcec")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value Host record for the domain record. This host_record can have at most 253 characters, and each part split with `.` can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as `-`, `.`, `*`, `@`, and must not begin or end with `-`.
     */
    @JvmName("allqbrhiwejeqiqw")
    public suspend fun rr(`value`: Output<String>) {
        this.rr = value
    }

    /**
     * @param value The status of the domain record. Valid values: `ENABLE`,`DISABLE`.
     */
    @JvmName("wjsjtrjowrcrubrd")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
     */
    @JvmName("wchiepniapdgyqst")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The type of domain record. Valid values: `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
     */
    @JvmName("nfigqitcknnxevii")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The IP address of the client.
     */
    @JvmName("jmlbxculypgxmeqp")
    public suspend fun userClientIp(`value`: Output<String>) {
        this.userClientIp = value
    }

    /**
     * @param value The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
     */
    @JvmName("yhicdemaeudxdoli")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("fkwbffsupdqjwmoa")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("nsffqkjabbowjdme")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The resolution line of domain record. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/adding-a-dns-record) or using alicloud.dns.getResolutionLines in data source to get the value.
     */
    @JvmName("ekircbxobmaxraty")
    public suspend fun line(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.line = mapped
    }

    /**
     * @param value The priority of domain record. Valid values: `[1-10]`. When the `type` is `MX`, this parameter is required.
     */
    @JvmName("sykmlvrnsfjwthbs")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The remark of the domain record.
     */
    @JvmName("chdashhxakmywmku")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value Host record for the domain record. This host_record can have at most 253 characters, and each part split with `.` can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as `-`, `.`, `*`, `@`, and must not begin or end with `-`.
     */
    @JvmName("pmlakdntmripmslo")
    public suspend fun rr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rr = mapped
    }

    /**
     * @param value The status of the domain record. Valid values: `ENABLE`,`DISABLE`.
     */
    @JvmName("jhoosecqxojwncba")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
     */
    @JvmName("fbbjavepfcgthodr")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The type of domain record. Valid values: `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
     */
    @JvmName("albfjyikkjfyqmeo")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The IP address of the client.
     */
    @JvmName("gfecudnsarffdndt")
    public suspend fun userClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userClientIp = mapped
    }

    /**
     * @param value The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
     */
    @JvmName("wrfodjtaxinlyrtp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AlidnsRecordArgs = AlidnsRecordArgs(
        domainName = domainName,
        lang = lang,
        line = line,
        priority = priority,
        remark = remark,
        rr = rr,
        status = status,
        ttl = ttl,
        type = type,
        userClientIp = userClientIp,
        `value` = `value`,
    )
}
