@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.kotlin.outputs.CustomLineIpSegmentList
import com.pulumi.alicloud.dns.kotlin.outputs.CustomLineIpSegmentList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [CustomLine].
 */
@PulumiTagMarker
public class CustomLineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomLineArgs = CustomLineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomLineArgsBuilder.() -> Unit) {
        val builder = CustomLineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomLine {
        val builtJavaResource = com.pulumi.alicloud.dns.CustomLine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomLine(builtJavaResource)
    }
}

/**
 * Provides a Alidns Custom Line resource.
 * For information about Alidns Custom Line and how to use it, see [What is Custom Line](https://www.alibabacloud.com/help/en/doc-detail/145059.html).
 * > **NOTE:** Available since v1.151.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dns.CustomLine("default", {
 *     customLineName: "tf-example",
 *     domainName: "alicloud-provider.com",
 *     ipSegmentLists: [{
 *         startIp: "192.0.2.123",
 *         endIp: "192.0.2.125",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dns.CustomLine("default",
 *     custom_line_name="tf-example",
 *     domain_name="alicloud-provider.com",
 *     ip_segment_lists=[{
 *         "start_ip": "192.0.2.123",
 *         "end_ip": "192.0.2.125",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dns.CustomLine("default", new()
 *     {
 *         CustomLineName = "tf-example",
 *         DomainName = "alicloud-provider.com",
 *         IpSegmentLists = new[]
 *         {
 *             new AliCloud.Dns.Inputs.CustomLineIpSegmentListArgs
 *             {
 *                 StartIp = "192.0.2.123",
 *                 EndIp = "192.0.2.125",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewCustomLine(ctx, "default", &dns.CustomLineArgs{
 * 			CustomLineName: pulumi.String("tf-example"),
 * 			DomainName:     pulumi.String("alicloud-provider.com"),
 * 			IpSegmentLists: dns.CustomLineIpSegmentListArray{
 * 				&dns.CustomLineIpSegmentListArgs{
 * 					StartIp: pulumi.String("192.0.2.123"),
 * 					EndIp:   pulumi.String("192.0.2.125"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.CustomLine;
 * import com.pulumi.alicloud.dns.CustomLineArgs;
 * import com.pulumi.alicloud.dns.inputs.CustomLineIpSegmentListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new CustomLine("default", CustomLineArgs.builder()
 *             .customLineName("tf-example")
 *             .domainName("alicloud-provider.com")
 *             .ipSegmentLists(CustomLineIpSegmentListArgs.builder()
 *                 .startIp("192.0.2.123")
 *                 .endIp("192.0.2.125")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dns:CustomLine
 *     properties:
 *       customLineName: tf-example
 *       domainName: alicloud-provider.com
 *       ipSegmentLists:
 *         - startIp: 192.0.2.123
 *           endIp: 192.0.2.125
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns Custom Line can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/customLine:CustomLine example <id>
 * ```
 */
public class CustomLine internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.CustomLine,
) : KotlinCustomResource(javaResource, CustomLineMapper) {
    /**
     * The name of the Custom Line.
     */
    public val customLineName: Output<String>
        get() = javaResource.customLineName().applyValue({ args0 -> args0 })

    /**
     * The Domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The IP segment list. See `ip_segment_list` below for details.
     */
    public val ipSegmentLists: Output<List<CustomLineIpSegmentList>>
        get() = javaResource.ipSegmentLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The lang.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object CustomLineMapper : ResourceMapper<CustomLine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.CustomLine::class == javaResource::class

    override fun map(javaResource: Resource): CustomLine = CustomLine(
        javaResource as
            com.pulumi.alicloud.dns.CustomLine,
    )
}

/**
 * @see [CustomLine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomLine].
 */
public suspend fun customLine(name: String, block: suspend CustomLineResourceBuilder.() -> Unit): CustomLine {
    val builder = CustomLineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomLine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customLine(name: String): CustomLine {
    val builder = CustomLineResourceBuilder()
    builder.name(name)
    return builder.build()
}
