@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.CustomLineArgs.builder
import com.pulumi.alicloud.dns.kotlin.inputs.CustomLineIpSegmentListArgs
import com.pulumi.alicloud.dns.kotlin.inputs.CustomLineIpSegmentListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Alidns Custom Line resource.
 * For information about Alidns Custom Line and how to use it, see [What is Custom Line](https://www.alibabacloud.com/help/en/doc-detail/145059.html).
 * > **NOTE:** Available since v1.151.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dns.CustomLine("default", {
 *     customLineName: "tf-example",
 *     domainName: "alicloud-provider.com",
 *     ipSegmentLists: [{
 *         startIp: "192.0.2.123",
 *         endIp: "192.0.2.125",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dns.CustomLine("default",
 *     custom_line_name="tf-example",
 *     domain_name="alicloud-provider.com",
 *     ip_segment_lists=[{
 *         "start_ip": "192.0.2.123",
 *         "end_ip": "192.0.2.125",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dns.CustomLine("default", new()
 *     {
 *         CustomLineName = "tf-example",
 *         DomainName = "alicloud-provider.com",
 *         IpSegmentLists = new[]
 *         {
 *             new AliCloud.Dns.Inputs.CustomLineIpSegmentListArgs
 *             {
 *                 StartIp = "192.0.2.123",
 *                 EndIp = "192.0.2.125",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewCustomLine(ctx, "default", &dns.CustomLineArgs{
 * 			CustomLineName: pulumi.String("tf-example"),
 * 			DomainName:     pulumi.String("alicloud-provider.com"),
 * 			IpSegmentLists: dns.CustomLineIpSegmentListArray{
 * 				&dns.CustomLineIpSegmentListArgs{
 * 					StartIp: pulumi.String("192.0.2.123"),
 * 					EndIp:   pulumi.String("192.0.2.125"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.CustomLine;
 * import com.pulumi.alicloud.dns.CustomLineArgs;
 * import com.pulumi.alicloud.dns.inputs.CustomLineIpSegmentListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new CustomLine("default", CustomLineArgs.builder()
 *             .customLineName("tf-example")
 *             .domainName("alicloud-provider.com")
 *             .ipSegmentLists(CustomLineIpSegmentListArgs.builder()
 *                 .startIp("192.0.2.123")
 *                 .endIp("192.0.2.125")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dns:CustomLine
 *     properties:
 *       customLineName: tf-example
 *       domainName: alicloud-provider.com
 *       ipSegmentLists:
 *         - startIp: 192.0.2.123
 *           endIp: 192.0.2.125
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns Custom Line can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/customLine:CustomLine example <id>
 * ```
 * @property customLineName The name of the Custom Line.
 * @property domainName The Domain name.
 * @property ipSegmentLists The IP segment list. See `ip_segment_list` below for details.
 * @property lang The lang.
 */
public data class CustomLineArgs(
    public val customLineName: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val ipSegmentLists: Output<List<CustomLineIpSegmentListArgs>>? = null,
    public val lang: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.CustomLineArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.CustomLineArgs =
        com.pulumi.alicloud.dns.CustomLineArgs.builder()
            .customLineName(customLineName?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .ipSegmentLists(
                ipSegmentLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lang(lang?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLineArgs].
 */
@PulumiTagMarker
public class CustomLineArgsBuilder internal constructor() {
    private var customLineName: Output<String>? = null

    private var domainName: Output<String>? = null

    private var ipSegmentLists: Output<List<CustomLineIpSegmentListArgs>>? = null

    private var lang: Output<String>? = null

    /**
     * @param value The name of the Custom Line.
     */
    @JvmName("dtbndwfauvrdwlji")
    public suspend fun customLineName(`value`: Output<String>) {
        this.customLineName = value
    }

    /**
     * @param value The Domain name.
     */
    @JvmName("vvnucjgpyvvlaefs")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The IP segment list. See `ip_segment_list` below for details.
     */
    @JvmName("oglvbmxvrtnwmgct")
    public suspend fun ipSegmentLists(`value`: Output<List<CustomLineIpSegmentListArgs>>) {
        this.ipSegmentLists = value
    }

    @JvmName("jbpmaexybntcejsx")
    public suspend fun ipSegmentLists(vararg values: Output<CustomLineIpSegmentListArgs>) {
        this.ipSegmentLists = Output.all(values.asList())
    }

    /**
     * @param values The IP segment list. See `ip_segment_list` below for details.
     */
    @JvmName("oryxrkqhmbiomsrg")
    public suspend fun ipSegmentLists(values: List<Output<CustomLineIpSegmentListArgs>>) {
        this.ipSegmentLists = Output.all(values)
    }

    /**
     * @param value The lang.
     */
    @JvmName("fbjnyhxrcabcvykw")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The name of the Custom Line.
     */
    @JvmName("xfyikyvdisbjpsvs")
    public suspend fun customLineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLineName = mapped
    }

    /**
     * @param value The Domain name.
     */
    @JvmName("uhyyfgnxivrtvgxq")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The IP segment list. See `ip_segment_list` below for details.
     */
    @JvmName("hnqywlwtvrtwqgid")
    public suspend fun ipSegmentLists(`value`: List<CustomLineIpSegmentListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSegmentLists = mapped
    }

    /**
     * @param argument The IP segment list. See `ip_segment_list` below for details.
     */
    @JvmName("tljfctxshtlgqvxa")
    public suspend fun ipSegmentLists(argument: List<suspend CustomLineIpSegmentListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomLineIpSegmentListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSegmentLists = mapped
    }

    /**
     * @param argument The IP segment list. See `ip_segment_list` below for details.
     */
    @JvmName("ylgjkybdocockplr")
    public suspend fun ipSegmentLists(vararg argument: suspend CustomLineIpSegmentListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomLineIpSegmentListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSegmentLists = mapped
    }

    /**
     * @param argument The IP segment list. See `ip_segment_list` below for details.
     */
    @JvmName("ihasomcaxcxdhwbf")
    public suspend fun ipSegmentLists(argument: suspend CustomLineIpSegmentListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomLineIpSegmentListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipSegmentLists = mapped
    }

    /**
     * @param values The IP segment list. See `ip_segment_list` below for details.
     */
    @JvmName("vbqsktctgwjwablf")
    public suspend fun ipSegmentLists(vararg values: CustomLineIpSegmentListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSegmentLists = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("rnhxkxdwkguqobhc")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    internal fun build(): CustomLineArgs = CustomLineArgs(
        customLineName = customLineName,
        domainName = domainName,
        ipSegmentLists = ipSegmentLists,
        lang = lang,
    )
}
