@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DdosBgpInstance].
 */
@PulumiTagMarker
@Deprecated(
    message = """
alicloud.dns.DdosBgpInstance has been deprecated in favor of alicloud.ddos.DdosBgpInstance
""",
)
public class DdosBgpInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DdosBgpInstanceArgs = DdosBgpInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DdosBgpInstanceArgsBuilder.() -> Unit) {
        val builder = DdosBgpInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DdosBgpInstance {
        val builtJavaResource = com.pulumi.alicloud.dns.DdosBgpInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DdosBgpInstance(builtJavaResource)
    }
}

/**
 * Anti-DDoS Advanced instance resource. "Ddosbgp" is the short term of this product.
 * > **NOTE:** The endpoint of bssopenapi used only support "business.aliyuncs.com" at present.
 * > **NOTE:** Available since v1.183.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const instance = new alicloud.ddos.DdosBgpInstance("instance", {
 *     name: name,
 *     baseBandwidth: 20,
 *     bandwidth: -1,
 *     ipCount: 100,
 *     ipType: "IPv4",
 *     normalBandwidth: 100,
 *     type: "Enterprise",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * instance = alicloud.ddos.DdosBgpInstance("instance",
 *     name=name,
 *     base_bandwidth=20,
 *     bandwidth=-1,
 *     ip_count=100,
 *     ip_type="IPv4",
 *     normal_bandwidth=100,
 *     type="Enterprise")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var instance = new AliCloud.Ddos.DdosBgpInstance("instance", new()
 *     {
 *         Name = name,
 *         BaseBandwidth = 20,
 *         Bandwidth = -1,
 *         IpCount = 100,
 *         IpType = "IPv4",
 *         NormalBandwidth = 100,
 *         Type = "Enterprise",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ddos"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ddos.NewDdosBgpInstance(ctx, "instance", &ddos.DdosBgpInstanceArgs{
 * 			Name:            pulumi.String(name),
 * 			BaseBandwidth:   pulumi.Int(20),
 * 			Bandwidth:       int(-1),
 * 			IpCount:         pulumi.Int(100),
 * 			IpType:          pulumi.String("IPv4"),
 * 			NormalBandwidth: pulumi.Int(100),
 * 			Type:            pulumi.String("Enterprise"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   instance:
 *     type: alicloud:ddos:DdosBgpInstance
 *     properties:
 *       name: ${name}
 *       baseBandwidth: 20
 *       bandwidth: -1
 *       ipCount: 100
 *       ipType: IPv4
 *       normalBandwidth: 100
 *       type: Enterprise
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ddosbgp instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/ddosBgpInstance:DdosBgpInstance example ddosbgp-abc123456
 * ```
 */
@Deprecated(
    message = """
alicloud.dns.DdosBgpInstance has been deprecated in favor of alicloud.ddos.DdosBgpInstance
""",
)
public class DdosBgpInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.DdosBgpInstance,
) : KotlinCustomResource(javaResource, DdosBgpInstanceMapper) {
    /**
     * Elastic defend bandwidth of the instance. This value must be larger than the base defend bandwidth. Valid values: 51,91,101,201,301. The unit is Gbps.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * Base defend bandwidth of the instance. Valid values: 20. The unit is Gbps. Default to `20`.
     */
    public val baseBandwidth: Output<Int>?
        get() = javaResource.baseBandwidth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IP count of the instance. Valid values: 100.
     */
    public val ipCount: Output<Int>
        get() = javaResource.ipCount().applyValue({ args0 -> args0 })

    /**
     * IP version of the instance. Valid values: IPv4,IPv6.
     */
    public val ipType: Output<String>
        get() = javaResource.ipType().applyValue({ args0 -> args0 })

    /**
     * Name of the instance. This name can have a string of 1 to 63 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Normal defend bandwidth of the instance. The unit is Gbps.
     */
    public val normalBandwidth: Output<Int>
        get() = javaResource.normalBandwidth().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of the instance. Valid values: `Enterprise`, `Professional`. Default to `Enterprise`
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DdosBgpInstanceMapper : ResourceMapper<DdosBgpInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.DdosBgpInstance::class == javaResource::class

    override fun map(javaResource: Resource): DdosBgpInstance = DdosBgpInstance(
        javaResource as
            com.pulumi.alicloud.dns.DdosBgpInstance,
    )
}

/**
 * @see [DdosBgpInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DdosBgpInstance].
 */
@Deprecated(
    message = """
alicloud.dns.DdosBgpInstance has been deprecated in favor of alicloud.ddos.DdosBgpInstance
""",
)
public suspend fun ddosBgpInstance(
    name: String,
    block: suspend DdosBgpInstanceResourceBuilder.() -> Unit,
): DdosBgpInstance {
    val builder = DdosBgpInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DdosBgpInstance].
 * @param name The _unique_ name of the resulting resource.
 */
@Deprecated(
    message = """
alicloud.dns.DdosBgpInstance has been deprecated in favor of alicloud.ddos.DdosBgpInstance
""",
)
public fun ddosBgpInstance(name: String): DdosBgpInstance {
    val builder = DdosBgpInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
