@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DnsDomain].
 */
@PulumiTagMarker
public class DnsDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DnsDomainArgs = DnsDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DnsDomainArgsBuilder.() -> Unit) {
        val builder = DnsDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DnsDomain {
        val builtJavaResource = com.pulumi.alicloud.dns.DnsDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DnsDomain(builtJavaResource)
    }
}

/**
 * Provides a DNS domain resource.
 * > **DEPRECATED:** This resource has been renamed to alicloud.dns.AlidnsDomain from version 1.95.0.
 * > **NOTE:** The domain name which you want to add must be already registered and had not added by another account. Every domain name can only exist in a unique group.
 * > **NOTE:** Available in v1.81.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a new Domain.
 * const dns = new alicloud.dns.DnsDomain("dns", {
 *     domainName: "starmove.com",
 *     groupId: "85ab8713-4a30-4de4-9d20-155ff830****",
 *     tags: {
 *         Created: "Terraform",
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a new Domain.
 * dns = alicloud.dns.DnsDomain("dns",
 *     domain_name="starmove.com",
 *     group_id="85ab8713-4a30-4de4-9d20-155ff830****",
 *     tags={
 *         "Created": "Terraform",
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a new Domain.
 *     var dns = new AliCloud.Dns.DnsDomain("dns", new()
 *     {
 *         DomainName = "starmove.com",
 *         GroupId = "85ab8713-4a30-4de4-9d20-155ff830****",
 *         Tags =
 *         {
 *             { "Created", "Terraform" },
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a new Domain.
 * 		_, err := dns.NewDnsDomain(ctx, "dns", &dns.DnsDomainArgs{
 * 			DomainName: pulumi.String("starmove.com"),
 * 			GroupId:    pulumi.String("85ab8713-4a30-4de4-9d20-155ff830****"),
 * 			Tags: pulumi.StringMap{
 * 				"Created":     pulumi.String("Terraform"),
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DnsDomain;
 * import com.pulumi.alicloud.dns.DnsDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a new Domain.
 *         var dns = new DnsDomain("dns", DnsDomainArgs.builder()
 *             .domainName("starmove.com")
 *             .groupId("85ab8713-4a30-4de4-9d20-155ff830****")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "Terraform"),
 *                 Map.entry("Environment", "test")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a new Domain.
 *   dns:
 *     type: alicloud:dns:DnsDomain
 *     properties:
 *       domainName: starmove.com
 *       groupId: 85ab8713-4a30-4de4-9d20-155ff830****
 *       tags:
 *         Created: Terraform
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS domain can be imported using the id or domain name, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/dnsDomain:DnsDomain example aliyun.com
 * ```
 */
public class DnsDomain internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.DnsDomain,
) : KotlinCustomResource(javaResource, DnsDomainMapper) {
    public val dnsServers: Output<List<String>>
        get() = javaResource.dnsServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The domain ID.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Name of the domain. This name without suffix can have a string of 1 to 63 characters(domain name subject, excluding suffix), must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Id of the group in which the domain will add. If not supplied, then use default group.
     */
    public val groupId: Output<String>?
        get() = javaResource.groupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * User language.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val punyCode: Output<String>
        get() = javaResource.punyCode().applyValue({ args0 -> args0 })

    /**
     * Remarks information for your domain name.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Id of resource group which the dns domain belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object DnsDomainMapper : ResourceMapper<DnsDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.DnsDomain::class == javaResource::class

    override fun map(javaResource: Resource): DnsDomain = DnsDomain(
        javaResource as
            com.pulumi.alicloud.dns.DnsDomain,
    )
}

/**
 * @see [DnsDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DnsDomain].
 */
public suspend fun dnsDomain(name: String, block: suspend DnsDomainResourceBuilder.() -> Unit): DnsDomain {
    val builder = DnsDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DnsDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dnsDomain(name: String): DnsDomain {
    val builder = DnsDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
