@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.DnsDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DNS domain resource.
 * > **DEPRECATED:** This resource has been renamed to alicloud.dns.AlidnsDomain from version 1.95.0.
 * > **NOTE:** The domain name which you want to add must be already registered and had not added by another account. Every domain name can only exist in a unique group.
 * > **NOTE:** Available in v1.81.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a new Domain.
 * const dns = new alicloud.dns.DnsDomain("dns", {
 *     domainName: "starmove.com",
 *     groupId: "85ab8713-4a30-4de4-9d20-155ff830****",
 *     tags: {
 *         Created: "Terraform",
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a new Domain.
 * dns = alicloud.dns.DnsDomain("dns",
 *     domain_name="starmove.com",
 *     group_id="85ab8713-4a30-4de4-9d20-155ff830****",
 *     tags={
 *         "Created": "Terraform",
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a new Domain.
 *     var dns = new AliCloud.Dns.DnsDomain("dns", new()
 *     {
 *         DomainName = "starmove.com",
 *         GroupId = "85ab8713-4a30-4de4-9d20-155ff830****",
 *         Tags =
 *         {
 *             { "Created", "Terraform" },
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a new Domain.
 * 		_, err := dns.NewDnsDomain(ctx, "dns", &dns.DnsDomainArgs{
 * 			DomainName: pulumi.String("starmove.com"),
 * 			GroupId:    pulumi.String("85ab8713-4a30-4de4-9d20-155ff830****"),
 * 			Tags: pulumi.StringMap{
 * 				"Created":     pulumi.String("Terraform"),
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DnsDomain;
 * import com.pulumi.alicloud.dns.DnsDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a new Domain.
 *         var dns = new DnsDomain("dns", DnsDomainArgs.builder()
 *             .domainName("starmove.com")
 *             .groupId("85ab8713-4a30-4de4-9d20-155ff830****")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "Terraform"),
 *                 Map.entry("Environment", "test")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a new Domain.
 *   dns:
 *     type: alicloud:dns:DnsDomain
 *     properties:
 *       domainName: starmove.com
 *       groupId: 85ab8713-4a30-4de4-9d20-155ff830****
 *       tags:
 *         Created: Terraform
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS domain can be imported using the id or domain name, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/dnsDomain:DnsDomain example aliyun.com
 * ```
 * @property domainName Name of the domain. This name without suffix can have a string of 1 to 63 characters(domain name subject, excluding suffix), must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
 * @property groupId Id of the group in which the domain will add. If not supplied, then use default group.
 * @property lang User language.
 * @property remark Remarks information for your domain name.
 * @property resourceGroupId The Id of resource group which the dns domain belongs.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 */
public data class DnsDomainArgs(
    public val domainName: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val remark: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.DnsDomainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.DnsDomainArgs =
        com.pulumi.alicloud.dns.DnsDomainArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DnsDomainArgs].
 */
@PulumiTagMarker
public class DnsDomainArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var groupId: Output<String>? = null

    private var lang: Output<String>? = null

    private var remark: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters(domain name subject, excluding suffix), must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("wvuvbjfuegneeylf")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Id of the group in which the domain will add. If not supplied, then use default group.
     */
    @JvmName("qsadalatspukfycm")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value User language.
     */
    @JvmName("qccedjiwmewtgcdo")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value Remarks information for your domain name.
     */
    @JvmName("ksgjuunhqvuamdid")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value The Id of resource group which the dns domain belongs.
     */
    @JvmName("dwyrouounavopmbe")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("qmpsahlhwnaayhfb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters(domain name subject, excluding suffix), must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("fokhfhivnbxclgrs")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Id of the group in which the domain will add. If not supplied, then use default group.
     */
    @JvmName("qvvuhfpgktbauerq")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("tmypumxskbcpcoon")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value Remarks information for your domain name.
     */
    @JvmName("pgtvqkeencwvkcsw")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value The Id of resource group which the dns domain belongs.
     */
    @JvmName("ywfdtiolrvpiaifg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("vqtlilkywihbbdmt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("fgwkrsdfwwpkcvsx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DnsDomainArgs = DnsDomainArgs(
        domainName = domainName,
        groupId = groupId,
        lang = lang,
        remark = remark,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
