@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.DnsFunctions.getAccessStrategiesPlain
import com.pulumi.alicloud.dns.DnsFunctions.getAddressPoolsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getAlidnsDomainGroupsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getAlidnsDomainsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getAlidnsInstancesPlain
import com.pulumi.alicloud.dns.DnsFunctions.getAlidnsRecordsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getCustomLinesPlain
import com.pulumi.alicloud.dns.DnsFunctions.getDomainGroupsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getDomainRecordsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getDomainTxtGuidPlain
import com.pulumi.alicloud.dns.DnsFunctions.getDomainsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getGroupsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getGtmInstancesPlain
import com.pulumi.alicloud.dns.DnsFunctions.getInstancesPlain
import com.pulumi.alicloud.dns.DnsFunctions.getRecordsPlain
import com.pulumi.alicloud.dns.DnsFunctions.getResolutionLinesPlain
import com.pulumi.alicloud.dns.kotlin.inputs.GetAccessStrategiesPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetAccessStrategiesPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetAddressPoolsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetAddressPoolsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsDomainGroupsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsDomainGroupsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsDomainsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsDomainsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsInstancesPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsInstancesPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsRecordsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetAlidnsRecordsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetCustomLinesPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetCustomLinesPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainGroupsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainGroupsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainRecordsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainRecordsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainTxtGuidPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainTxtGuidPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetGtmInstancesPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetGtmInstancesPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetRecordsPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetRecordsPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.inputs.GetResolutionLinesPlainArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GetResolutionLinesPlainArgsBuilder
import com.pulumi.alicloud.dns.kotlin.outputs.GetAccessStrategiesResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetAddressPoolsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsDomainGroupsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsDomainsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsInstancesResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsRecordsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetCustomLinesResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainGroupsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainRecordsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainTxtGuidResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetGroupsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetGtmInstancesResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetRecordsResult
import com.pulumi.alicloud.dns.kotlin.outputs.GetResolutionLinesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.dns.kotlin.outputs.GetAccessStrategiesResult.Companion.toKotlin as getAccessStrategiesResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetAddressPoolsResult.Companion.toKotlin as getAddressPoolsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsDomainGroupsResult.Companion.toKotlin as getAlidnsDomainGroupsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsDomainsResult.Companion.toKotlin as getAlidnsDomainsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsInstancesResult.Companion.toKotlin as getAlidnsInstancesResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsRecordsResult.Companion.toKotlin as getAlidnsRecordsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetCustomLinesResult.Companion.toKotlin as getCustomLinesResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainGroupsResult.Companion.toKotlin as getDomainGroupsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainRecordsResult.Companion.toKotlin as getDomainRecordsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainTxtGuidResult.Companion.toKotlin as getDomainTxtGuidResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetDomainsResult.Companion.toKotlin as getDomainsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetGroupsResult.Companion.toKotlin as getGroupsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetGtmInstancesResult.Companion.toKotlin as getGtmInstancesResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetRecordsResult.Companion.toKotlin as getRecordsResultToKotlin
import com.pulumi.alicloud.dns.kotlin.outputs.GetResolutionLinesResult.Companion.toKotlin as getResolutionLinesResultToKotlin

public object DnsFunctions {
    /**
     * This data source provides the Alidns Access Strategies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.152.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dns.getAccessStrategies({
     *     instanceId: "example_value",
     *     strategyMode: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     nameRegex: "the_resource_name",
     * });
     * export const alidnsAccessStrategyId1 = ids.then(ids => ids.strategies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dns.get_access_strategies(instance_id="example_value",
     *     strategy_mode="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     name_regex="the_resource_name")
     * pulumi.export("alidnsAccessStrategyId1", ids.strategies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dns.GetAccessStrategies.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         StrategyMode = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alidnsAccessStrategyId1"] = ids&#46;Apply(getAccessStrategiesResult => getAccessStrategiesResult&#46;Strategies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dns.GetAccessStrategies(ctx, &dns.GetAccessStrategiesArgs{
     * 			InstanceId:   "example_value",
     * 			StrategyMode: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alidnsAccessStrategyId1", ids.Strategies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetAccessStrategiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DnsFunctions.getAccessStrategies(GetAccessStrategiesArgs.builder()
     *             .instanceId("example_value")
     *             .strategyMode("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("alidnsAccessStrategyId1", ids.applyValue(getAccessStrategiesResult -> getAccessStrategiesResult.strategies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dns:getAccessStrategies
     *       Arguments:
     *         instanceId: example_value
     *         strategyMode: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *         nameRegex: the_resource_name
     * outputs:
     *   alidnsAccessStrategyId1: ${ids.strategies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessStrategies.
     * @return A collection of values returned by getAccessStrategies.
     */
    public suspend fun getAccessStrategies(argument: GetAccessStrategiesPlainArgs): GetAccessStrategiesResult =
        getAccessStrategiesResultToKotlin(getAccessStrategiesPlain(argument.toJava()).await())

    /**
     * @see [getAccessStrategies].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Access Strategy IDs.
     * @param instanceId The Id of the associated instance.
     * @param lang The lang.
     * @param nameRegex A regex string to filter results by Access Strategy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param strategyMode The type of the access policy. Valid values:
     * - `GEO`: based on geographic location.
     * - `LATENCY`: Based on delay.
     * @return A collection of values returned by getAccessStrategies.
     */
    public suspend fun getAccessStrategies(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        lang: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        strategyMode: String,
    ): GetAccessStrategiesResult {
        val argument = GetAccessStrategiesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            lang = lang,
            nameRegex = nameRegex,
            outputFile = outputFile,
            strategyMode = strategyMode,
        )
        return getAccessStrategiesResultToKotlin(getAccessStrategiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessStrategies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetAccessStrategiesPlainArgs].
     * @return A collection of values returned by getAccessStrategies.
     */
    public suspend fun getAccessStrategies(argument: suspend GetAccessStrategiesPlainArgsBuilder.() -> Unit): GetAccessStrategiesResult {
        val builder = GetAccessStrategiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessStrategiesResultToKotlin(getAccessStrategiesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alidns Address Pools of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.152.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dns.getAddressPools({
     *     instanceId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const alidnsAddressPoolId1 = ids.then(ids => ids.pools?.[0]?.id);
     * const nameRegex = alicloud.dns.getAddressPools({
     *     instanceId: "example_value",
     *     nameRegex: "^my-AddressPool",
     * });
     * export const alidnsAddressPoolId2 = nameRegex.then(nameRegex => nameRegex.pools?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dns.get_address_pools(instance_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("alidnsAddressPoolId1", ids.pools[0].id)
     * name_regex = alicloud.dns.get_address_pools(instance_id="example_value",
     *     name_regex="^my-AddressPool")
     * pulumi.export("alidnsAddressPoolId2", name_regex.pools[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dns.GetAddressPools.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Dns.GetAddressPools.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         NameRegex = "^my-AddressPool",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alidnsAddressPoolId1"] = ids&#46;Apply(getAddressPoolsResult => getAddressPoolsResult&#46;Pools[0]?.Id),
     *         ["alidnsAddressPoolId2"] = nameRegex&#46;Apply(getAddressPoolsResult => getAddressPoolsResult&#46;Pools[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dns.GetAddressPools(ctx, &dns.GetAddressPoolsArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alidnsAddressPoolId1", ids.Pools[0].Id)
     * 		nameRegex, err := dns.GetAddressPools(ctx, &dns.GetAddressPoolsArgs{
     * 			InstanceId: "example_value",
     * 			NameRegex:  pulumi.StringRef("^my-AddressPool"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alidnsAddressPoolId2", nameRegex.Pools[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetAddressPoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DnsFunctions.getAddressPools(GetAddressPoolsArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("alidnsAddressPoolId1", ids.applyValue(getAddressPoolsResult -> getAddressPoolsResult.pools()[0].id()));
     *         final var nameRegex = DnsFunctions.getAddressPools(GetAddressPoolsArgs.builder()
     *             .instanceId("example_value")
     *             .nameRegex("^my-AddressPool")
     *             .build());
     *         ctx.export("alidnsAddressPoolId2", nameRegex.applyValue(getAddressPoolsResult -> getAddressPoolsResult.pools()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dns:getAddressPools
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:dns:getAddressPools
     *       Arguments:
     *         instanceId: example_value
     *         nameRegex: ^my-AddressPool
     * outputs:
     *   alidnsAddressPoolId1: ${ids.pools[0].id}
     *   alidnsAddressPoolId2: ${nameRegex.pools[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAddressPools.
     * @return A collection of values returned by getAddressPools.
     */
    public suspend fun getAddressPools(argument: GetAddressPoolsPlainArgs): GetAddressPoolsResult =
        getAddressPoolsResultToKotlin(getAddressPoolsPlain(argument.toJava()).await())

    /**
     * @see [getAddressPools].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Address Pool IDs.
     * @param instanceId The id of the instance.
     * @param nameRegex A regex string to filter results by Address Pool name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAddressPools.
     */
    public suspend fun getAddressPools(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAddressPoolsResult {
        val argument = GetAddressPoolsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAddressPoolsResultToKotlin(getAddressPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddressPools].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetAddressPoolsPlainArgs].
     * @return A collection of values returned by getAddressPools.
     */
    public suspend fun getAddressPools(argument: suspend GetAddressPoolsPlainArgsBuilder.() -> Unit): GetAddressPoolsResult {
        val builder = GetAddressPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddressPoolsResultToKotlin(getAddressPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Alidns Domain Groups in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:**  Available in 1.85.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.dns.getAlidnsDomainGroups({
     *     ids: ["c5ef2bc43064445787adf182af2****"],
     * });
     * export const firstDomainGroupId = example.then(example => example.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.dns.get_alidns_domain_groups(ids=["c5ef2bc43064445787adf182af2****"])
     * pulumi.export("firstDomainGroupId", example.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Dns.GetAlidnsDomainGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "c5ef2bc43064445787adf182af2****",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDomainGroupId"] = example&#46;Apply(getAlidnsDomainGroupsResult => getAlidnsDomainGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := dns.GetAlidnsDomainGroups(ctx, &dns.GetAlidnsDomainGroupsArgs{
     * 			Ids: []string{
     * 				"c5ef2bc43064445787adf182af2****",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDomainGroupId", example.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetAlidnsDomainGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DnsFunctions.getAlidnsDomainGroups(GetAlidnsDomainGroupsArgs.builder()
     *             .ids("c5ef2bc43064445787adf182af2****")
     *             .build());
     *         ctx.export("firstDomainGroupId", example.applyValue(getAlidnsDomainGroupsResult -> getAlidnsDomainGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:dns:getAlidnsDomainGroups
     *       Arguments:
     *         ids:
     *           - c5ef2bc43064445787adf182af2****
     * outputs:
     *   firstDomainGroupId: ${example.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlidnsDomainGroups.
     * @return A collection of values returned by getAlidnsDomainGroups.
     */
    public suspend fun getAlidnsDomainGroups(argument: GetAlidnsDomainGroupsPlainArgs): GetAlidnsDomainGroupsResult =
        getAlidnsDomainGroupsResultToKotlin(getAlidnsDomainGroupsPlain(argument.toJava()).await())

    /**
     * @see [getAlidnsDomainGroups].
     * @param ids A list of instance IDs.
     * @param nameRegex A regex string to filter results by the domain group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAlidnsDomainGroups.
     */
    public suspend fun getAlidnsDomainGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAlidnsDomainGroupsResult {
        val argument = GetAlidnsDomainGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAlidnsDomainGroupsResultToKotlin(getAlidnsDomainGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlidnsDomainGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetAlidnsDomainGroupsPlainArgs].
     * @return A collection of values returned by getAlidnsDomainGroups.
     */
    public suspend fun getAlidnsDomainGroups(argument: suspend GetAlidnsDomainGroupsPlainArgsBuilder.() -> Unit): GetAlidnsDomainGroupsResult {
        val builder = GetAlidnsDomainGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlidnsDomainGroupsResultToKotlin(getAlidnsDomainGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Alidns Domains in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:**  Available in 1.95.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const domainsDs = alicloud.dns.getAlidnsDomains({
     *     domainNameRegex: "^hegu",
     *     outputFile: "domains.txt",
     * });
     * export const firstDomainId = domainsDs.then(domainsDs => domainsDs.domains?.[0]?.domainId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * domains_ds = alicloud.dns.get_alidns_domains(domain_name_regex="^hegu",
     *     output_file="domains.txt")
     * pulumi.export("firstDomainId", domains_ds.domains[0].domain_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var domainsDs = AliCloud.Dns.GetAlidnsDomains.Invoke(new()
     *     {
     *         DomainNameRegex = "^hegu",
     *         OutputFile = "domains.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDomainId"] = domainsDs&#46;Apply(getAlidnsDomainsResult => getAlidnsDomainsResult&#46;Domains[0]?.DomainId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		domainsDs, err := dns.GetAlidnsDomains(ctx, &dns.GetAlidnsDomainsArgs{
     * 			DomainNameRegex: pulumi.StringRef("^hegu"),
     * 			OutputFile:      pulumi.StringRef("domains.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDomainId", domainsDs.Domains[0].DomainId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetAlidnsDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var domainsDs = DnsFunctions.getAlidnsDomains(GetAlidnsDomainsArgs.builder()
     *             .domainNameRegex("^hegu")
     *             .outputFile("domains.txt")
     *             .build());
     *         ctx.export("firstDomainId", domainsDs.applyValue(getAlidnsDomainsResult -> getAlidnsDomainsResult.domains()[0].domainId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   domainsDs:
     *     fn::invoke:
     *       Function: alicloud:dns:getAlidnsDomains
     *       Arguments:
     *         domainNameRegex: ^hegu
     *         outputFile: domains.txt
     * outputs:
     *   firstDomainId: ${domainsDs.domains[0].domainId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlidnsDomains.
     * @return A collection of values returned by getAlidnsDomains.
     */
    public suspend fun getAlidnsDomains(argument: GetAlidnsDomainsPlainArgs): GetAlidnsDomainsResult =
        getAlidnsDomainsResultToKotlin(getAlidnsDomainsPlain(argument.toJava()).await())

    /**
     * @see [getAlidnsDomains].
     * @param aliDomain Specifies whether the domain is from Alibaba Cloud or not.
     * @param domainNameRegex A regex string to filter results by the domain name.
     * @param enableDetails
     * @param groupId Domain group ID, if not filled, the default is all groups.
     * @param groupNameRegex A regex string to filter results by the group name.
     * @param ids A list of domain IDs.
     * @param instanceId Cloud analysis product ID.
     * @param keyWord The keywords are searched according to the `%KeyWord%` mode, which is not case sensitive.
     * @param lang User language.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which the dns belongs.
     * @param searchMode Search mode, `LIKE` fuzzy search, `EXACT` exact search.
     * @param starmark Whether to query the domain name star.
     * @param tags A mapping of tags to assign to the resource.
     * @param versionCode Cloud analysis version code.
     * @return A collection of values returned by getAlidnsDomains.
     */
    public suspend fun getAlidnsDomains(
        aliDomain: Boolean? = null,
        domainNameRegex: String? = null,
        enableDetails: Boolean? = null,
        groupId: String? = null,
        groupNameRegex: String? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        keyWord: String? = null,
        lang: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        searchMode: String? = null,
        starmark: Boolean? = null,
        tags: Map<String, String>? = null,
        versionCode: String? = null,
    ): GetAlidnsDomainsResult {
        val argument = GetAlidnsDomainsPlainArgs(
            aliDomain = aliDomain,
            domainNameRegex = domainNameRegex,
            enableDetails = enableDetails,
            groupId = groupId,
            groupNameRegex = groupNameRegex,
            ids = ids,
            instanceId = instanceId,
            keyWord = keyWord,
            lang = lang,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            searchMode = searchMode,
            starmark = starmark,
            tags = tags,
            versionCode = versionCode,
        )
        return getAlidnsDomainsResultToKotlin(getAlidnsDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlidnsDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetAlidnsDomainsPlainArgs].
     * @return A collection of values returned by getAlidnsDomains.
     */
    public suspend fun getAlidnsDomains(argument: suspend GetAlidnsDomainsPlainArgsBuilder.() -> Unit): GetAlidnsDomainsResult {
        val builder = GetAlidnsDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlidnsDomainsResultToKotlin(getAlidnsDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Alidns instances in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:**  Available in 1.95.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.dns.getAlidnsInstances({
     *     ids: ["dns-cn-oew1npk****"],
     * });
     * export const firstInstanceId = example.then(example => example.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.dns.get_alidns_instances(ids=["dns-cn-oew1npk****"])
     * pulumi.export("firstInstanceId", example.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Dns.GetAlidnsInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "dns-cn-oew1npk****",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceId"] = example&#46;Apply(getAlidnsInstancesResult => getAlidnsInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := dns.GetAlidnsInstances(ctx, &dns.GetAlidnsInstancesArgs{
     * 			Ids: []string{
     * 				"dns-cn-oew1npk****",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceId", example.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetAlidnsInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DnsFunctions.getAlidnsInstances(GetAlidnsInstancesArgs.builder()
     *             .ids("dns-cn-oew1npk****")
     *             .build());
     *         ctx.export("firstInstanceId", example.applyValue(getAlidnsInstancesResult -> getAlidnsInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:dns:getAlidnsInstances
     *       Arguments:
     *         ids:
     *           - dns-cn-oew1npk****
     * outputs:
     *   firstInstanceId: ${example.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAlidnsInstances.
     * @return A collection of values returned by getAlidnsInstances.
     */
    public suspend fun getAlidnsInstances(argument: GetAlidnsInstancesPlainArgs): GetAlidnsInstancesResult =
        getAlidnsInstancesResultToKotlin(getAlidnsInstancesPlain(argument.toJava()).await())

    /**
     * @see [getAlidnsInstances].
     * @param domainType The type of domain.
     * @param ids A list of instance IDs.
     * @param lang Language.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param userClientIp The IP address of the client.
     * @return A collection of values returned by getAlidnsInstances.
     */
    public suspend fun getAlidnsInstances(
        domainType: String? = null,
        ids: List<String>? = null,
        lang: String? = null,
        outputFile: String? = null,
        userClientIp: String? = null,
    ): GetAlidnsInstancesResult {
        val argument = GetAlidnsInstancesPlainArgs(
            domainType = domainType,
            ids = ids,
            lang = lang,
            outputFile = outputFile,
            userClientIp = userClientIp,
        )
        return getAlidnsInstancesResultToKotlin(getAlidnsInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlidnsInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetAlidnsInstancesPlainArgs].
     * @return A collection of values returned by getAlidnsInstances.
     */
    public suspend fun getAlidnsInstances(argument: suspend GetAlidnsInstancesPlainArgsBuilder.() -> Unit): GetAlidnsInstancesResult {
        val builder = GetAlidnsInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlidnsInstancesResultToKotlin(getAlidnsInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of Alidns Domain Records in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:**  Available in 1.86.0+.
     * ## Example Usage
     * ```terraform
     * data "alicloud_alidns_records" "records_ds" {
     *   domain_name = "xiaozhu.top"
     *   ids         = ["1978593525779****"]
     *   type        = "A"
     *   output_file = "records.txt"
     * }
     * output "first_record_id" {
     *   value = "${data.alicloud_alidns_records.records_ds.records.0.record_id}"
     * }
     * ```
     * @param argument A collection of arguments for invoking getAlidnsRecords.
     * @return A collection of values returned by getAlidnsRecords.
     */
    public suspend fun getAlidnsRecords(argument: GetAlidnsRecordsPlainArgs): GetAlidnsRecordsResult =
        getAlidnsRecordsResultToKotlin(getAlidnsRecordsPlain(argument.toJava()).await())

    /**
     * @see [getAlidnsRecords].
     * @param direction Sorting direction. Valid values: `DESC`,`ASC`. Default to `AESC`.
     * @param domainName The domain name associated to the records.
     * @param groupId Domain name group ID.
     * @param ids A list of record IDs.
     * @param keyWord Keywords.
     * @param lang User language.
     * @param line ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
     * @param orderBy Sort by. Sort from newest to oldest according to the time added by resolution.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param rrKeyWord The keywords recorded by the host are searched according to the `%RRKeyWord%` mode, and are not case sensitive.
     * @param rrRegex Host record regex.
     * @param searchMode Search mode, Valid values: `LIKE`, `EXACT`, `ADVANCED`, `LIKE` (fuzzy), `EXACT` (accurate) search supports KeyWord field, `ADVANCED` (advanced) mode supports other fields.
     * @param status Record status. Valid values: `ENABLE` and `DISABLE`.
     * @param type Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
     * @param typeKeyWord Analyze type keywords, search by full match, not case sensitive.
     * @param valueKeyWord The keywords of the recorded value are searched according to the `%ValueKeyWord%` mode, and are not case sensitive.
     * @param valueRegex Host record value regex.
     * @return A collection of values returned by getAlidnsRecords.
     */
    public suspend fun getAlidnsRecords(
        direction: String? = null,
        domainName: String,
        groupId: Int? = null,
        ids: List<String>? = null,
        keyWord: String? = null,
        lang: String? = null,
        line: String? = null,
        orderBy: String? = null,
        outputFile: String? = null,
        rrKeyWord: String? = null,
        rrRegex: String? = null,
        searchMode: String? = null,
        status: String? = null,
        type: String? = null,
        typeKeyWord: String? = null,
        valueKeyWord: String? = null,
        valueRegex: String? = null,
    ): GetAlidnsRecordsResult {
        val argument = GetAlidnsRecordsPlainArgs(
            direction = direction,
            domainName = domainName,
            groupId = groupId,
            ids = ids,
            keyWord = keyWord,
            lang = lang,
            line = line,
            orderBy = orderBy,
            outputFile = outputFile,
            rrKeyWord = rrKeyWord,
            rrRegex = rrRegex,
            searchMode = searchMode,
            status = status,
            type = type,
            typeKeyWord = typeKeyWord,
            valueKeyWord = valueKeyWord,
            valueRegex = valueRegex,
        )
        return getAlidnsRecordsResultToKotlin(getAlidnsRecordsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlidnsRecords].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetAlidnsRecordsPlainArgs].
     * @return A collection of values returned by getAlidnsRecords.
     */
    public suspend fun getAlidnsRecords(argument: suspend GetAlidnsRecordsPlainArgsBuilder.() -> Unit): GetAlidnsRecordsResult {
        val builder = GetAlidnsRecordsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlidnsRecordsResultToKotlin(getAlidnsRecordsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alidns Custom Lines of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.151.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dns.getCustomLines({
     *     enableDetails: true,
     *     domainName: "your_domain_name",
     * });
     * export const alidnsCustomLineId1 = ids.then(ids => ids.lines?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dns.get_custom_lines(enable_details=True,
     *     domain_name="your_domain_name")
     * pulumi.export("alidnsCustomLineId1", ids.lines[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dns.GetCustomLines.Invoke(new()
     *     {
     *         EnableDetails = true,
     *         DomainName = "your_domain_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alidnsCustomLineId1"] = ids&#46;Apply(getCustomLinesResult => getCustomLinesResult&#46;Lines[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dns.GetCustomLines(ctx, &dns.GetCustomLinesArgs{
     * 			EnableDetails: pulumi.BoolRef(true),
     * 			DomainName:    "your_domain_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alidnsCustomLineId1", ids.Lines[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetCustomLinesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DnsFunctions.getCustomLines(GetCustomLinesArgs.builder()
     *             .enableDetails(true)
     *             .domainName("your_domain_name")
     *             .build());
     *         ctx.export("alidnsCustomLineId1", ids.applyValue(getCustomLinesResult -> getCustomLinesResult.lines()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dns:getCustomLines
     *       Arguments:
     *         enableDetails: true
     *         domainName: your_domain_name
     * outputs:
     *   alidnsCustomLineId1: ${ids.lines[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomLines.
     * @return A collection of values returned by getCustomLines.
     */
    public suspend fun getCustomLines(argument: GetCustomLinesPlainArgs): GetCustomLinesResult =
        getCustomLinesResultToKotlin(getCustomLinesPlain(argument.toJava()).await())

    /**
     * @see [getCustomLines].
     * @param domainName The Domain name.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Custom Line IDs.
     * @param lang The lang.
     * @param nameRegex A regex string to filter results by Custom Line name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getCustomLines.
     */
    public suspend fun getCustomLines(
        domainName: String,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        lang: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetCustomLinesResult {
        val argument = GetCustomLinesPlainArgs(
            domainName = domainName,
            enableDetails = enableDetails,
            ids = ids,
            lang = lang,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getCustomLinesResultToKotlin(getCustomLinesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomLines].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetCustomLinesPlainArgs].
     * @return A collection of values returned by getCustomLines.
     */
    public suspend fun getCustomLines(argument: suspend GetCustomLinesPlainArgsBuilder.() -> Unit): GetCustomLinesResult {
        val builder = GetCustomLinesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomLinesResultToKotlin(getCustomLinesPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** This datasource has been deprecated from v1.3.2. Please use the datasource `alicloud.dns.getGroups` instead.
     * @param argument A collection of arguments for invoking getDomainGroups.
     * @return A collection of values returned by getDomainGroups.
     */
    public suspend fun getDomainGroups(argument: GetDomainGroupsPlainArgs): GetDomainGroupsResult =
        getDomainGroupsResultToKotlin(getDomainGroupsPlain(argument.toJava()).await())

    /**
     * @see [getDomainGroups].
     * @param ids
     * @param nameRegex
     * @param outputFile
     * @return A collection of values returned by getDomainGroups.
     */
    public suspend fun getDomainGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDomainGroupsResult {
        val argument = GetDomainGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDomainGroupsResultToKotlin(getDomainGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetDomainGroupsPlainArgs].
     * @return A collection of values returned by getDomainGroups.
     */
    public suspend fun getDomainGroups(argument: suspend GetDomainGroupsPlainArgsBuilder.() -> Unit): GetDomainGroupsResult {
        val builder = GetDomainGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainGroupsResultToKotlin(getDomainGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** This resource has been deprecated from v1.3.2. Please use the datasource `alicloud.dns.getRecords` instead.
     * @param argument A collection of arguments for invoking getDomainRecords.
     * @return A collection of values returned by getDomainRecords.
     */
    public suspend fun getDomainRecords(argument: GetDomainRecordsPlainArgs): GetDomainRecordsResult =
        getDomainRecordsResultToKotlin(getDomainRecordsPlain(argument.toJava()).await())

    /**
     * @see [getDomainRecords].
     * @param domainName
     * @param hostRecordRegex
     * @param ids
     * @param isLocked
     * @param line
     * @param outputFile
     * @param status
     * @param type
     * @param valueRegex
     * @return A collection of values returned by getDomainRecords.
     */
    public suspend fun getDomainRecords(
        domainName: String,
        hostRecordRegex: String? = null,
        ids: List<String>? = null,
        isLocked: Boolean? = null,
        line: String? = null,
        outputFile: String? = null,
        status: String? = null,
        type: String? = null,
        valueRegex: String? = null,
    ): GetDomainRecordsResult {
        val argument = GetDomainRecordsPlainArgs(
            domainName = domainName,
            hostRecordRegex = hostRecordRegex,
            ids = ids,
            isLocked = isLocked,
            line = line,
            outputFile = outputFile,
            status = status,
            type = type,
            valueRegex = valueRegex,
        )
        return getDomainRecordsResultToKotlin(getDomainRecordsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainRecords].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetDomainRecordsPlainArgs].
     * @return A collection of values returned by getDomainRecords.
     */
    public suspend fun getDomainRecords(argument: suspend GetDomainRecordsPlainArgsBuilder.() -> Unit): GetDomainRecordsResult {
        val builder = GetDomainRecordsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainRecordsResultToKotlin(getDomainRecordsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides the generation of txt records to realize the retrieval and verification of domain names.
     * > **NOTE:** Available in v1.80.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const this = alicloud.dns.getDomainTxtGuid({
     *     domainName: "test111.abc",
     *     type: "ADD_SUB_DOMAIN",
     * });
     * export const rr = _this.then(_this => _this.rr);
     * export const value = _this.then(_this => _this.value);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.dns.get_domain_txt_guid(domain_name="test111.abc",
     *     type="ADD_SUB_DOMAIN")
     * pulumi.export("rr", this.rr)
     * pulumi.export("value", this.value)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.Dns.GetDomainTxtGuid.Invoke(new()
     *     {
     *         DomainName = "test111.abc",
     *         Type = "ADD_SUB_DOMAIN",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["rr"] = @this.Apply(@this => @this.Apply(getDomainTxtGuidResult => getDomainTxtGuidResult.Rr)),
     *         ["value"] = @this.Apply(@this => @this.Apply(getDomainTxtGuidResult => getDomainTxtGuidResult.Value)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		this, err := dns.GetDomainTxtGuid(ctx, &dns.GetDomainTxtGuidArgs{
     * 			DomainName: "test111.abc",
     * 			Type:       "ADD_SUB_DOMAIN",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rr", this.Rr)
     * 		ctx.Export("value", this.Value)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetDomainTxtGuidArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = DnsFunctions.getDomainTxtGuid(GetDomainTxtGuidArgs.builder()
     *             .domainName("test111.abc")
     *             .type("ADD_SUB_DOMAIN")
     *             .build());
     *         ctx.export("rr", this_.rr());
     *         ctx.export("value", this_.value());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:dns:getDomainTxtGuid
     *       Arguments:
     *         domainName: test111.abc
     *         type: ADD_SUB_DOMAIN
     * outputs:
     *   rr: ${this.rr}
     *   value: ${this.value}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomainTxtGuid.
     * @return A collection of values returned by getDomainTxtGuid.
     */
    public suspend fun getDomainTxtGuid(argument: GetDomainTxtGuidPlainArgs): GetDomainTxtGuidResult =
        getDomainTxtGuidResultToKotlin(getDomainTxtGuidPlain(argument.toJava()).await())

    /**
     * @see [getDomainTxtGuid].
     * @param domainName Verified domain name.
     * @param lang User language.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param type Txt verification function. Value:`ADD_SUB_DOMAIN`, `RETRIEVAL`.
     * @return A collection of values returned by getDomainTxtGuid.
     */
    public suspend fun getDomainTxtGuid(
        domainName: String,
        lang: String? = null,
        outputFile: String? = null,
        type: String,
    ): GetDomainTxtGuidResult {
        val argument = GetDomainTxtGuidPlainArgs(
            domainName = domainName,
            lang = lang,
            outputFile = outputFile,
            type = type,
        )
        return getDomainTxtGuidResultToKotlin(getDomainTxtGuidPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainTxtGuid].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetDomainTxtGuidPlainArgs].
     * @return A collection of values returned by getDomainTxtGuid.
     */
    public suspend fun getDomainTxtGuid(argument: suspend GetDomainTxtGuidPlainArgsBuilder.() -> Unit): GetDomainTxtGuidResult {
        val builder = GetDomainTxtGuidPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainTxtGuidResultToKotlin(getDomainTxtGuidPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:**  This resource has been renamed to alicloud.dns.getAlidnsDomains from version 1.95.0.
     * This data source provides a list of DNS Domains in an Alibaba Cloud account according to the specified filters.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const domainsDs = alicloud.dns.getDomains({
     *     domainNameRegex: "^hegu",
     *     outputFile: "domains.txt",
     * });
     * export const firstDomainId = domainsDs.then(domainsDs => domainsDs.domains?.[0]?.domainId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * domains_ds = alicloud.dns.get_domains(domain_name_regex="^hegu",
     *     output_file="domains.txt")
     * pulumi.export("firstDomainId", domains_ds.domains[0].domain_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var domainsDs = AliCloud.Dns.GetDomains.Invoke(new()
     *     {
     *         DomainNameRegex = "^hegu",
     *         OutputFile = "domains.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDomainId"] = domainsDs&#46;Apply(getDomainsResult => getDomainsResult&#46;Domains[0]?.DomainId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		domainsDs, err := dns.GetDomains(ctx, &dns.GetDomainsArgs{
     * 			DomainNameRegex: pulumi.StringRef("^hegu"),
     * 			OutputFile:      pulumi.StringRef("domains.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDomainId", domainsDs.Domains[0].DomainId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var domainsDs = DnsFunctions.getDomains(GetDomainsArgs.builder()
     *             .domainNameRegex("^hegu")
     *             .outputFile("domains.txt")
     *             .build());
     *         ctx.export("firstDomainId", domainsDs.applyValue(getDomainsResult -> getDomainsResult.domains()[0].domainId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   domainsDs:
     *     fn::invoke:
     *       Function: alicloud:dns:getDomains
     *       Arguments:
     *         domainNameRegex: ^hegu
     *         outputFile: domains.txt
     * outputs:
     *   firstDomainId: ${domainsDs.domains[0].domainId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param aliDomain Specifies whether the domain is from Alibaba Cloud or not.
     * @param domainNameRegex A regex string to filter results by the domain name.
     * @param enableDetails
     * @param groupId Domain group ID, if not filled, the default is all groups.
     * @param groupNameRegex A regex string to filter results by the group name.
     * @param ids A list of domain IDs.
     * @param instanceId Cloud analysis product ID.
     * @param keyWord The keywords are searched according to the `%KeyWord%` mode, which is not case sensitive.
     * @param lang User language.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which the dns belongs.
     * @param searchMode Search mode, `LIKE` fuzzy search, `EXACT` exact search.
     * @param starmark Whether to query the domain name star.
     * @param tags A mapping of tags to assign to the resource.
     * @param versionCode Cloud analysis version code.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        aliDomain: Boolean? = null,
        domainNameRegex: String? = null,
        enableDetails: Boolean? = null,
        groupId: String? = null,
        groupNameRegex: String? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        keyWord: String? = null,
        lang: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        searchMode: String? = null,
        starmark: Boolean? = null,
        tags: Map<String, String>? = null,
        versionCode: String? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            aliDomain = aliDomain,
            domainNameRegex = domainNameRegex,
            enableDetails = enableDetails,
            groupId = groupId,
            groupNameRegex = groupNameRegex,
            ids = ids,
            instanceId = instanceId,
            keyWord = keyWord,
            lang = lang,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            searchMode = searchMode,
            starmark = starmark,
            tags = tags,
            versionCode = versionCode,
        )
        return getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainsResultToKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of DNS Domain Groups in an Alibaba Cloud account according to the specified filters.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const groupsDs = alicloud.dns.getGroups({
     *     nameRegex: "^y[A-Za-z]+",
     *     outputFile: "groups.txt",
     * });
     * export const firstGroupName = groupsDs.then(groupsDs => groupsDs.groups?.[0]?.groupName);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * groups_ds = alicloud.dns.get_groups(name_regex="^y[A-Za-z]+",
     *     output_file="groups.txt")
     * pulumi.export("firstGroupName", groups_ds.groups[0].group_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var groupsDs = AliCloud.Dns.GetGroups.Invoke(new()
     *     {
     *         NameRegex = "^y[A-Za-z]+",
     *         OutputFile = "groups.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGroupName"] = groupsDs&#46;Apply(getGroupsResult => getGroupsResult&#46;Groups[0]?.GroupName),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		groupsDs, err := dns.GetGroups(ctx, &dns.GetGroupsArgs{
     * 			NameRegex:  pulumi.StringRef("^y[A-Za-z]+"),
     * 			OutputFile: pulumi.StringRef("groups.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGroupName", groupsDs.Groups[0].GroupName)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var groupsDs = DnsFunctions.getGroups(GetGroupsArgs.builder()
     *             .nameRegex("^y[A-Za-z]+")
     *             .outputFile("groups.txt")
     *             .build());
     *         ctx.export("firstGroupName", groupsDs.applyValue(getGroupsResult -> getGroupsResult.groups()[0].groupName()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   groupsDs:
     *     fn::invoke:
     *       Function: alicloud:dns:getGroups
     *       Arguments:
     *         nameRegex: ^y[A-Za-z]+
     *         outputFile: groups.txt
     * outputs:
     *   firstGroupName: ${groupsDs.groups[0].groupName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param ids A list of group IDs.
     * @param nameRegex A regex string to filter results by group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsResultToKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alidns Gtm Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.151.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dns.getGtmInstances({});
     * export const alidnsGtmInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dns.get_gtm_instances()
     * pulumi.export("alidnsGtmInstanceId1", ids.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dns.GetGtmInstances.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alidnsGtmInstanceId1"] = ids&#46;Apply(getGtmInstancesResult => getGtmInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dns.GetGtmInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alidnsGtmInstanceId1", ids.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetGtmInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DnsFunctions.getGtmInstances();
     *         ctx.export("alidnsGtmInstanceId1", ids.applyValue(getGtmInstancesResult -> getGtmInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dns:getGtmInstances
     *       Arguments: {}
     * outputs:
     *   alidnsGtmInstanceId1: ${ids.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGtmInstances.
     * @return A collection of values returned by getGtmInstances.
     */
    public suspend fun getGtmInstances(argument: GetGtmInstancesPlainArgs): GetGtmInstancesResult =
        getGtmInstancesResultToKotlin(getGtmInstancesPlain(argument.toJava()).await())

    /**
     * @see [getGtmInstances].
     * @param ids A list of Gtm Instance IDs.
     * @param lang The lang.
     * @param resourceGroupId The ID of the resource group.
     * @return A collection of values returned by getGtmInstances.
     */
    public suspend fun getGtmInstances(
        ids: List<String>? = null,
        lang: String? = null,
        resourceGroupId: String? = null,
    ): GetGtmInstancesResult {
        val argument = GetGtmInstancesPlainArgs(
            ids = ids,
            lang = lang,
            resourceGroupId = resourceGroupId,
        )
        return getGtmInstancesResultToKotlin(getGtmInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGtmInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetGtmInstancesPlainArgs].
     * @return A collection of values returned by getGtmInstances.
     */
    public suspend fun getGtmInstances(argument: suspend GetGtmInstancesPlainArgsBuilder.() -> Unit): GetGtmInstancesResult {
        val builder = GetGtmInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGtmInstancesResultToKotlin(getGtmInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:**  This resource has been renamed to alicloud.dns.getAlidnsInstances from version 1.95.0.
     * This data source provides a list of DNS instances in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:**  Available in 1.84.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.dns.getInstances({
     *     ids: ["dns-cn-oew1npk****"],
     * });
     * export const firstInstanceId = example.then(example => example.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.dns.get_instances(ids=["dns-cn-oew1npk****"])
     * pulumi.export("firstInstanceId", example.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Dns.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "dns-cn-oew1npk****",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceId"] = example&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := dns.GetInstances(ctx, &dns.GetInstancesArgs{
     * 			Ids: []string{
     * 				"dns-cn-oew1npk****",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceId", example.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DnsFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids("dns-cn-oew1npk****")
     *             .build());
     *         ctx.export("firstInstanceId", example.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:dns:getInstances
     *       Arguments:
     *         ids:
     *           - dns-cn-oew1npk****
     * outputs:
     *   firstInstanceId: ${example.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param domainType
     * @param ids A list of instance IDs.
     * @param lang
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param userClientIp
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        domainType: String? = null,
        ids: List<String>? = null,
        lang: String? = null,
        outputFile: String? = null,
        userClientIp: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            domainType = domainType,
            ids = ids,
            lang = lang,
            outputFile = outputFile,
            userClientIp = userClientIp,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of DNS Domain Records in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available since v1.0.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const recordsDs = alicloud.dns.getRecords({
     *     domainName: "xiaozhu.top",
     *     isLocked: false,
     *     type: "A",
     *     hostRecordRegex: "^@",
     *     outputFile: "records.txt",
     * });
     * export const firstRecordId = recordsDs.then(recordsDs => recordsDs.records?.[0]?.recordId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * records_ds = alicloud.dns.get_records(domain_name="xiaozhu.top",
     *     is_locked=False,
     *     type="A",
     *     host_record_regex="^@",
     *     output_file="records.txt")
     * pulumi.export("firstRecordId", records_ds.records[0].record_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var recordsDs = AliCloud.Dns.GetRecords.Invoke(new()
     *     {
     *         DomainName = "xiaozhu.top",
     *         IsLocked = false,
     *         Type = "A",
     *         HostRecordRegex = "^@",
     *         OutputFile = "records.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRecordId"] = recordsDs&#46;Apply(getRecordsResult => getRecordsResult&#46;Records[0]?.RecordId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		recordsDs, err := dns.GetRecords(ctx, &dns.GetRecordsArgs{
     * 			DomainName:      "xiaozhu.top",
     * 			IsLocked:        pulumi.BoolRef(false),
     * 			Type:            pulumi.StringRef("A"),
     * 			HostRecordRegex: pulumi.StringRef("^@"),
     * 			OutputFile:      pulumi.StringRef("records.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRecordId", recordsDs.Records[0].RecordId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetRecordsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var recordsDs = DnsFunctions.getRecords(GetRecordsArgs.builder()
     *             .domainName("xiaozhu.top")
     *             .isLocked(false)
     *             .type("A")
     *             .hostRecordRegex("^@")
     *             .outputFile("records.txt")
     *             .build());
     *         ctx.export("firstRecordId", recordsDs.applyValue(getRecordsResult -> getRecordsResult.records()[0].recordId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   recordsDs:
     *     fn::invoke:
     *       Function: alicloud:dns:getRecords
     *       Arguments:
     *         domainName: xiaozhu.top
     *         isLocked: false
     *         type: A
     *         hostRecordRegex: ^@
     *         outputFile: records.txt
     * outputs:
     *   firstRecordId: ${recordsDs.records[0].recordId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRecords.
     * @return A collection of values returned by getRecords.
     */
    public suspend fun getRecords(argument: GetRecordsPlainArgs): GetRecordsResult =
        getRecordsResultToKotlin(getRecordsPlain(argument.toJava()).await())

    /**
     * @see [getRecords].
     * @param domainName The domain name associated to the records.
     * @param hostRecordRegex Host record regex.
     * @param ids A list of record IDs.
     * @param isLocked Whether the record is locked or not.
     * @param line ISP line. Valid items are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/doc-detail/29807.htm)
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Record status. Valid items are `ENABLE` and `DISABLE`.
     * @param type Record type. Valid items are `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
     * @param valueRegex Host record value regex.
     * @return A collection of values returned by getRecords.
     */
    public suspend fun getRecords(
        domainName: String,
        hostRecordRegex: String? = null,
        ids: List<String>? = null,
        isLocked: Boolean? = null,
        line: String? = null,
        outputFile: String? = null,
        status: String? = null,
        type: String? = null,
        valueRegex: String? = null,
    ): GetRecordsResult {
        val argument = GetRecordsPlainArgs(
            domainName = domainName,
            hostRecordRegex = hostRecordRegex,
            ids = ids,
            isLocked = isLocked,
            line = line,
            outputFile = outputFile,
            status = status,
            type = type,
            valueRegex = valueRegex,
        )
        return getRecordsResultToKotlin(getRecordsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRecords].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetRecordsPlainArgs].
     * @return A collection of values returned by getRecords.
     */
    public suspend fun getRecords(argument: suspend GetRecordsPlainArgsBuilder.() -> Unit): GetRecordsResult {
        val builder = GetRecordsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRecordsResultToKotlin(getRecordsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of DNS Resolution Lines in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.60.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const resolutionLinesDs = alicloud.dns.getResolutionLines({
     *     lineCodes: ["cn_unicom_shanxi"],
     *     outputFile: "support_lines.txt",
     * });
     * export const firstLineCode = resolutionLinesDs.then(resolutionLinesDs => resolutionLinesDs.lines?.[0]?.lineCode);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * resolution_lines_ds = alicloud.dns.get_resolution_lines(line_codes=["cn_unicom_shanxi"],
     *     output_file="support_lines.txt")
     * pulumi.export("firstLineCode", resolution_lines_ds.lines[0].line_code)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var resolutionLinesDs = AliCloud.Dns.GetResolutionLines.Invoke(new()
     *     {
     *         LineCodes = new[]
     *         {
     *             "cn_unicom_shanxi",
     *         },
     *         OutputFile = "support_lines.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstLineCode"] = resolutionLinesDs&#46;Apply(getResolutionLinesResult => getResolutionLinesResult&#46;Lines[0]?.LineCode),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		resolutionLinesDs, err := dns.GetResolutionLines(ctx, &dns.GetResolutionLinesArgs{
     * 			LineCodes: []string{
     * 				"cn_unicom_shanxi",
     * 			},
     * 			OutputFile: pulumi.StringRef("support_lines.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstLineCode", resolutionLinesDs.Lines[0].LineCode)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dns.DnsFunctions;
     * import com.pulumi.alicloud.dns.inputs.GetResolutionLinesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var resolutionLinesDs = DnsFunctions.getResolutionLines(GetResolutionLinesArgs.builder()
     *             .lineCodes("cn_unicom_shanxi")
     *             .outputFile("support_lines.txt")
     *             .build());
     *         ctx.export("firstLineCode", resolutionLinesDs.applyValue(getResolutionLinesResult -> getResolutionLinesResult.lines()[0].lineCode()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   resolutionLinesDs:
     *     fn::invoke:
     *       Function: alicloud:dns:getResolutionLines
     *       Arguments:
     *         lineCodes:
     *           - cn_unicom_shanxi
     *         outputFile: support_lines.txt
     * outputs:
     *   firstLineCode: ${resolutionLinesDs.lines[0].lineCode}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResolutionLines.
     * @return A collection of values returned by getResolutionLines.
     */
    public suspend fun getResolutionLines(argument: GetResolutionLinesPlainArgs): GetResolutionLinesResult =
        getResolutionLinesResultToKotlin(getResolutionLinesPlain(argument.toJava()).await())

    /**
     * @see [getResolutionLines].
     * @param domainName Domain Name.
     * @param lang language.
     * @param lineCodes A list of lines codes.
     * @param lineDisplayNames A list of line display names.
     * @param lineNames
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param userClientIp The ip of user client.
     * @return A collection of values returned by getResolutionLines.
     */
    public suspend fun getResolutionLines(
        domainName: String? = null,
        lang: String? = null,
        lineCodes: List<String>? = null,
        lineDisplayNames: List<String>? = null,
        lineNames: List<String>? = null,
        outputFile: String? = null,
        userClientIp: String? = null,
    ): GetResolutionLinesResult {
        val argument = GetResolutionLinesPlainArgs(
            domainName = domainName,
            lang = lang,
            lineCodes = lineCodes,
            lineDisplayNames = lineDisplayNames,
            lineNames = lineNames,
            outputFile = outputFile,
            userClientIp = userClientIp,
        )
        return getResolutionLinesResultToKotlin(getResolutionLinesPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolutionLines].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dns&#46;kotlin&#46;inputs&#46;GetResolutionLinesPlainArgs].
     * @return A collection of values returned by getResolutionLines.
     */
    public suspend fun getResolutionLines(argument: suspend GetResolutionLinesPlainArgsBuilder.() -> Unit): GetResolutionLinesResult {
        val builder = GetResolutionLinesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolutionLinesResultToKotlin(getResolutionLinesPlain(builtArgument.toJava()).await())
    }
}
