@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated in favour of DnsDomain
""",
)
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.dns.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.dns.AlidnsDomain from version 1.95.0.
 * Provides a DNS resource.
 * > **NOTE:** The domain name which you want to add must be already registered and had not added by another account. Every domain name can only exist in a unique group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a new Domain.
 * const dns = new alicloud.dns.Domain("dns", {
 *     name: "starmove.com",
 *     groupId: "85ab8713-4a30-4de4-9d20-155ff830f651",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a new Domain.
 * dns = alicloud.dns.Domain("dns",
 *     name="starmove.com",
 *     group_id="85ab8713-4a30-4de4-9d20-155ff830f651")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a new Domain.
 *     var dns = new AliCloud.Dns.Domain("dns", new()
 *     {
 *         Name = "starmove.com",
 *         GroupId = "85ab8713-4a30-4de4-9d20-155ff830f651",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a new Domain.
 * 		_, err := dns.NewDomain(ctx, "dns", &dns.DomainArgs{
 * 			Name:    pulumi.String("starmove.com"),
 * 			GroupId: pulumi.String("85ab8713-4a30-4de4-9d20-155ff830f651"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.Domain;
 * import com.pulumi.alicloud.dns.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a new Domain.
 *         var dns = new Domain("dns", DomainArgs.builder()
 *             .name("starmove.com")
 *             .groupId("85ab8713-4a30-4de4-9d20-155ff830f651")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a new Domain.
 *   dns:
 *     type: alicloud:dns:Domain
 *     properties:
 *       name: starmove.com
 *       groupId: 85ab8713-4a30-4de4-9d20-155ff830f651
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS can be imported using the id or domain name, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/domain:Domain example "aliyun.com"
 * ```
 */
@Deprecated(
    message = """
This resource has been deprecated in favour of DnsDomain
""",
)
public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * A list of the dns server name.
     */
    public val dnsServers: Output<List<String>>
        get() = javaResource.dnsServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The domain ID.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Id of the group in which the domain will add. If not supplied, then use default group.
     */
    public val groupId: Output<String>?
        get() = javaResource.groupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Id of resource group which the dns belongs.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.dns.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
@Deprecated(
    message = """
This resource has been deprecated in favour of DnsDomain
""",
)
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
@Deprecated(
    message = """
This resource has been deprecated in favour of DnsDomain
""",
)
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
