@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.DomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:** This resource has been renamed to alicloud.dns.AlidnsDomain from version 1.95.0.
 * Provides a DNS resource.
 * > **NOTE:** The domain name which you want to add must be already registered and had not added by another account. Every domain name can only exist in a unique group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a new Domain.
 * const dns = new alicloud.dns.Domain("dns", {
 *     name: "starmove.com",
 *     groupId: "85ab8713-4a30-4de4-9d20-155ff830f651",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a new Domain.
 * dns = alicloud.dns.Domain("dns",
 *     name="starmove.com",
 *     group_id="85ab8713-4a30-4de4-9d20-155ff830f651")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a new Domain.
 *     var dns = new AliCloud.Dns.Domain("dns", new()
 *     {
 *         Name = "starmove.com",
 *         GroupId = "85ab8713-4a30-4de4-9d20-155ff830f651",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a new Domain.
 * 		_, err := dns.NewDomain(ctx, "dns", &dns.DomainArgs{
 * 			Name:    pulumi.String("starmove.com"),
 * 			GroupId: pulumi.String("85ab8713-4a30-4de4-9d20-155ff830f651"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.Domain;
 * import com.pulumi.alicloud.dns.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a new Domain.
 *         var dns = new Domain("dns", DomainArgs.builder()
 *             .name("starmove.com")
 *             .groupId("85ab8713-4a30-4de4-9d20-155ff830f651")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a new Domain.
 *   dns:
 *     type: alicloud:dns:Domain
 *     properties:
 *       name: starmove.com
 *       groupId: 85ab8713-4a30-4de4-9d20-155ff830f651
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS can be imported using the id or domain name, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/domain:Domain example "aliyun.com"
 * ```
 * @property groupId Id of the group in which the domain will add. If not supplied, then use default group.
 * @property name Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
 * @property resourceGroupId The Id of resource group which the dns belongs.
 */
public data class DomainArgs
@Deprecated(
    message = """
This resource has been deprecated in favour of DnsDomain
""",
)
constructor(
    public val groupId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.DomainArgs =
        com.pulumi.alicloud.dns.DomainArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated in favour of DnsDomain
""",
)
public class DomainArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    /**
     * @param value Id of the group in which the domain will add. If not supplied, then use default group.
     */
    @JvmName("esehjsunkqweenex")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("dpcglgaqrxwiwwha")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Id of resource group which the dns belongs.
     */
    @JvmName("mtbvetaylbxpjxjv")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Id of the group in which the domain will add. If not supplied, then use default group.
     */
    @JvmName("yrprkgmqhmnlgfqa")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("isypxtbprjyjwqad")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Id of resource group which the dns belongs.
     */
    @JvmName("oeliquwuawrlhalm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        groupId = groupId,
        name = name,
        resourceGroupId = resourceGroupId,
    )
}
