@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DomainAttachment].
 */
@PulumiTagMarker
public class DomainAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainAttachmentArgs = DomainAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainAttachmentArgsBuilder.() -> Unit) {
        val builder = DomainAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainAttachment {
        val builtJavaResource = com.pulumi.alicloud.dns.DomainAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainAttachment(builtJavaResource)
    }
}

/**
 * Provides bind the domain name to the DNS instance resource.
 * > **NOTE:** Available in v1.80.0+.
 * > **DEPRECATED:**  This resource has been deprecated from version `1.99.0`. Please use new resource alicloud_alidns_domain_attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const dns = new alicloud.dns.DomainAttachment("dns", {
 *     instanceId: "dns-cn-mp91lyq9xxxx",
 *     domainNames: [
 *         "test111.abc",
 *         "test222.abc",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * dns = alicloud.dns.DomainAttachment("dns",
 *     instance_id="dns-cn-mp91lyq9xxxx",
 *     domain_names=[
 *         "test111.abc",
 *         "test222.abc",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dns = new AliCloud.Dns.DomainAttachment("dns", new()
 *     {
 *         InstanceId = "dns-cn-mp91lyq9xxxx",
 *         DomainNames = new[]
 *         {
 *             "test111.abc",
 *             "test222.abc",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewDomainAttachment(ctx, "dns", &dns.DomainAttachmentArgs{
 * 			InstanceId: pulumi.String("dns-cn-mp91lyq9xxxx"),
 * 			DomainNames: pulumi.StringArray{
 * 				pulumi.String("test111.abc"),
 * 				pulumi.String("test222.abc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DomainAttachment;
 * import com.pulumi.alicloud.dns.DomainAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dns = new DomainAttachment("dns", DomainAttachmentArgs.builder()
 *             .instanceId("dns-cn-mp91lyq9xxxx")
 *             .domainNames(
 *                 "test111.abc",
 *                 "test222.abc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dns:
 *     type: alicloud:dns:DomainAttachment
 *     properties:
 *       instanceId: dns-cn-mp91lyq9xxxx
 *       domainNames:
 *         - test111.abc
 *         - test222.abc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS domain attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/domainAttachment:DomainAttachment example dns-cn-v0h1ldjhxxx
 * ```
 */
public class DomainAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.DomainAttachment,
) : KotlinCustomResource(javaResource, DomainAttachmentMapper) {
    /**
     * The domain names bound to the DNS instance.
     */
    public val domainNames: Output<List<String>>
        get() = javaResource.domainNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The id of the DNS instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })
}

public object DomainAttachmentMapper : ResourceMapper<DomainAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.DomainAttachment::class == javaResource::class

    override fun map(javaResource: Resource): DomainAttachment = DomainAttachment(
        javaResource as
            com.pulumi.alicloud.dns.DomainAttachment,
    )
}

/**
 * @see [DomainAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainAttachment].
 */
public suspend fun domainAttachment(
    name: String,
    block: suspend DomainAttachmentResourceBuilder.() -> Unit,
): DomainAttachment {
    val builder = DomainAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainAttachment(name: String): DomainAttachment {
    val builder = DomainAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
