@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.DomainAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides bind the domain name to the DNS instance resource.
 * > **NOTE:** Available in v1.80.0+.
 * > **DEPRECATED:**  This resource has been deprecated from version `1.99.0`. Please use new resource alicloud_alidns_domain_attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const dns = new alicloud.dns.DomainAttachment("dns", {
 *     instanceId: "dns-cn-mp91lyq9xxxx",
 *     domainNames: [
 *         "test111.abc",
 *         "test222.abc",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * dns = alicloud.dns.DomainAttachment("dns",
 *     instance_id="dns-cn-mp91lyq9xxxx",
 *     domain_names=[
 *         "test111.abc",
 *         "test222.abc",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dns = new AliCloud.Dns.DomainAttachment("dns", new()
 *     {
 *         InstanceId = "dns-cn-mp91lyq9xxxx",
 *         DomainNames = new[]
 *         {
 *             "test111.abc",
 *             "test222.abc",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewDomainAttachment(ctx, "dns", &dns.DomainAttachmentArgs{
 * 			InstanceId: pulumi.String("dns-cn-mp91lyq9xxxx"),
 * 			DomainNames: pulumi.StringArray{
 * 				pulumi.String("test111.abc"),
 * 				pulumi.String("test222.abc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DomainAttachment;
 * import com.pulumi.alicloud.dns.DomainAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dns = new DomainAttachment("dns", DomainAttachmentArgs.builder()
 *             .instanceId("dns-cn-mp91lyq9xxxx")
 *             .domainNames(
 *                 "test111.abc",
 *                 "test222.abc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dns:
 *     type: alicloud:dns:DomainAttachment
 *     properties:
 *       instanceId: dns-cn-mp91lyq9xxxx
 *       domainNames:
 *         - test111.abc
 *         - test222.abc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS domain attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/domainAttachment:DomainAttachment example dns-cn-v0h1ldjhxxx
 * ```
 * @property domainNames The domain names bound to the DNS instance.
 * @property instanceId The id of the DNS instance.
 */
public data class DomainAttachmentArgs(
    public val domainNames: Output<List<String>>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.DomainAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.DomainAttachmentArgs =
        com.pulumi.alicloud.dns.DomainAttachmentArgs.builder()
            .domainNames(domainNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAttachmentArgs].
 */
@PulumiTagMarker
public class DomainAttachmentArgsBuilder internal constructor() {
    private var domainNames: Output<List<String>>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value The domain names bound to the DNS instance.
     */
    @JvmName("hsruobjkpeywesvl")
    public suspend fun domainNames(`value`: Output<List<String>>) {
        this.domainNames = value
    }

    @JvmName("yxdcyqjwvnhobnad")
    public suspend fun domainNames(vararg values: Output<String>) {
        this.domainNames = Output.all(values.asList())
    }

    /**
     * @param values The domain names bound to the DNS instance.
     */
    @JvmName("hjoyjlodnyuqhchu")
    public suspend fun domainNames(values: List<Output<String>>) {
        this.domainNames = Output.all(values)
    }

    /**
     * @param value The id of the DNS instance.
     */
    @JvmName("vvsbophbplduutoa")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The domain names bound to the DNS instance.
     */
    @JvmName("dbfeciukcidggqhp")
    public suspend fun domainNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNames = mapped
    }

    /**
     * @param values The domain names bound to the DNS instance.
     */
    @JvmName("cgkwvofgkodwwsdd")
    public suspend fun domainNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNames = mapped
    }

    /**
     * @param value The id of the DNS instance.
     */
    @JvmName("bobdpbgspdbxnxcp")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): DomainAttachmentArgs = DomainAttachmentArgs(
        domainNames = domainNames,
        instanceId = instanceId,
    )
}
