@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainGroup].
 */
@PulumiTagMarker
public class DomainGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainGroupArgs = DomainGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainGroupArgsBuilder.() -> Unit) {
        val builder = DomainGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainGroup {
        val builtJavaResource = com.pulumi.alicloud.dns.DomainGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainGroup(builtJavaResource)
    }
}

/**
 * Provides a Alidns Domain Group resource. For information about Alidns Domain Group and how to use it, see [What is Resource Alidns Domain Group](https://www.alibabacloud.com/help/en/doc-detail/29762.htm).
 * > **NOTE:** Available since v1.84.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dns.DomainGroup("default", {domainGroupName: "tf-example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dns.DomainGroup("default", domain_group_name="tf-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dns.DomainGroup("default", new()
 *     {
 *         DomainGroupName = "tf-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewDomainGroup(ctx, "default", &dns.DomainGroupArgs{
 * 			DomainGroupName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DomainGroup;
 * import com.pulumi.alicloud.dns.DomainGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DomainGroup("default", DomainGroupArgs.builder()
 *             .domainGroupName("tf-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dns:DomainGroup
 *     properties:
 *       domainGroupName: tf-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns domain group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/domainGroup:DomainGroup example 0932eb3ddee7499085c4d13d45*****
 * ```
 */
public class DomainGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.DomainGroup,
) : KotlinCustomResource(javaResource, DomainGroupMapper) {
    /**
     * The Name of the domain group. The `domain_group_name` is required when the value of the `group_name`  is Empty.
     */
    public val domainGroupName: Output<String>
        get() = javaResource.domainGroupName().applyValue({ args0 -> args0 })

    /**
     * The Name of the domain group. The `group_name` has been deprecated from provider version 1.97.0. Please use `domain_group_name` instead.
     */
    @Deprecated(
        message = """
  Field 'group_name' has been deprecated from version 1.97.0. Use 'domain_group_name' instead.
  """,
    )
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * User language.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DomainGroupMapper : ResourceMapper<DomainGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.DomainGroup::class == javaResource::class

    override fun map(javaResource: Resource): DomainGroup = DomainGroup(
        javaResource as
            com.pulumi.alicloud.dns.DomainGroup,
    )
}

/**
 * @see [DomainGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainGroup].
 */
public suspend fun domainGroup(name: String, block: suspend DomainGroupResourceBuilder.() -> Unit): DomainGroup {
    val builder = DomainGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainGroup(name: String): DomainGroup {
    val builder = DomainGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
