@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.DomainGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Alidns Domain Group resource. For information about Alidns Domain Group and how to use it, see [What is Resource Alidns Domain Group](https://www.alibabacloud.com/help/en/doc-detail/29762.htm).
 * > **NOTE:** Available since v1.84.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.dns.DomainGroup("default", {domainGroupName: "tf-example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.dns.DomainGroup("default", domain_group_name="tf-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Dns.DomainGroup("default", new()
 *     {
 *         DomainGroupName = "tf-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewDomainGroup(ctx, "default", &dns.DomainGroupArgs{
 * 			DomainGroupName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.DomainGroup;
 * import com.pulumi.alicloud.dns.DomainGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DomainGroup("default", DomainGroupArgs.builder()
 *             .domainGroupName("tf-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:dns:DomainGroup
 *     properties:
 *       domainGroupName: tf-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns domain group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/domainGroup:DomainGroup example 0932eb3ddee7499085c4d13d45*****
 * ```
 * @property domainGroupName The Name of the domain group. The `domain_group_name` is required when the value of the `group_name`  is Empty.
 * @property groupName The Name of the domain group. The `group_name` has been deprecated from provider version 1.97.0. Please use `domain_group_name` instead.
 * @property lang User language.
 */
public data class DomainGroupArgs(
    public val domainGroupName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'group_name' has been deprecated from version 1.97.0. Use 'domain_group_name' instead.
  """,
    )
    public val groupName: Output<String>? = null,
    public val lang: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.DomainGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.DomainGroupArgs =
        com.pulumi.alicloud.dns.DomainGroupArgs.builder()
            .domainGroupName(domainGroupName?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainGroupArgs].
 */
@PulumiTagMarker
public class DomainGroupArgsBuilder internal constructor() {
    private var domainGroupName: Output<String>? = null

    private var groupName: Output<String>? = null

    private var lang: Output<String>? = null

    /**
     * @param value The Name of the domain group. The `domain_group_name` is required when the value of the `group_name`  is Empty.
     */
    @JvmName("uoryugkufkecmsal")
    public suspend fun domainGroupName(`value`: Output<String>) {
        this.domainGroupName = value
    }

    /**
     * @param value The Name of the domain group. The `group_name` has been deprecated from provider version 1.97.0. Please use `domain_group_name` instead.
     */
    @Deprecated(
        message = """
  Field 'group_name' has been deprecated from version 1.97.0. Use 'domain_group_name' instead.
  """,
    )
    @JvmName("jthnuqeigmffvroq")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value User language.
     */
    @JvmName("mfkdmqnmpdyjxkym")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The Name of the domain group. The `domain_group_name` is required when the value of the `group_name`  is Empty.
     */
    @JvmName("sjldjiaqjkatyrgr")
    public suspend fun domainGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainGroupName = mapped
    }

    /**
     * @param value The Name of the domain group. The `group_name` has been deprecated from provider version 1.97.0. Please use `domain_group_name` instead.
     */
    @Deprecated(
        message = """
  Field 'group_name' has been deprecated from version 1.97.0. Use 'domain_group_name' instead.
  """,
    )
    @JvmName("wsqmdrbgsqbrkfpo")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("syhnwpiyxgjdacjk")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    internal fun build(): DomainGroupArgs = DomainGroupArgs(
        domainGroupName = domainGroupName,
        groupName = groupName,
        lang = lang,
    )
}
